/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationQPSolver;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ICPOptimizationSolutionHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ICPControlPlane icpControlPlane;
    private final BooleanProvider useICPControlPolygons;
    private final DoubleProvider footstepDeadband;
    private final DoubleProvider footstepSolutionResolution;
    private final YoBoolean footstepWasAdjusted;
    private final YoFrameVector2D footstepAdjustment;
    private final YoFrameVector2D clippedFootstepAdjustment;
    private final YoFrameVector2D totalFootstepAdjustment;
    private final YoDouble residualCostToGo;
    private final YoDouble costToGo;
    private final YoDouble dynamicsCostToGo;
    private final YoDouble footstepCostToGo;
    private final YoDouble copFeedbackCostToGo;
    private final YoDouble cmpFeedbackCostToGo;
    private final YoFramePoint2D adjustedICPReferenceLocation;
    private final YoFramePoint2D footstepSolutionInControlPlane;
    private final YoFrameVector2D icpErrorCompensatedFromStepAdjustment;
    private final boolean debug;
    private final FramePoint3D locationSolution = new FramePoint3D();
    private final FramePoint2D previousLocationSolution = new FramePoint2D();
    private final FramePoint2D clippedLocationSolution = new FramePoint2D();
    private final FramePoint3D solutionLocation = new FramePoint3D();
    private final FramePoint3D referenceLocation = new FramePoint3D();
    private final FramePoint3D previousLocation = new FramePoint3D();
    private final FrameVector3D solutionAdjustment = new FrameVector3D();
    private final FrameVector3D tempVector = new FrameVector3D();
    private final String yoNamePrefix;
    private final FramePoint2D referenceFootstepLocation2D = new FramePoint2D();
    private final PoseReferenceFrame deadbandFrame = new PoseReferenceFrame("DeadbandFrame", worldFrame);

    public ICPOptimizationSolutionHandler(ICPOptimizationParameters icpOptimizationParameters, YoBoolean useICPControlPolygons, String yoNamePrefix, YoRegistry registry) {
        this(null, icpOptimizationParameters, (BooleanProvider)useICPControlPolygons, false, yoNamePrefix, registry);
    }

    public ICPOptimizationSolutionHandler(ICPControlPlane icpControlPlane, ICPOptimizationParameters icpOptimizationParameters, BooleanProvider useICPControlPolygons, boolean debug, String yoNamePrefix, YoRegistry registry) {
        this.useICPControlPolygons = useICPControlPolygons;
        this.yoNamePrefix = yoNamePrefix;
        this.debug = debug;
        this.icpControlPlane = icpControlPlane;
        this.icpErrorCompensatedFromStepAdjustment = new YoFrameVector2D(yoNamePrefix + "ICPErrorCompensatedFromStepAdjustment", worldFrame, registry);
        if (debug) {
            this.residualCostToGo = new YoDouble(yoNamePrefix + "ResidualCostToGo", registry);
            this.costToGo = new YoDouble(yoNamePrefix + "CostToGo", registry);
            this.dynamicsCostToGo = new YoDouble(yoNamePrefix + "DynamicsCostToGo", registry);
            this.footstepCostToGo = new YoDouble(yoNamePrefix + "FootstepCostToGo", registry);
            this.copFeedbackCostToGo = new YoDouble(yoNamePrefix + "CoPFeedbackCostToGo", registry);
            this.cmpFeedbackCostToGo = new YoDouble(yoNamePrefix + "CMPFeedbackCostToGo", registry);
        } else {
            this.residualCostToGo = null;
            this.dynamicsCostToGo = null;
            this.costToGo = null;
            this.footstepCostToGo = null;
            this.copFeedbackCostToGo = null;
            this.cmpFeedbackCostToGo = null;
        }
        this.footstepDeadband = new DoubleParameter(yoNamePrefix + "FootstepDeadband", registry, icpOptimizationParameters.getAdjustmentDeadband());
        this.footstepSolutionResolution = new DoubleParameter(yoNamePrefix + "FootstepSolutionResolution", registry, icpOptimizationParameters.getFootstepSolutionResolution());
        this.footstepWasAdjusted = new YoBoolean(yoNamePrefix + "FootstepWasAdjusted", registry);
        this.footstepAdjustment = new YoFrameVector2D(yoNamePrefix + "FootstepAdjustment", worldFrame, registry);
        this.clippedFootstepAdjustment = new YoFrameVector2D(yoNamePrefix + "ClippedFootstepAdjustment", worldFrame, registry);
        this.totalFootstepAdjustment = new YoFrameVector2D(yoNamePrefix + "TotalFootstepAdjustment", worldFrame, registry);
        this.adjustedICPReferenceLocation = new YoFramePoint2D(yoNamePrefix + "AdjustedICPReferenceLocation", worldFrame, registry);
        this.footstepSolutionInControlPlane = new YoFramePoint2D(yoNamePrefix + "FootstepSolutionReturned", worldFrame, registry);
    }

    public void setupVisualizers(ArtifactList artifactList) {
        YoGraphicPosition adjustedICP = new YoGraphicPosition(this.yoNamePrefix + "AdjustedICPReferenceLocation", this.adjustedICPReferenceLocation, 0.01, YoAppearance.LightYellow(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoGraphicPosition footstepPositionInControlPlane = new YoGraphicPosition(this.yoNamePrefix + "FootstepSolutionInControlPlane", this.footstepSolutionInControlPlane, 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.SOLID_BALL);
        artifactList.add((Artifact)adjustedICP.createArtifact());
        artifactList.add((Artifact)footstepPositionInControlPlane.createArtifact());
    }

    public void updateCostsToGo(ICPOptimizationQPSolver solver) {
        if (this.debug) {
            this.residualCostToGo.set(solver.getCostToGo());
            this.dynamicsCostToGo.set(solver.getDynamicsCostToGo());
            this.costToGo.set(solver.getCostToGo());
            this.footstepCostToGo.set(solver.getFootstepCostToGo());
            this.copFeedbackCostToGo.set(solver.getCoPFeedbackCostToGo());
            this.cmpFeedbackCostToGo.set(solver.getCMPFeedbackCostToGo());
        }
    }

    public void extractFootstepSolution(FixedFramePose3DBasics footstepSolutionToPack, FixedFrameTuple2DBasics unclippedFootstepSolutionToPack, FramePose3DReadOnly upcomingFootstep, PlanarRegion activePlanarRegion, ICPOptimizationQPSolver solver) {
        this.referenceFootstepLocation2D.set((FrameTuple3DReadOnly)upcomingFootstep.getPosition());
        solver.getFootstepSolutionLocation(0, (FixedFramePoint2DBasics)this.footstepSolutionInControlPlane);
        this.icpErrorCompensatedFromStepAdjustment.sub((FrameTuple2DReadOnly)this.footstepSolutionInControlPlane, (FrameTuple2DReadOnly)this.referenceFootstepLocation2D);
        this.icpErrorCompensatedFromStepAdjustment.scale(solver.getFootstepRecursionMultiplier() / solver.getFootstepAdjustmentSafetyFactor());
        if (this.useICPControlPolygons.getValue() && this.icpControlPlane != null) {
            if (activePlanarRegion == null) {
                this.icpControlPlane.projectPointFromControlPlaneOntoSurface(worldFrame, (FramePoint2DReadOnly)this.footstepSolutionInControlPlane, (FramePoint3DBasics)this.locationSolution, upcomingFootstep.getPosition().getZ());
            } else {
                this.icpControlPlane.projectPointFromControlPlaneOntoPlanarRegion(worldFrame, (FramePoint2DReadOnly)this.footstepSolutionInControlPlane, this.locationSolution, activePlanarRegion);
            }
        } else {
            this.locationSolution.set((FrameTuple2DReadOnly)this.footstepSolutionInControlPlane);
        }
        this.deadbandFrame.setPoseAndUpdate(upcomingFootstep);
        this.previousLocationSolution.set((FrameTuple3DReadOnly)footstepSolutionToPack.getPosition());
        this.clippedLocationSolution.set((FrameTuple3DReadOnly)this.locationSolution);
        boolean footstepWasAdjusted = this.applyLocationDeadband(this.clippedLocationSolution, (FramePoint2DReadOnly)this.previousLocationSolution, (FramePoint2DReadOnly)this.referenceFootstepLocation2D, (ReferenceFrame)this.deadbandFrame, this.footstepDeadband.getValue(), this.footstepSolutionResolution.getValue());
        this.footstepAdjustment.set((FrameTuple3DReadOnly)this.locationSolution);
        this.footstepAdjustment.sub((FrameTuple2DReadOnly)this.referenceFootstepLocation2D);
        this.clippedFootstepAdjustment.sub((FrameTuple2DReadOnly)this.clippedLocationSolution, (FrameTuple2DReadOnly)this.referenceFootstepLocation2D);
        this.totalFootstepAdjustment.add((FrameTuple2DReadOnly)this.clippedFootstepAdjustment);
        footstepSolutionToPack.getPosition().set((FrameTuple2DReadOnly)this.clippedLocationSolution);
        unclippedFootstepSolutionToPack.set((FrameTuple3DReadOnly)this.locationSolution);
        this.footstepWasAdjusted.set(footstepWasAdjusted);
    }

    public void zeroAdjustment() {
        this.footstepAdjustment.setToZero();
        this.clippedFootstepAdjustment.setToZero();
        this.footstepWasAdjusted.set(false);
    }

    public void resetAdjustment() {
        this.zeroAdjustment();
        this.totalFootstepAdjustment.setToZero();
    }

    public void updateVisualizers(FramePoint2DReadOnly desiredICP, double footstepMultiplier) {
        this.adjustedICPReferenceLocation.scaleAdd(footstepMultiplier, (FrameTuple2DReadOnly)this.clippedFootstepAdjustment, (FrameTuple2DReadOnly)desiredICP);
    }

    private boolean applyLocationDeadband(FramePoint2D solutionLocationToModify, FramePoint2DReadOnly currentSolutionLocation, FramePoint2DReadOnly referenceLocation2d, ReferenceFrame deadbandFrame, double deadband, double deadbandResolution) {
        this.solutionLocation.setIncludingFrame((FrameTuple2DReadOnly)solutionLocationToModify, 0.0);
        this.referenceLocation.setIncludingFrame((FrameTuple2DReadOnly)referenceLocation2d, 0.0);
        this.previousLocation.setIncludingFrame((FrameTuple2DReadOnly)currentSolutionLocation, 0.0);
        this.solutionLocation.changeFrame(worldFrame);
        this.referenceLocation.changeFrame(worldFrame);
        this.previousLocation.changeFrame(worldFrame);
        this.solutionAdjustment.setToZero(worldFrame);
        this.solutionAdjustment.sub((FrameTuple3DReadOnly)this.solutionLocation, (FrameTuple3DReadOnly)this.referenceLocation);
        this.solutionAdjustment.changeFrame(deadbandFrame);
        boolean wasAdjusted = false;
        if (this.solutionAdjustment.length() < deadband) {
            this.referenceLocation.changeFrame(solutionLocationToModify.getReferenceFrame());
            solutionLocationToModify.set((FrameTuple3DReadOnly)this.referenceLocation);
            return false;
        }
        this.tempVector.setIncludingFrame((FrameTuple3DReadOnly)this.solutionAdjustment);
        this.tempVector.normalize();
        this.tempVector.scale(deadband);
        this.solutionLocation.changeFrame(deadbandFrame);
        this.solutionLocation.sub((FrameTuple3DReadOnly)this.tempVector);
        this.solutionLocation.changeFrame(worldFrame);
        this.tempVector.setToZero(worldFrame);
        this.tempVector.sub((FrameTuple3DReadOnly)this.solutionLocation, (FrameTuple3DReadOnly)this.previousLocation);
        this.tempVector.changeFrame(deadbandFrame);
        if (this.tempVector.length() < deadbandResolution) {
            this.solutionLocation.set(this.previousLocation);
        } else {
            wasAdjusted = true;
        }
        this.solutionLocation.changeFrame(solutionLocationToModify.getReferenceFrame());
        solutionLocationToModify.set((FrameTuple3DReadOnly)this.solutionLocation);
        return wasAdjusted;
    }

    public boolean wasFootstepAdjusted() {
        return this.footstepWasAdjusted.getBooleanValue();
    }

    public void setFootstepWasAdjustedBySnapper(boolean footstepWasAdjusted) {
        if (footstepWasAdjusted) {
            this.footstepWasAdjusted.set(true);
        }
    }

    public FrameVector2DReadOnly getFootstepAdjustment() {
        return this.footstepAdjustment;
    }

    public FrameVector2DReadOnly getClippedFootstepAdjustment() {
        return this.clippedFootstepAdjustment;
    }

    public FrameVector2DReadOnly getTotalFootstepAdjustment() {
        return this.totalFootstepAdjustment;
    }
}

