/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ParameterizedICPControlGains;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationCoPConstraintHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationControllerHelper;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationControllerInterface;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationQPSolver;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationReachabilityConstraintHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationSolutionHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.PlanarRegionConstraintProvider;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.humanoidRobotics.footstep.SimpleFootstep;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.math.frames.YoMatrix;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class ICPOptimizationController
implements ICPOptimizationControllerInterface {
    private static final boolean VISUALIZE = true;
    private static final boolean DEBUG = true;
    private static final boolean COMPUTE_COST_TO_GO = false;
    private static final boolean CONTINUOUSLY_UPDATE_DESIRED_POSITION = true;
    private static final String yoNamePrefix = "controller";
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BooleanProvider allowStepAdjustment;
    private final YoBoolean includeFootsteps = new YoBoolean("controllerIncludeFootsteps", this.registry);
    private final YoBoolean useStepAdjustment = new YoBoolean("controllerUseStepAdjustment", this.registry);
    private final YoBoolean footstepIsAdjustable = new YoBoolean("controllerFootstepIsAdjustable", this.registry);
    private final BooleanProvider useCMPFeedback;
    private final BooleanProvider useAngularMomentum;
    private final BooleanProvider scaleStepRateWeightWithTime;
    private final BooleanProvider scaleFeedbackWeightWithGain;
    private final YoBoolean isStationary = new YoBoolean("controllerIsStationary", this.registry);
    private final YoBoolean isInDoubleSupport = new YoBoolean("controllerIsInDoubleSupport", this.registry);
    private final YoDouble swingDuration = new YoDouble("controllerSwingDuration", this.registry);
    private final YoDouble transferDuration = new YoDouble("controllerTransferDuration", this.registry);
    private final YoDouble nextTransferDuration = new YoDouble("controllerNextTransferDuration", this.registry);
    private final YoDouble finalTransferDuration = new YoDouble("controllerFinalTransferDuration", this.registry);
    private final DoubleProvider transferDurationSplitFraction;
    private final YoEnum<RobotSide> transferToSide = new YoEnum("controllerTransferToSide", this.registry, RobotSide.class, true);
    private final YoEnum<RobotSide> supportSide = new YoEnum("controllerSupportSide", this.registry, RobotSide.class, true);
    private final YoDouble initialTime = new YoDouble("controllerInitialTime", this.registry);
    private final YoDouble timeInCurrentState = new YoDouble("controllerTimeInCurrentState", this.registry);
    private final YoDouble timeRemainingInState = new YoDouble("controllerTimeRemainingInState", this.registry);
    private final DoubleProvider minimumTimeRemaining;
    private final YoFrameVector2D icpError = new YoFrameVector2D("controllerICPError", "", worldFrame, this.registry);
    private final YoFramePoint2D feedbackCoP = new YoFramePoint2D("controllerFeedbackCoPSolution", worldFrame, this.registry);
    private final YoFramePoint2D feedbackCMP = new YoFramePoint2D("controllerFeedbackCMPSolution", worldFrame, this.registry);
    private final YoFramePoint2D yoPerfectCoP = new YoFramePoint2D("controllerPerfectCoP", worldFrame, this.registry);
    private final YoFramePoint2D yoPerfectCMP = new YoFramePoint2D("controllerPerfectCMP", worldFrame, this.registry);
    private final YoFramePoint2D predictedEndOfStateICP = new YoFramePoint2D("controllerPredictedEndOfStateICP", worldFrame, this.registry);
    private final YoDouble currentICPVelocityMagnitude = new YoDouble("controllerICPVelocityMagnitude", this.registry);
    private final YoFrameVector2D feedbackCoPDelta = new YoFrameVector2D("controllerFeedbackCoPDeltaSolution", worldFrame, this.registry);
    private final YoFrameVector2D feedbackCMPDelta = new YoFrameVector2D("controllerFeedbackCMPDeltaSolution", worldFrame, this.registry);
    private final YoFrameVector2D dynamicsError = new YoFrameVector2D("controllerDynamicsError", worldFrame, this.registry);
    private final YoInteger numberOfRegisteredSteps = new YoInteger("controllerNumberOfRegisteredSteps", this.registry);
    private final YoFramePose3D upcomingFootstep = new YoFramePose3D("controllerUpcomingFootstepPose", worldFrame, this.registry);
    private final YoEnum<RobotSide> upcomingFootstepSide = new YoEnum("controllerUpcomingFootstepSide", this.registry, RobotSide.class);
    private final RecyclingArrayList<Point2D> upcomingFootstepContactPoints = new RecyclingArrayList(Point2D.class);
    private final YoFramePose3D footstepSolution = new YoFramePose3D("controllerFootstepSolutionLocation", worldFrame, this.registry);
    private final YoFramePoint2D footstepLocationSubmitted = new YoFramePoint2D("controllerFootstepLocationSubmitted", worldFrame, this.registry);
    private final YoFramePoint2D unclippedFootstepSolution = new YoFramePoint2D("controllerUnclippedFootstepSolutionLocation", worldFrame, this.registry);
    private final DoubleProvider minICPErrorForStepAdjustment;
    private final DoubleProvider fractionThroughSwingForAdjustment;
    private final DoubleProvider footstepAdjustmentSafetyFactor;
    private final DoubleProvider forwardFootstepWeight;
    private final DoubleProvider lateralFootstepWeight;
    private final YoMatrix yoFootstepWeights = new YoMatrix("controllerFootstepWeights", 2, 2, this.registry);
    private final DMatrixRMaj footstepWeights = new DMatrixRMaj(2, 2);
    private final DoubleProvider copFeedbackForwardWeight;
    private final DoubleProvider copFeedbackLateralWeight;
    private final DoubleProvider cmpFeedbackWeight;
    private final YoMatrix yoScaledCoPFeedbackWeight = new YoMatrix("controllerScaledCoPFeedbackWeight", 2, 2, this.registry);
    private final YoDouble scaledCMPFeedbackWeight = new YoDouble("controllerScaledCMPFeedbackWeight", this.registry);
    private final DMatrixRMaj scaledCoPFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DoubleProvider maxAllowedDistanceCMPSupport;
    private final DoubleProvider safeCoPDistanceToEdge;
    private final DoubleProvider feedbackRateWeight;
    private final DoubleProvider copCMPFeedbackRateWeight;
    private final DoubleProvider footstepRateWeight;
    private final YoDouble scaledFootstepRateWeight = new YoDouble("controllerScaledFootstepRateWeight", this.registry);
    private final DoubleProvider dynamicsObjectiveWeight;
    private final YoDouble cumulativeAngularMomentum = new YoDouble("controllerCumulativeAngularMomentum", this.registry);
    private final BooleanProvider limitReachabilityFromAdjustment;
    private final BooleanProvider useICPControlPolygons;
    private final boolean hasICPControlPolygons;
    private final ICPControlGainsReadOnly feedbackGains;
    private final DMatrixRMaj transformedGains = new DMatrixRMaj(2, 2);
    private final FrameVector2D transformedMagnitudeLimits = new FrameVector2D();
    private final YoInteger numberOfIterations = new YoInteger("controllerNumberOfIterations", this.registry);
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("controllerHasNotConvergedInPast", this.registry);
    private final YoBoolean previousTickFailed = new YoBoolean("controllerPreviousTickFailed", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("controllerHasNotConvergedCounts", this.registry);
    private final IntegerProvider maxNumberOfIterations = new IntegerParameter("controllerMaxNumberOfIterations", this.registry, 100);
    private final YoDouble footstepMultiplier = new YoDouble("controllerTotalFootstepMultiplier", this.registry);
    private final YoDouble recursionTime = new YoDouble("controllerRecursionTime", this.registry);
    private final YoDouble recursionMultiplier = new YoDouble("controllerRecursionMultiplier", this.registry);
    private final DoubleProvider minimumFootstepMultiplier;
    private final DoubleProvider maximumTimeFromTransfer;
    private final YoBoolean swingSpeedUpEnabled = new YoBoolean("controllerSwingSpeedUpEnabled", this.registry);
    private final YoDouble speedUpTime = new YoDouble("controllerSpeedUpTime", this.registry);
    private final BooleanProvider useAngularMomentumIntegrator;
    private final DoubleProvider angularMomentumIntegratorGain;
    private final DoubleProvider angularMomentumIntegratorLeakRatio;
    private final BooleanProvider useSmartICPIntegrator;
    private final GlitchFilteredYoBoolean isICPStuck;
    private final DoubleProvider thresholdForStuck;
    private final YoFrameVector2D feedbackCMPIntegral = new YoFrameVector2D("controllerFeedbackCMPIntegral", worldFrame, this.registry);
    private final ICPOptimizationCoPConstraintHandler copConstraintHandler;
    private final ICPOptimizationReachabilityConstraintHandler reachabilityConstraintHandler;
    private final PlanarRegionConstraintProvider planarRegionConstraintProvider;
    private final ICPOptimizationSolutionHandler solutionHandler;
    private final ICPOptimizationQPSolver solver;
    private final SideDependentList<? extends ContactablePlaneBody> contactableFeet;
    private final ICPControlPlane icpControlPlane;
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("icpQPSolverTimer", 0.5, this.registry);
    private final ExecutionTimer controllerTimer = new ExecutionTimer("icpControllerTimer", 0.5, this.registry);
    private final BooleanProvider useFootstepRate;
    private final BooleanProvider useFeedbackRate;
    private boolean localUseStepAdjustment;
    private final FramePoint3D projectedTempPoint3d = new FramePoint3D();
    private final FrameVector2D tempVector2d = new FrameVector2D();
    private final FramePoint2D desiredICP = new FramePoint2D();
    private final FrameVector2D desiredICPVelocity = new FrameVector2D();
    private final FrameVector2D perfectCMPOffset = new FrameVector2D();
    private final FramePoint2D currentICP = new FramePoint2D();
    private final FrameVector2D currentICPVelocity = new FrameVector2D();
    private final double controlDT;
    private final double controlDTSquare;
    private final DoubleProvider dynamicsObjectiveDoubleSupportWeightModifier;
    private final ICPOptimizationControllerHelper helper = new ICPOptimizationControllerHelper();
    private boolean initialized = false;
    private final BooleanProvider considerAngularMomentumInAdjustment;
    private final BooleanProvider considerFeedbackInAdjustment;
    private final FrameVector3D scaledAdjustment = new FrameVector3D();
    private final FrameVector2D desiredCMPOffsetToThrowAway = new FrameVector2D();

    public ICPOptimizationController(WalkingControllerParameters walkingControllerParameters, SideDependentList<ReferenceFrame> soleZUpFrames, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters, walkingControllerParameters.getICPOptimizationParameters(), soleZUpFrames, bipedSupportPolygons, icpControlPolygons, contactableFeet, controlDT, parentRegistry, yoGraphicsListRegistry);
    }

    public ICPOptimizationController(WalkingControllerParameters walkingControllerParameters, ICPOptimizationParameters icpOptimizationParameters, SideDependentList<ReferenceFrame> soleZUpFrames, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.controlDT = controlDT;
        this.controlDTSquare = controlDT * controlDT;
        this.contactableFeet = contactableFeet;
        this.icpControlPlane = icpControlPolygons != null ? icpControlPolygons.getIcpControlPlane() : null;
        this.hasICPControlPolygons = this.icpControlPlane != null;
        this.dynamicsObjectiveDoubleSupportWeightModifier = new DoubleParameter("controllerDynamicsObjectiveDoubleSupportWeightModifier", this.registry, icpOptimizationParameters.getDynamicsObjectiveDoubleSupportWeightModifier());
        this.useFootstepRate = new BooleanParameter("controllerUseFootstepRate", this.registry, icpOptimizationParameters.useFootstepRate());
        this.useFeedbackRate = new BooleanParameter("controllerUseFeedbackRate", this.registry, icpOptimizationParameters.useFeedbackRate());
        this.allowStepAdjustment = new BooleanParameter("controllerAllowStepAdjustment", this.registry, icpOptimizationParameters.allowStepAdjustment());
        this.useCMPFeedback = new BooleanParameter("controllerUseCMPFeedback", this.registry, icpOptimizationParameters.useCMPFeedback());
        this.useAngularMomentum = new BooleanParameter("controllerUseAngularMomentum", this.registry, icpOptimizationParameters.useAngularMomentum());
        this.scaleStepRateWeightWithTime = new BooleanParameter("controllerScaleStepRateWeightWithTime", this.registry, icpOptimizationParameters.scaleStepRateWeightWithTime());
        this.scaleFeedbackWeightWithGain = new BooleanParameter("controllerScaleFeedbackWeightWithGain", this.registry, icpOptimizationParameters.scaleFeedbackWeightWithGain());
        this.minICPErrorForStepAdjustment = new DoubleParameter("controllerMinICPErrorForStepAdjustment", this.registry, icpOptimizationParameters.getMinICPErrorForStepAdjustment());
        this.fractionThroughSwingForAdjustment = new DoubleParameter("controllerFractionThroughSwingForAdjustment", this.registry, icpOptimizationParameters.getFractionThroughSwingForAdjustment());
        this.footstepAdjustmentSafetyFactor = new DoubleParameter("controllerFootstepAdjustmentSafetyFactor", this.registry, icpOptimizationParameters.getFootstepAdjustmentSafetyFactor());
        this.forwardFootstepWeight = new DoubleParameter("controllerForwardFootstepWeight", this.registry, icpOptimizationParameters.getForwardFootstepWeight());
        this.lateralFootstepWeight = new DoubleParameter("controllerLateralFootstepWeight", this.registry, icpOptimizationParameters.getLateralFootstepWeight());
        this.footstepRateWeight = new DoubleParameter("controllerFootstepRateWeight", this.registry, icpOptimizationParameters.getFootstepRateWeight());
        this.copFeedbackForwardWeight = new DoubleParameter("controllerCoPFeedbackForwardWeight", this.registry, icpOptimizationParameters.getFeedbackForwardWeight());
        this.copFeedbackLateralWeight = new DoubleParameter("controllerCoPFeedbackLateralWeight", this.registry, icpOptimizationParameters.getFeedbackLateralWeight());
        this.copCMPFeedbackRateWeight = new DoubleParameter("controllerCoPCMPFeedbackRateWeight", this.registry, icpOptimizationParameters.getCoPCMPFeedbackRateWeight());
        this.feedbackRateWeight = new DoubleParameter("controllerFeedbackRateWeight", this.registry, icpOptimizationParameters.getFeedbackRateWeight());
        this.feedbackGains = new ParameterizedICPControlGains("", icpOptimizationParameters.getICPFeedbackGains(), this.registry);
        this.useSmartICPIntegrator = new BooleanParameter("useSmartICPIntegrator", this.registry, icpOptimizationParameters.useSmartICPIntegrator());
        this.thresholdForStuck = new DoubleParameter("controllerThresholdForStuck", this.registry, icpOptimizationParameters.getICPVelocityThresholdForStuck());
        this.dynamicsObjectiveWeight = new DoubleParameter("controllerDynamicsObjectiveWeight", this.registry, icpOptimizationParameters.getDynamicsObjectiveWeight());
        if (walkingControllerParameters != null) {
            this.swingSpeedUpEnabled.set(walkingControllerParameters.allowDisturbanceRecoveryBySpeedingUpSwing());
        }
        this.cmpFeedbackWeight = new DoubleParameter("controllerCMPFeedbackWeight", this.registry, icpOptimizationParameters.getAngularMomentumMinimizationWeight());
        this.limitReachabilityFromAdjustment = new BooleanParameter("controllerLimitReachabilityFromAdjustment", this.registry, icpOptimizationParameters.getLimitReachabilityFromAdjustment());
        this.transferDurationSplitFraction = new DoubleParameter("controllerTransferDurationSplitFraction", this.registry, icpOptimizationParameters.getTransferSplitFraction());
        this.useAngularMomentumIntegrator = new BooleanParameter("controllerUseAngularMomentumIntegrator", this.registry, icpOptimizationParameters.getUseAngularMomentumIntegrator());
        this.angularMomentumIntegratorGain = new DoubleParameter("controllerAngularMomentumIntegratorGain", this.registry, icpOptimizationParameters.getAngularMomentumIntegratorGain());
        this.angularMomentumIntegratorLeakRatio = new DoubleParameter("controllerAngularMomentumIntegratorLeakRatio", this.registry, icpOptimizationParameters.getAngularMomentumIntegratorLeakRatio());
        this.useICPControlPolygons = new BooleanParameter("controllerUseICPControlPolygons", this.registry, icpOptimizationParameters.getUseICPControlPolygons());
        this.safeCoPDistanceToEdge = new DoubleParameter("controllerSafeCoPDistanceToEdge", this.registry, icpOptimizationParameters.getSafeCoPDistanceToEdge());
        double defaultMaxAllowedDistanceCMPSupport = walkingControllerParameters != null ? walkingControllerParameters.getMaxAllowedDistanceCMPSupport() : Double.NaN;
        this.maxAllowedDistanceCMPSupport = new DoubleParameter("controllerMaxAllowedDistanceCMPSupport", this.registry, defaultMaxAllowedDistanceCMPSupport);
        this.isICPStuck = new GlitchFilteredYoBoolean("controllerIsICPStuck", this.registry, (int)(0.03 / controlDT));
        this.minimumTimeRemaining = new DoubleParameter("controllerMinimumTimeRemaining", this.registry, icpOptimizationParameters.getMinimumTimeRemaining());
        this.minimumFootstepMultiplier = new DoubleParameter("controllerMinimumFootstepMultiplier", this.registry, icpOptimizationParameters.getMinimumFootstepMultiplier());
        this.maximumTimeFromTransfer = new DoubleParameter("controllerMaximumTimeFromTransfer", this.registry, icpOptimizationParameters.maximumTimeFromTransferInFootstepMultiplier());
        int totalVertices = 0;
        for (RobotSide robotSide : RobotSide.values) {
            totalVertices += ((ContactablePlaneBody)contactableFeet.get((Enum)robotSide)).getTotalNumberOfContactPoints();
        }
        boolean updateRateAutomatically = true;
        this.solver = new ICPOptimizationQPSolver(totalVertices, false, updateRateAutomatically, this.registry);
        this.considerAngularMomentumInAdjustment = new BooleanParameter("controllerConsiderAngularMomentumInAdjustment", this.registry, icpOptimizationParameters.considerAngularMomentumInAdjustment());
        this.considerFeedbackInAdjustment = new BooleanParameter("controllerConsiderFeedbackInAdjustment", this.registry, icpOptimizationParameters.considerFeedbackInAdjustment());
        this.solutionHandler = new ICPOptimizationSolutionHandler(this.icpControlPlane, icpOptimizationParameters, this.useICPControlPolygons, true, yoNamePrefix, this.registry);
        this.copConstraintHandler = new ICPOptimizationCoPConstraintHandler(bipedSupportPolygons, icpControlPolygons, this.useICPControlPolygons, this.hasICPControlPolygons, this.registry);
        if (walkingControllerParameters != null) {
            this.reachabilityConstraintHandler = new ICPOptimizationReachabilityConstraintHandler(soleZUpFrames, icpOptimizationParameters, walkingControllerParameters.getSteppingParameters(), yoNamePrefix, true, this.registry, yoGraphicsListRegistry);
            this.planarRegionConstraintProvider = new PlanarRegionConstraintProvider(this.icpControlPlane, walkingControllerParameters, icpOptimizationParameters, bipedSupportPolygons, soleZUpFrames, contactableFeet, yoNamePrefix, true, this.registry, yoGraphicsListRegistry);
        } else {
            this.reachabilityConstraintHandler = null;
            this.planarRegionConstraintProvider = null;
        }
        if (yoGraphicsListRegistry != null) {
            this.setupVisualizers(yoGraphicsListRegistry);
        }
        parentRegistry.addChild(this.registry);
    }

    private void setupVisualizers(YoGraphicsListRegistry yoGraphicsListRegistry) {
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoGraphicPosition predictedEndOfStateICP = new YoGraphicPosition("controllerPredictedEndOfStateICP", this.predictedEndOfStateICP, 0.005, YoAppearance.MidnightBlue(), YoGraphicPosition.GraphicType.BALL);
        YoGraphicPosition clippedFootstepSolution = new YoGraphicPosition("controllerClippedFootstepSolution", this.footstepSolution.getPosition(), 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.BALL);
        YoGraphicPosition feedbackCoP = new YoGraphicPosition("controllerFeedbackCoP", this.feedbackCoP, 0.005, YoAppearance.Darkorange(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        artifactList.add((Artifact)predictedEndOfStateICP.createArtifact());
        artifactList.add((Artifact)clippedFootstepSolution.createArtifact());
        artifactList.add((Artifact)feedbackCoP.createArtifact());
        this.solutionHandler.setupVisualizers(artifactList);
        artifactList.setVisible(true);
        yoGraphicsListRegistry.registerArtifactList(artifactList);
    }

    @Override
    public void clearPlan() {
        this.numberOfRegisteredSteps.set(0);
        this.upcomingFootstep.setToZero();
        this.transferDuration.setToNaN();
        this.swingDuration.setToNaN();
        this.nextTransferDuration.setToNaN();
    }

    @Override
    public void setTransferDuration(double duration) {
        this.transferDuration.set(duration);
    }

    @Override
    public void setSwingDuration(double duration) {
        this.swingDuration.set(duration);
    }

    @Override
    public void setNextTransferDuration(double duration) {
        this.nextTransferDuration.set(duration);
    }

    @Override
    public void setFinalTransferDuration(double finalTransferDuration) {
        this.finalTransferDuration.set(finalTransferDuration);
    }

    @Override
    public void addFootstepToPlan(SimpleFootstep footstep, double swingDuration, double transferDuration) {
        FramePose3D footstepPose = footstep.getSoleFramePose();
        footstepPose.checkReferenceFrameMatch(worldFrame);
        if (!footstepPose.containsNaN()) {
            if (this.numberOfRegisteredSteps.getValue() == 0) {
                this.upcomingFootstep.set((FramePose3DReadOnly)footstepPose);
                this.upcomingFootstepSide.set((Enum)footstep.getRobotSide());
                this.upcomingFootstepContactPoints.clear();
                ConvexPolygon2DReadOnly foothold = footstep.getFoothold();
                for (int i = 0; i < foothold.getNumberOfVertices(); ++i) {
                    ((Point2D)this.upcomingFootstepContactPoints.add()).set((Tuple2DReadOnly)foothold.getVertex(i));
                }
                this.footstepSolution.set((FramePose3DReadOnly)footstepPose);
                this.unclippedFootstepSolution.set((FrameTuple3DReadOnly)footstepPose.getPosition());
                this.swingDuration.set(swingDuration);
                this.transferDuration.set(transferDuration);
                this.footstepIsAdjustable.set(footstep.getIsAdjustable());
                this.useStepAdjustment.set(this.allowStepAdjustment.getValue() && this.footstepIsAdjustable.getBooleanValue());
            } else if (this.numberOfRegisteredSteps.getValue() == 1) {
                this.nextTransferDuration.set(transferDuration);
            }
            this.numberOfRegisteredSteps.increment();
        } else {
            LogTools.warn((String)("Received bad footstep: " + footstep));
        }
    }

    @Override
    public void initializeForStanding(double initialTime) {
        this.initialTime.set(initialTime);
        this.isStationary.set(true);
        this.isInDoubleSupport.set(true);
        this.isICPStuck.set(false);
        this.localUseStepAdjustment = this.useStepAdjustment.getBooleanValue();
        this.solver.resetCoPLocationConstraint();
        this.solver.resetReachabilityConstraint();
        this.solver.resetPlanarRegionConstraint();
        this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
        if (this.reachabilityConstraintHandler != null) {
            this.solver.addReachabilityPolygon(this.reachabilityConstraintHandler.initializeReachabilityConstraintForDoubleSupport());
        }
        if (this.planarRegionConstraintProvider != null) {
            this.planarRegionConstraintProvider.updatePlanarRegionConstraintForDoubleSupport();
        }
        this.solver.notifyResetActiveSet();
        this.transferDuration.set(this.finalTransferDuration.getDoubleValue());
        this.footstepSolution.setToNaN();
        this.unclippedFootstepSolution.setToNaN();
        this.speedUpTime.set(0.0);
    }

    @Override
    public void initializeForTransfer(double initialTime, RobotSide transferToSide) {
        this.transferToSide.set((Enum)transferToSide);
        this.isInDoubleSupport.set(true);
        this.isStationary.set(false);
        this.isICPStuck.set(false);
        if (this.numberOfRegisteredSteps.getValue() < 2) {
            this.nextTransferDuration.set(this.finalTransferDuration.getDoubleValue());
        }
        this.initializeOnContactChange(initialTime);
        this.footstepSolution.setToNaN();
        this.unclippedFootstepSolution.setToNaN();
        this.solver.resetCoPLocationConstraint();
        this.solver.resetReachabilityConstraint();
        this.solver.resetPlanarRegionConstraint();
        this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
        if (this.reachabilityConstraintHandler != null) {
            this.solver.addReachabilityPolygon(this.reachabilityConstraintHandler.initializeReachabilityConstraintForDoubleSupport());
        }
        if (this.planarRegionConstraintProvider != null) {
            this.planarRegionConstraintProvider.updatePlanarRegionConstraintForDoubleSupport();
        }
        this.solver.notifyResetActiveSet();
    }

    @Override
    public void initializeForSingleSupport(double initialTime, RobotSide supportSide, double omega0) {
        if (!((RobotSide)this.upcomingFootstepSide.getValue()).equals((Object)supportSide.getOppositeSide())) {
            throw new RuntimeException("Somehow initializing the wrong side!");
        }
        this.supportSide.set((Enum)supportSide);
        this.isStationary.set(false);
        this.isInDoubleSupport.set(false);
        this.isICPStuck.set(false);
        if (this.numberOfRegisteredSteps.getValue() < 2) {
            this.nextTransferDuration.set(this.finalTransferDuration.getDoubleValue());
        }
        this.initializeOnContactChange(initialTime);
        this.solver.resetCoPLocationConstraint();
        this.solver.resetReachabilityConstraint();
        this.solver.resetPlanarRegionConstraint();
        this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
        if (this.reachabilityConstraintHandler != null) {
            this.solver.addReachabilityPolygon(this.reachabilityConstraintHandler.initializeReachabilityConstraintForSingleSupport(supportSide, (FramePose3DReadOnly)this.upcomingFootstep));
        }
        if (this.planarRegionConstraintProvider != null) {
            this.planarRegionConstraintProvider.computeDistanceFromEdgeForNoOverhang((RobotSide)this.upcomingFootstepSide.getValue(), (List<Point2D>)this.upcomingFootstepContactPoints);
            ConvexPolygon2D planarRegion = this.planarRegionConstraintProvider.updatePlanarRegionConstraintForSingleSupport((RobotSide)this.upcomingFootstepSide.getValue(), (FramePose3DReadOnly)this.upcomingFootstep, (List<Point2D>)this.upcomingFootstepContactPoints, this.timeRemainingInState.getDoubleValue(), (FramePoint2DReadOnly)this.currentICP, omega0);
            this.solver.setPlanarRegionConstraint(planarRegion);
        }
        this.solver.notifyResetActiveSet();
    }

    private void initializeOnContactChange(double initialTime) {
        this.speedUpTime.set(0.0);
        this.localUseStepAdjustment = this.useStepAdjustment.getBooleanValue();
        this.initialTime.set(initialTime);
        if (this.useFootstepRate.getValue()) {
            if (this.useICPControlPolygons.getValue() && this.hasICPControlPolygons) {
                this.icpControlPlane.projectPointOntoControlPlane(worldFrame, (FramePoint3DReadOnly)this.upcomingFootstep.getPosition(), this.projectedTempPoint3d);
            } else {
                this.projectedTempPoint3d.set((FrameTuple3DReadOnly)this.upcomingFootstep.getPosition());
            }
            this.solver.resetFootstepRate(this.projectedTempPoint3d);
        }
    }

    private boolean computeWhetherToIncludeFootsteps() {
        if (!this.localUseStepAdjustment || this.isInDoubleSupport.getBooleanValue() || this.isStationary.getBooleanValue()) {
            return false;
        }
        if (this.timeInCurrentState.getDoubleValue() / this.swingDuration.getDoubleValue() < this.fractionThroughSwingForAdjustment.getValue()) {
            return false;
        }
        if (this.icpError.length() < Math.abs(this.minICPErrorForStepAdjustment.getValue()) && !this.includeFootsteps.getBooleanValue()) {
            return false;
        }
        return this.numberOfRegisteredSteps.getValue() > 0;
    }

    @Override
    public boolean useStepAdjustment() {
        return this.useStepAdjustment.getBooleanValue();
    }

    @Override
    public void getDesiredCMP(FixedFramePoint2DBasics desiredCMPToPack) {
        desiredCMPToPack.set((FrameTuple2DReadOnly)this.feedbackCMP);
    }

    @Override
    public void getDesiredCoP(FixedFramePoint2DBasics desiredCoPToPack) {
        desiredCoPToPack.set((FrameTuple2DReadOnly)this.feedbackCoP);
    }

    @Override
    public FramePose3DReadOnly getFootstepSolution() {
        return this.footstepSolution;
    }

    @Override
    public boolean wasFootstepAdjusted() {
        return this.solutionHandler.wasFootstepAdjusted();
    }

    @Override
    public FrameVector3DReadOnly getICPShiftFromStepAdjustment() {
        this.scaledAdjustment.setIncludingFrame((FrameTuple2DReadOnly)this.solutionHandler.getTotalFootstepAdjustment(), 0.0);
        this.scaledAdjustment.scale(this.footstepMultiplier.getDoubleValue());
        return this.scaledAdjustment;
    }

    @Override
    public boolean useAngularMomentum() {
        return this.useAngularMomentum.getValue();
    }

    @Override
    public void compute(double currentTime, FramePoint2DReadOnly desiredICP, FrameVector2DReadOnly desiredICPVelocity, FramePoint2DReadOnly perfectCoP, FramePoint2DReadOnly currentICP, FrameVector2DReadOnly currentICPVelocity, double omega0) {
        this.desiredCMPOffsetToThrowAway.setToZero(worldFrame);
        this.compute(currentTime, desiredICP, desiredICPVelocity, perfectCoP, (FrameVector2DReadOnly)this.desiredCMPOffsetToThrowAway, currentICP, currentICPVelocity, omega0);
    }

    @Override
    public void compute(double currentTime, FramePoint2DReadOnly desiredICP, FrameVector2DReadOnly desiredICPVelocity, FramePoint2DReadOnly perfectCoP, FrameVector2DReadOnly perfectCMPOffset, FramePoint2DReadOnly currentICP, FrameVector2DReadOnly currentICPVelocity, double omega0) {
        this.controllerTimer.startMeasurement();
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        this.solver.setConsiderAngularMomentumInAdjustment(this.considerAngularMomentumInAdjustment.getValue());
        this.solver.setConsiderFeedbackInAdjustment(this.considerFeedbackInAdjustment.getValue());
        this.desiredICP.set((FrameTuple2DReadOnly)desiredICP);
        this.desiredICPVelocity.set((FrameTuple2DReadOnly)desiredICPVelocity);
        this.perfectCMPOffset.set((FrameTuple2DReadOnly)perfectCMPOffset);
        this.currentICP.set((FrameTuple2DReadOnly)currentICP);
        this.currentICPVelocity.set((FrameTuple2DReadOnly)currentICPVelocity);
        this.desiredICP.changeFrame(worldFrame);
        this.desiredICPVelocity.changeFrame(worldFrame);
        this.perfectCMPOffset.changeFrame(worldFrame);
        this.currentICP.changeFrame(worldFrame);
        this.currentICPVelocity.changeFrame(worldFrame);
        this.yoPerfectCoP.setMatchingFrame((FrameTuple2DReadOnly)perfectCoP);
        this.yoPerfectCMP.add((FrameTuple2DReadOnly)this.yoPerfectCoP, (FrameTuple2DReadOnly)this.perfectCMPOffset);
        this.icpError.sub((FrameTuple2DReadOnly)currentICP, (FrameTuple2DReadOnly)desiredICP);
        this.computeTimeInCurrentState(currentTime);
        this.computeTimeRemainingInState();
        boolean includeFootsteps = this.computeWhetherToIncludeFootsteps();
        if (includeFootsteps != this.includeFootsteps.getBooleanValue()) {
            this.solver.notifyResetActiveSet();
            this.includeFootsteps.set(includeFootsteps);
        }
        this.scaleStepRateWeightWithTime();
        this.scaleFeedbackWeightWithGain();
        this.submitSolverTaskConditions(omega0, includeFootsteps);
        this.solver.setMaxNumberOfIterations(this.maxNumberOfIterations.getValue());
        this.qpSolverTimer.startMeasurement();
        boolean converged = this.solveQP();
        this.qpSolverTimer.stopMeasurement();
        this.extractSolutionsFromSolver(converged, includeFootsteps);
        this.modifyCMPFeedbackWeightUsingIntegral();
        this.controllerTimer.stopMeasurement();
    }

    private void initialize() {
        this.scaledCMPFeedbackWeight.set(this.cmpFeedbackWeight.getValue());
    }

    @Override
    public void submitRemainingTimeInSwingUnderDisturbance(double remainingTimeForSwing) {
        if (this.swingSpeedUpEnabled.getBooleanValue() && remainingTimeForSwing < this.timeRemainingInState.getDoubleValue()) {
            double speedUpTime = this.timeRemainingInState.getDoubleValue() - remainingTimeForSwing;
            this.speedUpTime.add(speedUpTime);
        }
    }

    private void submitSolverTaskConditions(double omega0, boolean includeFootsteps) {
        if (this.isInDoubleSupport.getBooleanValue()) {
            this.solver.resetCoPLocationConstraint();
            this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
            if (this.copConstraintHandler.hasSupportPolygonChanged()) {
                this.solver.notifyResetActiveSet();
            }
        } else {
            this.solver.resetCoPLocationConstraint();
            this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
            boolean resetActiveSet = this.copConstraintHandler.hasSupportPolygonChanged();
            if (this.planarRegionConstraintProvider != null) {
                ConvexPolygon2D planarRegionConstraint = this.planarRegionConstraintProvider.updatePlanarRegionConstraintForSingleSupport((RobotSide)this.upcomingFootstepSide.getValue(), (FramePose3DReadOnly)this.upcomingFootstep, (List<Point2D>)this.upcomingFootstepContactPoints, this.timeRemainingInState.getDoubleValue(), (FramePoint2DReadOnly)this.currentICP, omega0);
                this.solver.resetPlanarRegionConstraint();
                this.solver.setPlanarRegionConstraint(planarRegionConstraint);
                boolean bl = resetActiveSet = resetActiveSet || this.planarRegionConstraintProvider.hasConstraintChanged();
            }
            if (resetActiveSet) {
                this.solver.notifyResetActiveSet();
            }
        }
        this.solver.resetFootstepConditions();
        if (this.localUseStepAdjustment && !this.isInDoubleSupport.getBooleanValue()) {
            this.submitFootstepTaskConditionsToSolver(omega0, includeFootsteps);
            this.solver.resetReachabilityConstraint();
            if (this.reachabilityConstraintHandler != null) {
                this.solver.addReachabilityPolygon(this.reachabilityConstraintHandler.updateReachabilityConstraint());
            }
        } else {
            this.predictedEndOfStateICP.setToNaN();
        }
        this.submitCoPFeedbackTaskConditionsToSolver();
        if (this.useCMPFeedback.getValue()) {
            this.submitCMPFeedbackTaskConditionsToSolver();
        }
    }

    private void submitCoPFeedbackTaskConditionsToSolver() {
        this.helper.transformGainsFromDynamicsFrame((DMatrix1Row)this.transformedGains, (FrameVector2DReadOnly)this.desiredICPVelocity, this.feedbackGains.getKpParallelToMotion(), this.feedbackGains.getKpOrthogonalToMotion());
        this.helper.transformFromDynamicsFrame((FixedFrameVector2DBasics)this.transformedMagnitudeLimits, (FrameVector2DReadOnly)this.desiredICPVelocity, this.feedbackGains.getFeedbackPartMaxValueParallelToMotion(), this.feedbackGains.getFeedbackPartMaxValueOrthogonalToMotion());
        double dynamicsObjectiveWeight = this.dynamicsObjectiveWeight.getValue();
        if (this.isInDoubleSupport.getBooleanValue()) {
            dynamicsObjectiveWeight /= this.dynamicsObjectiveDoubleSupportWeightModifier.getValue();
        }
        this.yoScaledCoPFeedbackWeight.get(this.scaledCoPFeedbackWeight);
        this.solver.resetCoPFeedbackConditions();
        this.solver.setFeedbackConditions(this.scaledCoPFeedbackWeight, this.transformedGains, dynamicsObjectiveWeight);
        this.solver.setMaxCMPDistanceFromEdge(this.maxAllowedDistanceCMPSupport.getValue());
        this.solver.setCopSafeDistanceToEdge(this.safeCoPDistanceToEdge.getValue());
        this.solver.setMaximumFeedbackMagnitude((FrameVector2DReadOnly)this.transformedMagnitudeLimits);
        this.solver.setMaximumFeedbackRate(this.feedbackGains.getFeedbackPartMaxRate(), this.controlDT);
        if (this.useFeedbackRate.getValue()) {
            this.solver.setFeedbackRateWeight(this.copCMPFeedbackRateWeight.getValue() / this.controlDTSquare, this.feedbackRateWeight.getValue() / this.controlDTSquare);
        }
    }

    private void submitCMPFeedbackTaskConditionsToSolver() {
        double cmpFeedbackWeight = this.scaledCMPFeedbackWeight.getDoubleValue();
        this.solver.resetCMPFeedbackConditions();
        this.solver.setCMPFeedbackConditions(cmpFeedbackWeight, this.useAngularMomentum.getValue());
    }

    private void submitFootstepTaskConditionsToSolver(double omega0, boolean includeFootsteps) {
        if (includeFootsteps) {
            ReferenceFrame soleFrame = ((ContactablePlaneBody)this.contactableFeet.get((Enum)((RobotSide)this.supportSide.getEnumValue()))).getSoleFrame();
            this.helper.transformToWorldFrame((DMatrix1Row)this.footstepWeights, this.forwardFootstepWeight.getValue(), this.lateralFootstepWeight.getValue(), soleFrame);
            this.yoFootstepWeights.set(this.footstepWeights);
            this.footstepMultiplier.set(this.computeFootstepAdjustmentMultiplier(omega0));
            this.predictedEndOfStateICP.sub((FrameTuple2DReadOnly)this.desiredICP, (FrameTuple2DReadOnly)this.yoPerfectCMP);
            this.predictedEndOfStateICP.scaleAdd(Math.exp(omega0 * this.timeRemainingInState.getDoubleValue()), (FrameTuple2DReadOnly)this.yoPerfectCMP);
            if (this.useICPControlPolygons.getValue() && this.hasICPControlPolygons) {
                this.icpControlPlane.projectPointOntoControlPlane(worldFrame, (FramePoint3DReadOnly)this.upcomingFootstep.getPosition(), this.projectedTempPoint3d);
            } else {
                this.projectedTempPoint3d.set((FrameTuple3DReadOnly)this.upcomingFootstep.getPosition());
            }
            this.footstepLocationSubmitted.set((FrameTuple3DReadOnly)this.projectedTempPoint3d);
            this.solver.setFootstepAdjustmentConditions(this.footstepMultiplier.getDoubleValue(), this.footstepWeights, this.footstepAdjustmentSafetyFactor.getValue(), this.projectedTempPoint3d);
        }
        if (this.useFootstepRate.getValue()) {
            this.solver.setFootstepRateWeight(this.scaledFootstepRateWeight.getDoubleValue() / this.controlDTSquare);
        }
    }

    private double computeFootstepAdjustmentMultiplier(double omega0) {
        double timeInTransferForShifting = Math.min(this.maximumTimeFromTransfer.getValue(), this.transferDurationSplitFraction.getValue() * this.nextTransferDuration.getDoubleValue());
        this.recursionTime.set(Math.max(this.timeRemainingInState.getDoubleValue(), 0.0) + timeInTransferForShifting);
        this.recursionMultiplier.set(Math.exp(-omega0 * this.recursionTime.getDoubleValue()));
        double finalRecursionMultiplier = Math.exp(-omega0 * timeInTransferForShifting);
        double minimumFootstepMultiplier = Math.min(this.minimumFootstepMultiplier.getValue(), finalRecursionMultiplier);
        return minimumFootstepMultiplier + (1.0 - minimumFootstepMultiplier / finalRecursionMultiplier) * this.recursionMultiplier.getDoubleValue();
    }

    private boolean solveQP() {
        boolean converged = this.solver.compute((FrameVector2DReadOnly)this.icpError, (FramePoint2DReadOnly)this.yoPerfectCoP, (FrameVector2DReadOnly)this.perfectCMPOffset);
        this.previousTickFailed.set(this.solver.previousTickFailed());
        if (!converged) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                LogTools.warn((String)"The QP has not converged. Only showing this once if it happens repeatedly.");
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
        }
        return converged;
    }

    private void extractSolutionsFromSolver(boolean converged, boolean includeFootsteps) {
        this.numberOfIterations.set(this.solver.getNumberOfIterations());
        if (converged) {
            if (this.localUseStepAdjustment && includeFootsteps) {
                if (this.planarRegionConstraintProvider != null) {
                    PlanarRegion activePlanarRegion = this.planarRegionConstraintProvider.getActivePlanarRegion();
                    this.solutionHandler.extractFootstepSolution((FixedFramePose3DBasics)this.footstepSolution, (FixedFrameTuple2DBasics)this.unclippedFootstepSolution, (FramePose3DReadOnly)this.upcomingFootstep, activePlanarRegion, this.solver);
                    boolean footstepWasAdjustedBySnapper = this.planarRegionConstraintProvider.snapFootPoseToActivePlanarRegion((FixedFramePose3DBasics)this.footstepSolution);
                    this.solutionHandler.setFootstepWasAdjustedBySnapper(footstepWasAdjustedBySnapper);
                } else {
                    this.solutionHandler.extractFootstepSolution((FixedFramePose3DBasics)this.footstepSolution, (FixedFrameTuple2DBasics)this.unclippedFootstepSolution, (FramePose3DReadOnly)this.upcomingFootstep, null, this.solver);
                    this.solutionHandler.setFootstepWasAdjustedBySnapper(false);
                }
            }
            if (this.isInDoubleSupport.getBooleanValue()) {
                this.solutionHandler.resetAdjustment();
            }
            this.solutionHandler.updateVisualizers((FramePoint2DReadOnly)this.desiredICP, this.footstepMultiplier.getDoubleValue());
            this.solver.getCoPFeedbackDifference((FixedFrameVector2DBasics)this.feedbackCoPDelta);
            this.solver.getCMPFeedbackDifference((FixedFrameVector2DBasics)this.feedbackCMPDelta);
            this.solver.getDynamicsError((FixedFrameVector2DBasics)this.dynamicsError);
        } else if (this.localUseStepAdjustment && includeFootsteps) {
            this.solutionHandler.zeroAdjustment();
        }
        this.isICPStuck.update(this.computeIsStuck());
        this.computeICPIntegralTerm();
        this.feedbackCoP.add((FrameTuple2DReadOnly)this.yoPerfectCoP, (FrameTuple2DReadOnly)this.feedbackCoPDelta);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.feedbackCoP, (FrameTuple2DReadOnly)this.perfectCMPOffset);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.feedbackCMPDelta);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.feedbackCMPIntegral);
        if (this.limitReachabilityFromAdjustment.getValue() && this.localUseStepAdjustment && includeFootsteps) {
            this.updateReachabilityRegionFromAdjustment();
        }
        if (this.wasFootstepAdjusted()) {
            this.upcomingFootstep.set((FramePose3DReadOnly)this.footstepSolution);
        }
    }

    private void updateReachabilityRegionFromAdjustment() {
        if (this.reachabilityConstraintHandler != null) {
            this.reachabilityConstraintHandler.updateReachabilityBasedOnAdjustment((FramePose3DReadOnly)this.upcomingFootstep, (FixedFramePoint2DBasics)this.unclippedFootstepSolution, this.wasFootstepAdjusted());
        }
    }

    private void computeTimeInCurrentState(double currentTime) {
        this.timeInCurrentState.set(currentTime - this.initialTime.getDoubleValue() + this.speedUpTime.getDoubleValue());
    }

    private void computeTimeRemainingInState() {
        if (this.isStationary.getBooleanValue()) {
            this.timeRemainingInState.set(0.0);
        } else if (this.isInDoubleSupport.getBooleanValue()) {
            this.timeRemainingInState.set(this.transferDuration.getDoubleValue() - this.timeInCurrentState.getDoubleValue());
        } else {
            this.timeRemainingInState.set(this.swingDuration.getDoubleValue() - this.timeInCurrentState.getDoubleValue());
        }
    }

    private void scaleStepRateWeightWithTime() {
        if (this.scaleStepRateWeightWithTime.getValue()) {
            double alpha = Math.max(this.timeRemainingInState.getDoubleValue(), this.minimumTimeRemaining.getValue()) / this.swingDuration.getDoubleValue();
            this.scaledFootstepRateWeight.set(this.footstepRateWeight.getValue() / alpha);
        } else {
            this.scaledFootstepRateWeight.set(this.footstepRateWeight.getValue());
        }
    }

    private void scaleFeedbackWeightWithGain() {
        this.helper.transformFromDynamicsFrame((DMatrix1Row)this.scaledCoPFeedbackWeight, (FrameVector2DReadOnly)this.desiredICPVelocity, this.copFeedbackForwardWeight.getValue(), this.copFeedbackLateralWeight.getValue());
        this.yoScaledCoPFeedbackWeight.set(this.scaledCoPFeedbackWeight);
        if (this.scaleFeedbackWeightWithGain.getValue()) {
            double parallel = this.feedbackGains.getKpParallelToMotion();
            double orthogonal = this.feedbackGains.getKpOrthogonalToMotion();
            double magnitude = this.helper.transformGainsFromDynamicsFrame((DMatrix1Row)this.transformedGains, (FrameVector2DReadOnly)this.desiredICPVelocity, parallel, orthogonal);
            CommonOps_DDRM.scale((double)(1.0 / magnitude), (DMatrixD1)this.scaledCoPFeedbackWeight);
        }
        this.yoScaledCoPFeedbackWeight.set(this.scaledCoPFeedbackWeight);
    }

    private void modifyCMPFeedbackWeightUsingIntegral() {
        double cmpFeedbackWeight = this.cmpFeedbackWeight.getValue();
        if (!this.useAngularMomentumIntegrator.getValue()) {
            this.scaledCMPFeedbackWeight.set(cmpFeedbackWeight);
            return;
        }
        double angularMomentumFeedbackMagnitude = this.feedbackCMPDelta.length() - this.perfectCMPOffset.length();
        double cumulativeAngularMomentumAfterLeak = angularMomentumFeedbackMagnitude * this.controlDT + this.angularMomentumIntegratorLeakRatio.getValue() * this.cumulativeAngularMomentum.getDoubleValue();
        this.cumulativeAngularMomentum.set(cumulativeAngularMomentumAfterLeak);
        double multiplier = 1.0 + this.angularMomentumIntegratorGain.getValue() * cumulativeAngularMomentumAfterLeak;
        this.scaledCMPFeedbackWeight.set(multiplier * cmpFeedbackWeight);
    }

    private boolean computeIsStuck() {
        if (!this.isInDoubleSupport.getBooleanValue() || this.isStationary.getBooleanValue()) {
            return false;
        }
        if (this.isICPStuck.getBooleanValue()) {
            return true;
        }
        this.currentICPVelocityMagnitude.set(this.currentICPVelocity.length());
        return this.currentICPVelocityMagnitude.getDoubleValue() < this.thresholdForStuck.getValue() && this.timeRemainingInState.getDoubleValue() <= this.minimumTimeRemaining.getValue();
    }

    private void computeICPIntegralTerm() {
        if (this.useSmartICPIntegrator.getValue() && this.isICPStuck.getBooleanValue()) {
            this.tempVector2d.set((FrameTuple2DReadOnly)this.icpError);
            this.tempVector2d.scale(this.controlDT * this.feedbackGains.getKi());
            this.feedbackCMPIntegral.scale(Math.pow(this.feedbackGains.getIntegralLeakRatio(), this.controlDT));
            this.feedbackCMPIntegral.add((FrameTuple2DReadOnly)this.tempVector2d);
            double length = this.feedbackCMPIntegral.length();
            double maxLength = this.feedbackGains.getMaxIntegralError();
            if (length > maxLength) {
                this.feedbackCMPIntegral.scale(maxLength / length);
            }
            if (Math.abs(this.feedbackGains.getKi()) < 1.0E-10) {
                this.feedbackCMPIntegral.setToZero();
            }
        } else {
            this.feedbackCMPIntegral.setToZero();
        }
    }

    @Override
    public void submitCurrentPlanarRegions(List<PlanarRegion> planarRegions) {
        if (this.planarRegionConstraintProvider != null) {
            this.planarRegionConstraintProvider.setPlanarRegions(planarRegions);
        }
    }

    @Override
    public void setKeepCoPInsideSupportPolygon(boolean keepCoPInsideSupportPolygon) {
        this.copConstraintHandler.setKeepCoPInsideSupportPolygon(keepCoPInsideSupportPolygon);
    }
}

