/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.lqrControl;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class LQRCommonValues {
    private final DMatrixRMaj A = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj B = new DMatrixRMaj(6, 3);
    private final DMatrixRMaj BTranspose = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj C = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj D = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj Q = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj R = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj Q1 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj R1 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj R1Inverse = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj N = new DMatrixRMaj(6, 3);
    private final DMatrixRMaj NTranspose = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj DQ = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj A2 = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj A2Inverse = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj B2 = new DMatrixRMaj(6, 3);
    private final DMatrixRMaj A2InverseB2 = new DMatrixRMaj(6, 3);
    private final DMatrixRMaj Nb = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj R1InverseDQ = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj R1InverseBTranspose = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);

    public void computeDynamicsMatrix(double omega) {
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)0, (int)3, (DMatrix)CommonOps_DDRM.identity((int)3, (int)3), (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.B, (int)3, (int)0, (DMatrix)CommonOps_DDRM.identity((int)3, (int)3), (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.C, (int)0, (int)0, (DMatrix)CommonOps_DDRM.identity((int)3, (int)3), (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.D, (int)0, (int)0, (DMatrix)CommonOps_DDRM.identity((int)3, (int)3), (int)0, (int)0, (int)3, (int)3, (double)(-1.0 / MathTools.square((double)omega)));
        CommonOps_DDRM.transpose((DMatrixRMaj)this.B, (DMatrixRMaj)this.BTranspose);
    }

    public void computeEquivalentCostValues(double momentumRateWeight, double vrpTrackingWeight) {
        MatrixTools.setDiagonal((DMatrix1Row)this.Q, (double)vrpTrackingWeight);
        MatrixTools.setDiagonal((DMatrix1Row)this.R, (double)momentumRateWeight);
        NativeCommonOps.multQuad((DMatrix1Row)this.C, (DMatrix1Row)this.Q, (DMatrix1Row)this.Q1);
        NativeCommonOps.multQuad((DMatrix1Row)this.D, (DMatrix1Row)this.Q, (DMatrix1Row)this.R1);
        CommonOps_DDRM.addEquals((DMatrixD1)this.R1, (DMatrixD1)this.R);
        NativeCommonOps.invert((DMatrix1Row)this.R1, (DMatrix1Row)this.R1Inverse);
        CommonOps_DDRM.mult((DMatrix1Row)this.D, (DMatrix1Row)this.Q, (DMatrix1Row)this.DQ);
        this.tempMatrix.reshape(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)this.Q, (DMatrix1Row)this.D, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.C, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.N);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.N, (DMatrixRMaj)this.NTranspose);
    }

    public void computeS2ConstantStateMatrices(DMatrixRMaj S1) {
        CommonOps_DDRM.transpose((DMatrixRMaj)this.N, (DMatrixRMaj)this.Nb);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.B, (DMatrix1Row)S1, (DMatrix1Row)this.Nb);
        this.tempMatrix.reshape(3, 6);
        MatrixTools.scaleTranspose((double)-1.0, (DMatrix1Row)this.A, (DMatrix1Row)this.A2);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.R1Inverse, (DMatrix1Row)this.B, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.Nb, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.A2);
        CommonOps_DDRM.mult((DMatrix1Row)this.R1Inverse, (DMatrix1Row)this.DQ, (DMatrix1Row)this.R1InverseDQ);
        CommonOps_DDRM.multTransA((double)-2.0, (DMatrix1Row)this.Nb, (DMatrix1Row)this.R1InverseDQ, (DMatrix1Row)this.B2);
        CommonOps_DDRM.multAddTransA((double)2.0, (DMatrix1Row)this.C, (DMatrix1Row)this.Q, (DMatrix1Row)this.B2);
        NativeCommonOps.invert((DMatrix1Row)this.A2, (DMatrix1Row)this.A2Inverse);
        CommonOps_DDRM.mult((DMatrix1Row)this.A2Inverse, (DMatrix1Row)this.B2, (DMatrix1Row)this.A2InverseB2);
        CommonOps_DDRM.multTransB((double)-0.5, (DMatrix1Row)this.R1Inverse, (DMatrix1Row)this.B, (DMatrix1Row)this.R1InverseBTranspose);
    }

    public DMatrixRMaj getA() {
        return this.A;
    }

    public DMatrixRMaj getB() {
        return this.B;
    }

    public DMatrixRMaj getC() {
        return this.C;
    }

    public DMatrixRMaj getD() {
        return this.D;
    }

    public DMatrixRMaj getQ() {
        return this.Q;
    }

    public DMatrixRMaj getR() {
        return this.R;
    }

    public DMatrixRMaj getDQ() {
        return this.DQ;
    }

    public DMatrixRMaj getNTranspose() {
        return this.NTranspose;
    }

    public DMatrixRMaj getQ1() {
        return this.Q1;
    }

    public DMatrixRMaj getR1() {
        return this.R1;
    }

    public DMatrixRMaj getR1Inverse() {
        return this.R1Inverse;
    }

    public DMatrixRMaj getA2() {
        return this.A2;
    }

    public DMatrixRMaj getA2Inverse() {
        return this.A2Inverse;
    }

    public DMatrixRMaj getA2InverseB2() {
        return this.A2InverseB2;
    }

    public DMatrixRMaj getNb() {
        return this.Nb;
    }
}

