/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.lqrControl;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRCommonValues;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.S1Function;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.matrixlib.NativeCommonOps;

public class DifferentialS1Segment
implements S1Function {
    private final double dt;
    private final DMatrixRMaj NB = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj S1Dot = new DMatrixRMaj(6, 6);
    private final RecyclingArrayList<DMatrixRMaj> S1ReverseTrajectory = new RecyclingArrayList(() -> new DMatrixRMaj(6, 6));
    final List<DMatrixRMaj> S1Trajectory = new ArrayList<DMatrixRMaj>();

    public DifferentialS1Segment(double dt) {
        this.dt = dt;
    }

    public void set(LQRCommonValues lqrCommonValues, DMatrixRMaj S1AtEnd, double duration) {
        this.set(lqrCommonValues.getQ1(), lqrCommonValues.getR1Inverse(), lqrCommonValues.getNTranspose(), lqrCommonValues.getA(), lqrCommonValues.getB(), S1AtEnd, duration);
    }

    public void set(DMatrixRMaj Q1, DMatrixRMaj R1Inverse, DMatrixRMaj NTranspose, DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj S1AtEnd, double duration) {
        this.S1Trajectory.clear();
        this.S1ReverseTrajectory.clear();
        ((DMatrixRMaj)this.S1ReverseTrajectory.add()).set((DMatrixD1)S1AtEnd);
        for (double t = this.dt; t <= duration + this.dt / 10.0; t += this.dt) {
            DMatrixRMaj previousS1 = (DMatrixRMaj)this.S1ReverseTrajectory.getLast();
            DMatrixRMaj newS1 = (DMatrixRMaj)this.S1ReverseTrajectory.add();
            this.computeNB(B, NTranspose, previousS1);
            this.computeS1Dot(Q1, this.NB, R1Inverse, previousS1, A);
            CommonOps_DDRM.add((DMatrixD1)previousS1, (double)(-this.dt), (DMatrixD1)this.S1Dot, (DMatrixD1)newS1);
        }
        for (int i = this.S1ReverseTrajectory.size() - 1; i >= 0; --i) {
            this.S1Trajectory.add((DMatrixRMaj)this.S1ReverseTrajectory.get(i));
        }
    }

    @Override
    public void compute(double timeInState, DMatrixRMaj S1ToPack) {
        int startIndex = this.getStartIndex(timeInState);
        DMatrixRMaj start = this.S1Trajectory.get(startIndex);
        if (startIndex == this.S1Trajectory.size() - 1) {
            S1ToPack.set((DMatrixD1)this.S1Trajectory.get(this.S1Trajectory.size() - 1));
            return;
        }
        DMatrixRMaj end = this.S1Trajectory.get(startIndex + 1);
        DifferentialS1Segment.interpolate(start, end, this.getAlphaBetweenSegments(timeInState), S1ToPack);
    }

    int getStartIndex(double timeInState) {
        return (int)Math.floor(timeInState / this.dt + this.dt / 10.0);
    }

    double getAlphaBetweenSegments(double timeInState) {
        return timeInState % this.dt / this.dt;
    }

    private static void interpolate(DMatrixRMaj start, DMatrixRMaj end, double alpha, DMatrixRMaj ret) {
        CommonOps_DDRM.scale((double)(1.0 - alpha), (DMatrixD1)start, (DMatrixD1)ret);
        CommonOps_DDRM.addEquals((DMatrixD1)ret, (double)alpha, (DMatrixD1)end);
    }

    private void computeNB(DMatrixRMaj B, DMatrixRMaj NTranspose, DMatrixRMaj S1) {
        DifferentialS1Segment.computeNB(B, NTranspose, S1, this.NB);
    }

    static void computeNB(DMatrixRMaj B, DMatrixRMaj NTranspose, DMatrixRMaj S1, DMatrixRMaj NbToPack) {
        CommonOps_DDRM.multTransA((DMatrix1Row)B, (DMatrix1Row)S1, (DMatrix1Row)NbToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)NbToPack, (DMatrixD1)NTranspose);
    }

    private void computeS1Dot(DMatrixRMaj Q1, DMatrixRMaj NB, DMatrixRMaj R1Inverse, DMatrixRMaj S1, DMatrixRMaj A) {
        DifferentialS1Segment.computeS1Dot(Q1, NB, R1Inverse, S1, A, this.S1Dot);
    }

    static void computeS1Dot(DMatrixRMaj Q1, DMatrixRMaj NB, DMatrixRMaj R1Inverse, DMatrixRMaj S1, DMatrixRMaj A, DMatrixRMaj S1DotToPack) {
        NativeCommonOps.multQuad((DMatrix1Row)NB, (DMatrix1Row)R1Inverse, (DMatrix1Row)S1DotToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)S1DotToPack, (double)-1.0, (DMatrixD1)Q1);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)S1, (DMatrix1Row)A, (DMatrix1Row)S1DotToPack);
        CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)A, (DMatrix1Row)S1, (DMatrix1Row)S1DotToPack);
    }
}

