/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.lqrControl;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRCommonValues;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.S2Segment;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.linearAlgebra.MatrixExponentialCalculator;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;

public class AlgebraicS2Segment
implements S2Segment {
    private final DMatrixRMaj A2 = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj timeScaledA2 = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj A2Exponential = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj summedBetas = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj coefficients = new DMatrixRMaj(3, 1);
    private final MatrixExponentialCalculator exponentialCalculator = new MatrixExponentialCalculator(6);
    private final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear((int)3);
    private final DMatrixRMaj alpha = new DMatrixRMaj(6, 1);
    private final RecyclingArrayList<DMatrixRMaj> betas = new RecyclingArrayList(() -> new DMatrixRMaj(6, 1));

    public void set(DMatrixRMaj endValue, Polynomial3D vrpTrajectory, LQRCommonValues lqrCommonValues) {
        this.set(endValue, vrpTrajectory, lqrCommonValues.getA2(), lqrCommonValues.getA2Inverse(), lqrCommonValues.getA2InverseB2());
    }

    public void set(DMatrixRMaj endValue, Polynomial3D vrpTrajectory, DMatrixRMaj A2, DMatrixRMaj A2Inverse, DMatrixRMaj A2InverseB2) {
        this.A2.set((DMatrixD1)A2);
        int k = vrpTrajectory.getNumberOfCoefficients() - 1;
        this.betas.clear();
        for (int i = 0; i <= k; ++i) {
            ((DMatrixRMaj)this.betas.add()).zero();
        }
        vrpTrajectory.getCoefficients(k, this.coefficients);
        DMatrixRMaj betaLocal = (DMatrixRMaj)this.betas.get(k);
        CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)A2InverseB2, (DMatrix1Row)this.coefficients, (DMatrix1Row)betaLocal);
        DMatrixRMaj betaLocalPrevious = betaLocal;
        for (int i = k - 1; i >= 0; --i) {
            betaLocal = (DMatrixRMaj)this.betas.get(i);
            vrpTrajectory.getCoefficients(i, this.coefficients);
            CommonOps_DDRM.mult((double)((double)i + 1.0), (DMatrix1Row)A2Inverse, (DMatrix1Row)betaLocalPrevious, (DMatrix1Row)betaLocal);
            CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)A2InverseB2, (DMatrix1Row)this.coefficients, (DMatrix1Row)betaLocal);
            betaLocalPrevious = betaLocal;
        }
        double duration = Math.min(vrpTrajectory.getTimeInterval().getDuration(), 10.0);
        this.summedBetas.zero();
        for (int i = 0; i <= k; ++i) {
            CommonOps_DDRM.addEquals((DMatrixD1)this.summedBetas, (double)(-MathTools.pow((double)duration, (int)i)), (DMatrixD1)((DMatrixD1)this.betas.get(i)));
        }
        CommonOps_DDRM.scale((double)duration, (DMatrixD1)A2, (DMatrixD1)this.timeScaledA2);
        this.exponentialCalculator.compute(this.A2Exponential, this.timeScaledA2);
        CommonOps_DDRM.addEquals((DMatrixD1)this.summedBetas, (DMatrixD1)endValue);
        this.solver.setA((Matrix)this.A2Exponential);
        this.solver.solve((Matrix)this.summedBetas, (Matrix)this.alpha);
    }

    @Override
    public void compute(double timeInState, DMatrixRMaj s2ToPack) {
        CommonOps_DDRM.scale((double)timeInState, (DMatrixD1)this.A2, (DMatrixD1)this.timeScaledA2);
        this.exponentialCalculator.compute(this.A2Exponential, this.timeScaledA2);
        CommonOps_DDRM.mult((DMatrix1Row)this.A2Exponential, (DMatrix1Row)this.alpha, (DMatrix1Row)s2ToPack);
        for (int i = 0; i < this.betas.size(); ++i) {
            CommonOps_DDRM.addEquals((DMatrixD1)s2ToPack, (double)MathTools.pow((double)timeInState, (int)i), (DMatrixD1)((DMatrixD1)this.betas.get(i)));
        }
    }

    public DMatrixRMaj getAlpha() {
        return this.alpha;
    }

    public DMatrixRMaj getBeta(int index) {
        return (DMatrixRMaj)this.betas.get(index);
    }
}

