/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.lqrControl;

import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.AlgebraicS2Segment;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRCommonValues;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.S2Function;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;

public class AlgebraicS2Function
implements S2Function {
    private final DMatrixRMaj endValueLocal = new DMatrixRMaj(6, 1);
    private final RecyclingArrayList<AlgebraicS2Segment> s2Segments = new RecyclingArrayList(AlgebraicS2Segment::new);

    public void set(DMatrixRMaj endValue, List<Polynomial3D> vrpTrajectories, LQRCommonValues lqrCommonValues) {
        this.set(endValue, vrpTrajectories, lqrCommonValues.getA2(), lqrCommonValues.getA2Inverse(), lqrCommonValues.getA2InverseB2());
    }

    public void set(DMatrixRMaj endValue, List<Polynomial3D> vrpTrajectories, DMatrixRMaj A2, DMatrixRMaj A2Inverse, DMatrixRMaj A2InverseB2) {
        int numberOfSegments;
        this.s2Segments.clear();
        for (int j = 0; j < vrpTrajectories.size(); ++j) {
            this.s2Segments.add();
        }
        this.endValueLocal.set((DMatrixD1)endValue);
        for (int j = numberOfSegments = vrpTrajectories.size() - 1; j >= 0; --j) {
            AlgebraicS2Segment s2Segment = (AlgebraicS2Segment)this.s2Segments.get(j);
            s2Segment.set(this.endValueLocal, vrpTrajectories.get(j), A2, A2Inverse, A2InverseB2);
            CommonOps_DDRM.add((DMatrixD1)s2Segment.getAlpha(), (DMatrixD1)s2Segment.getBeta(0), (DMatrixD1)this.endValueLocal);
        }
    }

    public AlgebraicS2Segment getSegment(int i) {
        return (AlgebraicS2Segment)this.s2Segments.get(i);
    }

    @Override
    public void compute(int segmentNumber, double timeInSegment, DMatrixRMaj s2ToPack) {
        ((AlgebraicS2Segment)this.s2Segments.get(segmentNumber)).compute(timeInSegment, s2ToPack);
    }
}

