/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.controller;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPControllerQPConstraintCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPControllerQPInputCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ConstraintToConvexRegion;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPInequalityInput;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPInput;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolver;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class ICPControllerQPSolver {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean useWarmStart = true;
    private static final int maxNumberOfIterations = 100;
    static final int copFeedbackIndex = 0;
    static final int cmpFeedbackIndex = 2;
    private boolean resetActiveSet;
    private boolean previousTickFailed = false;
    final ICPControllerQPInputCalculator inputCalculator;
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_h;
    private final DMatrixRMaj solverInputResidualCost;
    private final DMatrixRMaj solverInput_Aineq;
    private final DMatrixRMaj solverInput_bineq;
    private final ICPQPInput copFeedbackMinimizationTask;
    private final ICPQPInput cmpFeedbackMinimizationTask;
    private final ICPQPInput feedbackRateMinimizationTask;
    private final ICPQPInput dynamicsTaskInput;
    private final List<ICPQPInput> taskList = new ArrayList<ICPQPInput>();
    private final ICPInequalityInput feedbackRateLimitConstraint;
    private final ICPInequalityInput feedbackLimitConstraint;
    private final List<ICPInequalityInput> constraintList = new ArrayList<ICPInequalityInput>();
    private final ConstraintToConvexRegion copLocationConstraint;
    private final ConstraintToConvexRegion cmpLocationConstraint;
    private final DMatrixRMaj desiredCoP = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj desiredCMP = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj desiredCMPOffset = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj currentICPError = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj copFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj feedbackRateWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj copCMPFeedbackRateWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj cmpFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj dynamicsWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj feedbackGain = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj desiredFeedbackDirection = new DMatrixRMaj(2, 1);
    private final AbstractSimpleActiveSetQPSolver solver = new JavaQuadProgSolver();
    final DMatrixRMaj solution;
    private final DMatrixRMaj copDeltaSolution;
    private final DMatrixRMaj cmpDeltaSolution;
    private final DMatrixRMaj residualDynamicsError;
    private final DMatrixRMaj previousFeedbackDeltaSolution;
    private final DMatrixRMaj previousCMPFeedbackDeltaSolution;
    private final DMatrixRMaj previousCoPFeedbackDeltaSolution;
    private int numberOfIterations;
    private int currentInequalityConstraintIndex;
    private final boolean autoSetPreviousSolution;
    private final YoBoolean useAngularMomentum;
    private double maxFeedbackXMagnitude = Double.POSITIVE_INFINITY;
    private double maxFeedbackYMagnitude = Double.POSITIVE_INFINITY;
    private double maximumFeedbackRate = Double.POSITIVE_INFINITY;
    private double controlDT = Double.POSITIVE_INFINITY;
    private double copSafeDistanceToEdge = 1.0E-4;
    private double cmpSafeDistanceFromEdge = Double.POSITIVE_INFINITY;
    private double feedbackDirectionWeight = 0.0;
    private final DMatrixRMaj tempCoPFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj tempFeedbackGains = new DMatrixRMaj(2, 2);
    private final FrameVector2D cmpOffsetToThrowAway = new FrameVector2D();

    public ICPControllerQPSolver(int maximumNumberOfCMPVertices) {
        this(maximumNumberOfCMPVertices, true, null);
    }

    public ICPControllerQPSolver(int maximumNumberOfCMPVertices, boolean autoSetPreviousSolution, YoRegistry registry) {
        this.autoSetPreviousSolution = autoSetPreviousSolution;
        this.useAngularMomentum = new YoBoolean("icpQPUseAngularMomentum", registry);
        this.useAngularMomentum.set(false);
        this.inputCalculator = new ICPControllerQPInputCalculator();
        int maximumNumberOfFreeVariables = 6;
        int maximumNumberOfLagrangeMultipliers = 8;
        this.solverInput_H = new DMatrixRMaj(maximumNumberOfFreeVariables, maximumNumberOfFreeVariables);
        this.solverInput_h = new DMatrixRMaj(maximumNumberOfFreeVariables, 1);
        this.solverInputResidualCost = new DMatrixRMaj(1, 1);
        this.copFeedbackMinimizationTask = new ICPQPInput(2);
        this.cmpFeedbackMinimizationTask = new ICPQPInput(2);
        this.dynamicsTaskInput = new ICPQPInput(6);
        this.feedbackRateMinimizationTask = new ICPQPInput(4);
        this.taskList.add(this.copFeedbackMinimizationTask);
        this.taskList.add(this.cmpFeedbackMinimizationTask);
        this.taskList.add(this.dynamicsTaskInput);
        this.taskList.add(this.feedbackRateMinimizationTask);
        this.feedbackLimitConstraint = new ICPInequalityInput(0, 6);
        this.feedbackRateLimitConstraint = new ICPInequalityInput(0, 6);
        this.constraintList.add(this.feedbackLimitConstraint);
        this.constraintList.add(this.feedbackRateLimitConstraint);
        this.copLocationConstraint = new ConstraintToConvexRegion(maximumNumberOfCMPVertices);
        this.cmpLocationConstraint = new ConstraintToConvexRegion(maximumNumberOfCMPVertices);
        this.solverInput_Aineq = new DMatrixRMaj(maximumNumberOfCMPVertices, maximumNumberOfCMPVertices);
        this.solverInput_bineq = new DMatrixRMaj(maximumNumberOfCMPVertices, 1);
        this.solution = new DMatrixRMaj(maximumNumberOfFreeVariables + maximumNumberOfLagrangeMultipliers, 1);
        this.copDeltaSolution = new DMatrixRMaj(2, 1);
        this.cmpDeltaSolution = new DMatrixRMaj(2, 1);
        this.residualDynamicsError = new DMatrixRMaj(2, 1);
        this.previousFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.previousCoPFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.previousCMPFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.solver.setMaxNumberOfIterations(100);
        this.solver.setUseWarmStart(true);
    }

    public void notifyResetActiveSet() {
        this.resetActiveSet = true;
    }

    private boolean pollResetActiveSet() {
        boolean ret = this.resetActiveSet;
        this.resetActiveSet = false;
        return ret;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.solver.setMaxNumberOfIterations(maxNumberOfIterations);
    }

    public void resetCoPLocationConstraint() {
        this.copLocationConstraint.reset();
        this.cmpLocationConstraint.reset();
    }

    public void setCopSafeDistanceToEdge(double copSafeDistanceToEdge) {
        this.copSafeDistanceToEdge = copSafeDistanceToEdge;
    }

    public void setMaxCMPDistanceFromEdge(double maxCMPDistance) {
        this.cmpSafeDistanceFromEdge = maxCMPDistance;
    }

    public void addSupportPolygon(FrameConvexPolygon2DReadOnly polygon) {
        if (polygon == null) {
            return;
        }
        polygon.checkReferenceFrameMatch(worldFrame);
        this.copLocationConstraint.addPolygon((ConvexPolygon2DReadOnly)polygon);
        this.cmpLocationConstraint.addPolygon((ConvexPolygon2DReadOnly)polygon);
    }

    public void setMaximumFeedbackMagnitude(FrameVector2DReadOnly maximumFeedbackMagnitude) {
        maximumFeedbackMagnitude.checkReferenceFrameMatch(worldFrame);
        this.maxFeedbackXMagnitude = Math.abs(maximumFeedbackMagnitude.getX());
        this.maxFeedbackYMagnitude = Math.abs(maximumFeedbackMagnitude.getY());
    }

    public void setMaximumFeedbackRate(double maximumFeedbackRate, double controlDT) {
        this.maximumFeedbackRate = maximumFeedbackRate;
        this.controlDT = controlDT;
    }

    private void reset() {
        int i;
        this.solverInput_H.zero();
        this.solverInput_h.zero();
        this.solverInputResidualCost.zero();
        this.solverInput_Aineq.zero();
        this.solverInput_bineq.zero();
        for (i = 0; i < this.taskList.size(); ++i) {
            this.taskList.get(i).reset();
        }
        for (i = 0; i < this.constraintList.size(); ++i) {
            this.constraintList.get(i).reset();
        }
        this.solution.zero();
        this.copDeltaSolution.zero();
        this.cmpDeltaSolution.zero();
        this.residualDynamicsError.zero();
        this.currentInequalityConstraintIndex = 0;
    }

    private void reshape() {
        int problemSize = this.useAngularMomentum.getBooleanValue() ? 4 : 2;
        int numberOfInequalityConstraints = this.copLocationConstraint.getInequalityConstraintSize();
        if (this.useAngularMomentum.getBooleanValue() && Double.isFinite(this.cmpSafeDistanceFromEdge)) {
            numberOfInequalityConstraints += this.cmpLocationConstraint.getInequalityConstraintSize();
        }
        this.solverInput_H.reshape(problemSize, problemSize);
        this.solverInput_h.reshape(problemSize, 1);
        this.copFeedbackMinimizationTask.reshape(2);
        this.dynamicsTaskInput.reshape(problemSize);
        this.cmpFeedbackMinimizationTask.reshape(2);
        this.feedbackRateMinimizationTask.reshape(problemSize);
        numberOfInequalityConstraints += Double.isFinite(this.maximumFeedbackRate) && Double.isFinite(this.controlDT) ? 4 : 0;
        numberOfInequalityConstraints += Double.isFinite(this.maxFeedbackXMagnitude) ? 2 : 0;
        this.solverInput_Aineq.reshape(numberOfInequalityConstraints += Double.isFinite(this.maxFeedbackYMagnitude) ? 2 : 0, problemSize);
        this.solverInput_bineq.reshape(numberOfInequalityConstraints, 1);
        this.solution.reshape(problemSize, 1);
    }

    public void resetCoPFeedbackConditions() {
        this.copFeedbackWeight.zero();
        this.feedbackGain.zero();
        this.dynamicsWeight.zero();
    }

    public void resetCMPFeedbackConditions() {
        this.cmpFeedbackWeight.zero();
        this.useAngularMomentum.set(false);
    }

    public void resetFeedbackDirection() {
        this.desiredFeedbackDirection.zero();
        this.feedbackDirectionWeight = 0.0;
    }

    public void setCMPFeedbackConditions(double cmpFeedbackWeight, boolean useAngularMomentum) {
        MatrixTools.setDiagonal((DMatrix1Row)this.cmpFeedbackWeight, (double)cmpFeedbackWeight);
        this.useAngularMomentum.set(useAngularMomentum);
    }

    public void resetFeedbackRate(FramePoint2D previousFeedbackDeltaSolution) {
        previousFeedbackDeltaSolution.changeFrame(worldFrame);
        this.previousFeedbackDeltaSolution.set(0, 0, previousFeedbackDeltaSolution.getX());
        this.previousFeedbackDeltaSolution.set(1, 0, previousFeedbackDeltaSolution.getY());
    }

    public void setFeedbackConditions(double copFeedbackWeight, double feedbackGain, double dynamicsWeight) {
        this.setFeedbackConditions(copFeedbackWeight, copFeedbackWeight, feedbackGain, feedbackGain, dynamicsWeight);
    }

    public void setFeedbackConditions(double copFeedbackXWeight, double copFeedbackYWeight, double feedbackXGain, double feedbackYGain, double dynamicsWeight) {
        this.tempCoPFeedbackWeight.set(0, 0, copFeedbackXWeight);
        this.tempCoPFeedbackWeight.set(1, 1, copFeedbackYWeight);
        this.tempFeedbackGains.set(0, 0, feedbackXGain);
        this.tempFeedbackGains.set(1, 1, feedbackYGain);
        this.setFeedbackConditions(this.tempCoPFeedbackWeight, this.tempFeedbackGains, dynamicsWeight);
    }

    public void setFeedbackConditions(DMatrixRMaj copFeedbackWeights, DMatrixRMaj feedbackGains, double dynamicsWeight) {
        this.copFeedbackWeight.set((DMatrixD1)copFeedbackWeights);
        this.feedbackGain.set((DMatrixD1)feedbackGains);
        MatrixTools.setDiagonal((DMatrix1Row)this.dynamicsWeight, (double)dynamicsWeight);
    }

    public void setFeedbackRateWeight(double copCMPFeedbackRateWeight, double feedbackRateWeight) {
        MatrixTools.setDiagonal((DMatrix1Row)this.feedbackRateWeight, (double)feedbackRateWeight);
        MatrixTools.setDiagonal((DMatrix1Row)this.copCMPFeedbackRateWeight, (double)copCMPFeedbackRateWeight);
    }

    public void setDesiredFeedbackDirection(FrameVector2DReadOnly desiredFeedbackDirection, double directionWeight) {
        desiredFeedbackDirection.get((DMatrix)this.desiredFeedbackDirection);
        CommonOps_DDRM.scale((double)(1.0 / desiredFeedbackDirection.length()), (DMatrixD1)this.desiredFeedbackDirection);
        this.feedbackDirectionWeight = directionWeight;
    }

    public boolean compute(FrameVector2DReadOnly currentICPError, FramePoint2DReadOnly desiredCoP) {
        this.cmpOffsetToThrowAway.setToZero(worldFrame);
        return this.compute(currentICPError, desiredCoP, (FrameVector2DReadOnly)this.cmpOffsetToThrowAway);
    }

    public boolean compute(FrameVector2DReadOnly currentICPError, FramePoint2DReadOnly desiredCoP, FrameVector2DReadOnly desiredCMPOffset) {
        boolean foundSolution;
        this.reset();
        currentICPError.checkReferenceFrameMatch(worldFrame);
        desiredCoP.checkReferenceFrameMatch(worldFrame);
        desiredCMPOffset.checkReferenceFrameMatch(worldFrame);
        currentICPError.get((DMatrix)this.currentICPError);
        desiredCoP.get((DMatrix)this.desiredCoP);
        desiredCMPOffset.get((DMatrix)this.desiredCMPOffset);
        CommonOps_DDRM.add((DMatrixD1)this.desiredCoP, (DMatrixD1)this.desiredCMPOffset, (DMatrixD1)this.desiredCMP);
        this.formulateCoPConstraint();
        if (this.useAngularMomentum.getValue()) {
            this.formulateCMPConstraint();
        }
        this.reshape();
        this.addCoPFeedbackTask();
        if (this.useAngularMomentum.getBooleanValue()) {
            this.addCMPFeedbackTask();
        }
        this.addFeedbackRateTask();
        this.addDynamicConstraintTask();
        this.addFeedbackDirectionTask();
        if (this.copLocationConstraint.getInequalityConstraintSize() > 0) {
            this.addCoPLocationConstraint();
        }
        if (this.useAngularMomentum.getBooleanValue() && this.cmpLocationConstraint.getInequalityConstraintSize() > 0) {
            this.addCMPLocationConstraint();
        }
        if (!this.previousTickFailed) {
            this.addMaximumFeedbackMagnitudeConstraint();
            this.addMaximumFeedbackRateConstraint();
        }
        boolean bl = this.previousTickFailed = !(foundSolution = this.solve(this.solution));
        if (foundSolution) {
            this.extractCoPFeedbackDeltaSolution(this.copDeltaSolution);
            this.extractCMPFeedbackDeltaSolution(this.cmpDeltaSolution);
            this.inputCalculator.computeResidualDynamicsError(this.solution, this.residualDynamicsError);
            if (this.autoSetPreviousSolution) {
                this.setPreviousFeedbackDeltaSolution(this.copDeltaSolution, this.cmpDeltaSolution);
            }
        }
        return foundSolution;
    }

    public boolean previousTickFailed() {
        return this.previousTickFailed;
    }

    private void addCoPFeedbackTask() {
        ICPControllerQPInputCalculator.computeCoPFeedbackMinimizationTask(this.copFeedbackMinimizationTask, this.copFeedbackWeight);
        ICPControllerQPInputCalculator.submitCoPFeedbackMinimizationTask(this.copFeedbackMinimizationTask, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addCMPFeedbackTask() {
        ICPControllerQPInputCalculator.computeCMPFeedbackMinimizationTask(this.cmpFeedbackMinimizationTask, this.cmpFeedbackWeight);
        ICPControllerQPInputCalculator.submitCMPFeedbackMinimizationTask(this.cmpFeedbackMinimizationTask, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addFeedbackRateTask() {
        this.inputCalculator.computeCoPFeedbackRateMinimizationTask(this.feedbackRateMinimizationTask, this.copCMPFeedbackRateWeight, this.previousCoPFeedbackDeltaSolution);
        if (this.useAngularMomentum.getBooleanValue()) {
            this.inputCalculator.computeCMPFeedbackRateMinimizationTask(this.feedbackRateMinimizationTask, this.copCMPFeedbackRateWeight, this.previousCMPFeedbackDeltaSolution);
            this.inputCalculator.computeTotalFeedbackRateMinimizationTask(this.feedbackRateMinimizationTask, this.feedbackRateWeight, this.previousFeedbackDeltaSolution);
        }
        ICPControllerQPInputCalculator.submitFeedbackRateMinimizationTask(this.feedbackRateMinimizationTask, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addCoPLocationConstraint() {
        int constraintSize = this.copLocationConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.copLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.copLocationConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void formulateCoPConstraint() {
        this.copLocationConstraint.setPolygon();
        if (this.copLocationConstraint.getInequalityConstraintSize() > 0) {
            this.copLocationConstraint.setPositionOffset(this.desiredCoP);
            this.copLocationConstraint.setDeltaInside(this.copSafeDistanceToEdge);
            this.copLocationConstraint.formulateConstraint();
        }
    }

    private void addCMPLocationConstraint() {
        int constraintSize = this.cmpLocationConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.cmpLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)2, (DMatrix)this.cmpLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.cmpLocationConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void formulateCMPConstraint() {
        this.cmpLocationConstraint.setPolygon();
        if (this.cmpLocationConstraint.getInequalityConstraintSize() == 0) {
            return;
        }
        double cmpConstraintBound = this.useAngularMomentum.getBooleanValue() ? -this.cmpSafeDistanceFromEdge : this.copSafeDistanceToEdge;
        if (!Double.isFinite(cmpConstraintBound)) {
            this.cmpLocationConstraint.reset();
            return;
        }
        this.cmpLocationConstraint.setPositionOffset(this.desiredCMP);
        this.cmpLocationConstraint.setDeltaInside(cmpConstraintBound);
        this.cmpLocationConstraint.formulateConstraint();
    }

    private void addDynamicConstraintTask() {
        this.inputCalculator.computeDynamicsTask(this.dynamicsTaskInput, this.currentICPError, this.feedbackGain, this.dynamicsWeight, this.useAngularMomentum.getBooleanValue());
        ICPControllerQPInputCalculator.submitDynamicsTask(this.dynamicsTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addFeedbackDirectionTask() {
        if (this.feedbackDirectionWeight == 0.0) {
            return;
        }
        this.inputCalculator.computeFeedbackDirectionTask(this.dynamicsTaskInput, this.desiredFeedbackDirection, this.feedbackDirectionWeight, this.useAngularMomentum.getBooleanValue());
        ICPControllerQPInputCalculator.submitDynamicsTask(this.dynamicsTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addMaximumFeedbackMagnitudeConstraint() {
        if (!Double.isFinite(this.maxFeedbackXMagnitude) && !Double.isFinite(this.maxFeedbackYMagnitude)) {
            return;
        }
        ICPControllerQPConstraintCalculator.calculateMaxFeedbackMagnitudeConstraint(this.feedbackLimitConstraint, this.maxFeedbackXMagnitude, this.maxFeedbackYMagnitude, this.useAngularMomentum.getBooleanValue());
        int feedbackMagnitudeConstraintSize = this.feedbackLimitConstraint.getNumberOfConstraints();
        int numberOfVariables = this.feedbackLimitConstraint.getNumberOfVariables();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackLimitConstraint.Aineq, (int)0, (int)0, (int)feedbackMagnitudeConstraintSize, (int)numberOfVariables, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackLimitConstraint.bineq, (int)0, (int)0, (int)feedbackMagnitudeConstraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += feedbackMagnitudeConstraintSize;
    }

    private void addMaximumFeedbackRateConstraint() {
        if (!Double.isFinite(this.maxFeedbackXMagnitude) && !Double.isFinite(this.maxFeedbackYMagnitude)) {
            return;
        }
        ICPControllerQPConstraintCalculator.calculateMaxFeedbackRateConstraint(this.feedbackRateLimitConstraint, this.maximumFeedbackRate, this.previousFeedbackDeltaSolution, this.controlDT, this.useAngularMomentum.getBooleanValue());
        int feedbackRateConstraintSize = this.feedbackRateLimitConstraint.getNumberOfConstraints();
        int numberOfVariables = this.feedbackLimitConstraint.getNumberOfVariables();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackRateLimitConstraint.Aineq, (int)0, (int)0, (int)feedbackRateConstraintSize, (int)numberOfVariables, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackRateLimitConstraint.bineq, (int)0, (int)0, (int)feedbackRateConstraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += feedbackRateConstraintSize;
    }

    private boolean solve(DMatrixRMaj solutionToPack) {
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.solverInput_h);
        this.solver.clear();
        if (this.pollResetActiveSet() || this.previousTickFailed) {
            this.solver.resetActiveSet();
        }
        this.solver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_h, this.solverInputResidualCost.get(0, 0));
        this.solver.setLinearInequalityConstraints((DMatrix)this.solverInput_Aineq, (DMatrix)this.solverInput_bineq);
        try {
            this.numberOfIterations = this.solver.solve((DMatrix)solutionToPack);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogTools.warn((String)"ICP optimization crashed with exception.");
            return false;
        }
        return !MatrixTools.containsNaN((DMatrix1Row)solutionToPack);
    }

    private void extractCoPFeedbackDeltaSolution(DMatrixRMaj copFeedbackSolutionToPack) {
        MatrixTools.setMatrixBlock((DMatrix)copFeedbackSolutionToPack, (int)0, (int)0, (DMatrix)this.solution, (int)0, (int)0, (int)2, (int)1, (double)1.0);
    }

    private void extractCMPFeedbackDeltaSolution(DMatrixRMaj cmpDeltaSolutionToPack) {
        if (this.useAngularMomentum.getBooleanValue()) {
            MatrixTools.setMatrixBlock((DMatrix)cmpDeltaSolutionToPack, (int)0, (int)0, (DMatrix)this.solution, (int)2, (int)0, (int)2, (int)1, (double)1.0);
        } else {
            cmpDeltaSolutionToPack.zero();
        }
    }

    private void setPreviousFeedbackDeltaSolution(DMatrixRMaj copFeedbackSolution, DMatrixRMaj cmpFeedbackSolution) {
        this.previousCoPFeedbackDeltaSolution.set((DMatrixD1)copFeedbackSolution);
        this.previousCMPFeedbackDeltaSolution.set((DMatrixD1)cmpFeedbackSolution);
        CommonOps_DDRM.add((DMatrixD1)cmpFeedbackSolution, (DMatrixD1)copFeedbackSolution, (DMatrixD1)this.previousFeedbackDeltaSolution);
    }

    public void getCoPFeedbackDifference(FixedFrameVector2DBasics cmpFeedbackDifferenceToPack) {
        cmpFeedbackDifferenceToPack.checkReferenceFrameMatch(worldFrame);
        cmpFeedbackDifferenceToPack.set((DMatrix)this.copDeltaSolution);
    }

    public void getCMPFeedbackDifference(FixedFrameVector2DBasics differenceToPack) {
        differenceToPack.checkReferenceFrameMatch(worldFrame);
        differenceToPack.set((DMatrix)this.cmpDeltaSolution);
    }

    public void getResidualDynamicsError(FixedFrameVector2DBasics errorToPack) {
        errorToPack.checkReferenceFrameMatch(worldFrame);
        errorToPack.set((DMatrix)this.residualDynamicsError);
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    ConstraintToConvexRegion getCoPLocationConstraint() {
        return this.copLocationConstraint;
    }

    ConstraintToConvexRegion getCMPLocationConstraint() {
        return this.cmpLocationConstraint;
    }
}

