/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.controller;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPInequalityInput;

public class ICPControllerQPConstraintCalculator {
    public static void calculateMaxFeedbackMagnitudeConstraint(ICPInequalityInput inputToPack, double maxXMagnitude, double maxYMagnitude, boolean useAngularMomentum) {
        ICPControllerQPConstraintCalculator.calculateMaxFeedbackMagnitudeConstraint(inputToPack, -maxXMagnitude, maxXMagnitude, -maxYMagnitude, maxYMagnitude, useAngularMomentum);
    }

    private static void calculateMaxFeedbackMagnitudeConstraint(ICPInequalityInput inputToPack, double minXMagnitude, double maxXMagnitude, double minYMagnitude, double maxYMagnitude, boolean useAngularMomentum) {
        inputToPack.reset();
        int size = 0;
        boolean hasXMax = Double.isFinite(maxXMagnitude);
        boolean hasXMin = Double.isFinite(minXMagnitude);
        boolean hasYMax = Double.isFinite(maxYMagnitude);
        boolean hasYMin = Double.isFinite(minYMagnitude);
        if (hasXMax) {
            ++size;
        }
        if (hasXMin) {
            ++size;
        }
        if (hasYMax) {
            ++size;
        }
        if (hasYMin) {
            ++size;
        }
        int numberOfFreeVariables = useAngularMomentum ? 4 : 2;
        inputToPack.reshape(size, numberOfFreeVariables);
        int offset = 0;
        if (hasXMax) {
            inputToPack.Aineq.set(offset, 0, 1.0);
            if (useAngularMomentum) {
                inputToPack.Aineq.set(offset, 2, 1.0);
            }
            inputToPack.bineq.set(offset, maxXMagnitude);
            ++offset;
        }
        if (hasXMin) {
            inputToPack.Aineq.set(offset, 0, -1.0);
            if (useAngularMomentum) {
                inputToPack.Aineq.set(offset, 2, -1.0);
            }
            inputToPack.bineq.set(offset, -minXMagnitude);
            ++offset;
        }
        if (hasYMax) {
            inputToPack.Aineq.set(offset, 1, 1.0);
            if (useAngularMomentum) {
                inputToPack.Aineq.set(offset, 3, 1.0);
            }
            inputToPack.bineq.set(offset, maxYMagnitude);
            ++offset;
        }
        if (hasYMin) {
            inputToPack.Aineq.set(offset, 1, -1.0);
            if (useAngularMomentum) {
                inputToPack.Aineq.set(offset, 3, -1.0);
            }
            inputToPack.bineq.set(offset, -minYMagnitude);
        }
    }

    public static void calculateMaxFeedbackRateConstraint(ICPInequalityInput inputToPack, double maxRate, DMatrixRMaj previousValue, double controlDT, boolean useAngularMomentum) {
        ICPControllerQPConstraintCalculator.calculateMaxFeedbackRateConstraint(inputToPack, maxRate, maxRate, previousValue.get(0), previousValue.get(1), controlDT, useAngularMomentum);
    }

    public static void calculateMaxFeedbackRateConstraint(ICPInequalityInput inputToPack, double maxXRate, double maxYRate, double previousXValue, double previousYValue, double controlDT, boolean useAngularMomentum) {
        double maxXValue = previousXValue + controlDT * maxXRate;
        double minXValue = previousXValue - controlDT * maxXRate;
        double maxYValue = previousYValue + controlDT * maxYRate;
        double minYValue = previousYValue - controlDT * maxYRate;
        ICPControllerQPConstraintCalculator.calculateMaxFeedbackMagnitudeConstraint(inputToPack, minXValue, maxXValue, minYValue, maxYValue, useAngularMomentum);
    }
}

