/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.controller;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ParameterizedICPControlGains;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.AngularMomentumIntegrator;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPControllerQPSolver;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationCoPConstraintHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationControllerHelper;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class ICPController {
    private static final boolean VISUALIZE = true;
    private static final String yoNamePrefix = "controller";
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BooleanProvider useCMPFeedback;
    private final BooleanProvider useAngularMomentum;
    private final BooleanProvider scaleFeedbackWeightWithGain;
    final YoFrameVector2D icpError = new YoFrameVector2D("controllerICPError", "", worldFrame, this.registry);
    private final YoFramePoint2D feedbackCoP = new YoFramePoint2D("controllerFeedbackCoPSolution", worldFrame, this.registry);
    private final YoFramePoint2D feedbackCMP = new YoFramePoint2D("controllerFeedbackCMPSolution", worldFrame, this.registry);
    private final YoFrameVector2D unconstrainedFeedback = new YoFrameVector2D("controllerUnconstrainedFeedback", worldFrame, this.registry);
    private final YoFramePoint2D unconstrainedFeedbackCMP = new YoFramePoint2D("controllerUnconstrainedFeedbackCMP", worldFrame, this.registry);
    final YoFramePoint2D perfectCoP = new YoFramePoint2D("controllerPerfectCoP", worldFrame, this.registry);
    final YoFramePoint2D perfectCMP = new YoFramePoint2D("controllerPerfectCMP", worldFrame, this.registry);
    final YoFrameVector2D feedbackCoPDelta = new YoFrameVector2D("controllerFeedbackCoPDeltaSolution", worldFrame, this.registry);
    final YoFrameVector2D feedbackCMPDelta = new YoFrameVector2D("controllerFeedbackCMPDeltaSolution", worldFrame, this.registry);
    private final DMatrixRMaj feedbackCMPDeltaMatrix = new DMatrixRMaj(2, 1);
    private final YoFrameVector2D residualDynamicsError = new YoFrameVector2D("controllerResidualDynamicsError", worldFrame, this.registry);
    private final YoFrameVector2D residualDynamicsErrorConservative = new YoFrameVector2D("controllerResidualDynamicsErrorConservative", worldFrame, this.registry);
    private final DMatrixRMaj residualDynamicsErrorConservativeMatrix = new DMatrixRMaj(2, 1);
    private final DoubleProvider copFeedbackForwardWeight;
    private final DoubleProvider copFeedbackLateralWeight;
    private final DoubleProvider cmpFeedbackWeight;
    private final DMatrixRMaj scaledCoPFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DoubleProvider maxAllowedDistanceCMPSupport;
    private final DoubleProvider safeCoPDistanceToEdge;
    private final DoubleProvider feedbackRateWeight;
    private final DoubleProvider copCMPFeedbackRateWeight;
    private final DoubleProvider dynamicsObjectiveWeight;
    private final DoubleProvider feedbackDirectionWeight;
    private final AngularMomentumIntegrator integrator;
    private final ICPControlGainsReadOnly feedbackGains;
    private final DMatrixRMaj transformedGains = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj inverseTransformedGains = new DMatrixRMaj(2, 2);
    private final FrameVector2D transformedMagnitudeLimits = new FrameVector2D();
    private final YoInteger numberOfIterations = new YoInteger("controllerNumberOfIterations", this.registry);
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("controllerHasNotConvergedInPast", this.registry);
    private final YoBoolean previousTickFailed = new YoBoolean("controllerPreviousTickFailed", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("controllerHasNotConvergedCounts", this.registry);
    private final IntegerProvider maxNumberOfIterations = new IntegerParameter("controllerMaxNumberOfIterations", this.registry, 100);
    private final ICPOptimizationCoPConstraintHandler copConstraintHandler;
    private final ICPControllerQPSolver solver;
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("icpQPSolverTimer", 0.5, this.registry);
    private final ExecutionTimer controllerTimer = new ExecutionTimer("icpControllerTimer", 0.5, this.registry);
    private final FramePoint2D desiredICP = new FramePoint2D();
    private final FrameVector2D desiredICPVelocity = new FrameVector2D();
    private final FrameVector2D perfectCMPOffset = new FrameVector2D();
    private final FramePoint2D currentICP = new FramePoint2D();
    private final FramePoint2D currentCoMPosition = new FramePoint2D();
    private final FrameVector2D currentCoMVelocity = new FrameVector2D();
    private final double controlDT;
    private final double controlDTSquare;
    private final ICPOptimizationControllerHelper helper = new ICPOptimizationControllerHelper();
    private final FrameVector2D desiredCMPOffsetToThrowAway = new FrameVector2D();

    public ICPController(WalkingControllerParameters walkingControllerParameters, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters, walkingControllerParameters.getICPOptimizationParameters(), bipedSupportPolygons, icpControlPolygons, contactableFeet, controlDT, parentRegistry, yoGraphicsListRegistry);
    }

    public ICPController(WalkingControllerParameters walkingControllerParameters, ICPOptimizationParameters icpOptimizationParameters, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.controlDT = controlDT;
        this.controlDTSquare = controlDT * controlDT;
        this.useCMPFeedback = new BooleanParameter("controllerUseCMPFeedback", this.registry, icpOptimizationParameters.useCMPFeedback());
        this.useAngularMomentum = new BooleanParameter("controllerUseAngularMomentum", this.registry, icpOptimizationParameters.useAngularMomentum());
        this.scaleFeedbackWeightWithGain = new BooleanParameter("controllerScaleFeedbackWeightWithGain", this.registry, icpOptimizationParameters.scaleFeedbackWeightWithGain());
        this.copFeedbackForwardWeight = new DoubleParameter("controllerCoPFeedbackForwardWeight", this.registry, icpOptimizationParameters.getFeedbackForwardWeight());
        this.copFeedbackLateralWeight = new DoubleParameter("controllerCoPFeedbackLateralWeight", this.registry, icpOptimizationParameters.getFeedbackLateralWeight());
        this.copCMPFeedbackRateWeight = new DoubleParameter("controllerCoPCMPFeedbackRateWeight", this.registry, icpOptimizationParameters.getCoPCMPFeedbackRateWeight());
        this.feedbackRateWeight = new DoubleParameter("controllerFeedbackRateWeight", this.registry, icpOptimizationParameters.getFeedbackRateWeight());
        this.feedbackGains = new ParameterizedICPControlGains("", icpOptimizationParameters.getICPFeedbackGains(), this.registry);
        this.dynamicsObjectiveWeight = new DoubleParameter("controllerDynamicsObjectiveWeight", this.registry, icpOptimizationParameters.getDynamicsObjectiveWeight());
        this.cmpFeedbackWeight = new DoubleParameter("controllerCMPFeedbackWeight", this.registry, icpOptimizationParameters.getAngularMomentumMinimizationWeight());
        this.feedbackDirectionWeight = new DoubleParameter("controllerFeedbackDirectionWeight", this.registry, icpOptimizationParameters.getFeedbackDirectionWeight());
        BooleanParameter useICPControlPolygons = new BooleanParameter("controllerUseICPControlPolygons", this.registry, icpOptimizationParameters.getUseICPControlPolygons());
        boolean hasICPControlPolygons = icpControlPolygons != null;
        this.safeCoPDistanceToEdge = new DoubleParameter("controllerSafeCoPDistanceToEdge", this.registry, icpOptimizationParameters.getSafeCoPDistanceToEdge());
        double defaultMaxAllowedDistanceCMPSupport = walkingControllerParameters != null ? walkingControllerParameters.getMaxAllowedDistanceCMPSupport() : Double.NaN;
        this.maxAllowedDistanceCMPSupport = new DoubleParameter("controllerMaxAllowedDistanceCMPSupport", this.registry, defaultMaxAllowedDistanceCMPSupport);
        this.integrator = new AngularMomentumIntegrator(yoNamePrefix, icpOptimizationParameters, this.feedbackGains, controlDT, this.registry);
        int totalVertices = 0;
        for (RobotSide robotSide : RobotSide.values) {
            totalVertices += ((ContactablePlaneBody)contactableFeet.get((Enum)robotSide)).getTotalNumberOfContactPoints();
        }
        boolean updateRateAutomatically = true;
        this.solver = new ICPControllerQPSolver(totalVertices, updateRateAutomatically, this.registry);
        this.copConstraintHandler = new ICPOptimizationCoPConstraintHandler(bipedSupportPolygons, icpControlPolygons, (BooleanProvider)useICPControlPolygons, hasICPControlPolygons, this.registry);
        if (yoGraphicsListRegistry != null) {
            this.setupVisualizers(yoGraphicsListRegistry);
        }
        parentRegistry.addChild(this.registry);
    }

    private void setupVisualizers(YoGraphicsListRegistry yoGraphicsListRegistry) {
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoGraphicPosition feedbackCoP = new YoGraphicPosition("controllerFeedbackCoP", this.feedbackCoP, 0.005, YoAppearance.Darkorange(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoGraphicPosition unconstrainedFeedbackCMP = new YoGraphicPosition("controllerUnconstrainedFeedbackCoP", this.unconstrainedFeedbackCMP, 0.006, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        artifactList.add((Artifact)feedbackCoP.createArtifact());
        artifactList.add((Artifact)unconstrainedFeedbackCMP.createArtifact());
        artifactList.setVisible(true);
        yoGraphicsListRegistry.registerArtifactList(artifactList);
    }

    public void initialize() {
        this.integrator.reset();
    }

    public void getDesiredCMP(FixedFramePoint2DBasics desiredCMPToPack) {
        desiredCMPToPack.set((FrameTuple2DReadOnly)this.feedbackCMP);
    }

    public void getDesiredCoP(FixedFramePoint2DBasics desiredCoPToPack) {
        desiredCoPToPack.set((FrameTuple2DReadOnly)this.feedbackCoP);
    }

    public boolean useAngularMomentum() {
        return this.useAngularMomentum.getValue();
    }

    public void compute(FramePoint2DReadOnly desiredICP, FrameVector2DReadOnly desiredICPVelocity, FramePoint2DReadOnly perfectCoP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly currentCoMPosition, double omega0) {
        this.desiredCMPOffsetToThrowAway.setToZero(worldFrame);
        this.compute(desiredICP, desiredICPVelocity, perfectCoP, (FrameVector2DReadOnly)this.desiredCMPOffsetToThrowAway, currentICP, currentCoMPosition, omega0);
    }

    public void compute(FramePoint2DReadOnly desiredICP, FrameVector2DReadOnly desiredICPVelocity, FramePoint2DReadOnly perfectCoP, FrameVector2DReadOnly perfectCMPOffset, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly currentCoMPosition, double omega0) {
        this.controllerTimer.startMeasurement();
        this.desiredICP.setMatchingFrame((FrameTuple2DReadOnly)desiredICP);
        this.desiredICPVelocity.setMatchingFrame((FrameTuple2DReadOnly)desiredICPVelocity);
        this.perfectCMPOffset.setMatchingFrame((FrameTuple2DReadOnly)perfectCMPOffset);
        this.currentICP.setMatchingFrame((FrameTuple2DReadOnly)currentICP);
        this.currentCoMPosition.setMatchingFrame((FrameTuple2DReadOnly)currentCoMPosition);
        CapturePointTools.computeCenterOfMassVelocity(currentCoMPosition, currentICP, omega0, (FixedFrameVector2DBasics)this.currentCoMVelocity);
        this.perfectCoP.setMatchingFrame((FrameTuple2DReadOnly)perfectCoP);
        this.perfectCMP.add((FrameTuple2DReadOnly)this.perfectCoP, (FrameTuple2DReadOnly)this.perfectCMPOffset);
        this.icpError.sub((FrameTuple2DReadOnly)currentICP, (FrameTuple2DReadOnly)desiredICP);
        this.scaleFeedbackWeightWithGain();
        this.submitSolverTaskConditions();
        this.solver.setMaxNumberOfIterations(this.maxNumberOfIterations.getValue());
        this.qpSolverTimer.startMeasurement();
        boolean converged = this.solveQP();
        this.qpSolverTimer.stopMeasurement();
        this.extractSolutionsFromSolver(converged);
        this.controllerTimer.stopMeasurement();
    }

    private void submitSolverTaskConditions() {
        this.solver.resetCoPLocationConstraint();
        this.solver.addSupportPolygon(this.copConstraintHandler.updateCoPConstraint());
        if (this.copConstraintHandler.hasSupportPolygonChanged()) {
            this.solver.notifyResetActiveSet();
        }
        this.helper.transformGainsFromDynamicsFrame((DMatrix1Row)this.transformedGains, (FrameVector2DReadOnly)this.desiredICPVelocity, this.feedbackGains.getKpParallelToMotion(), this.feedbackGains.getKpOrthogonalToMotion());
        this.helper.transformFromDynamicsFrame((FixedFrameVector2DBasics)this.transformedMagnitudeLimits, (FrameVector2DReadOnly)this.desiredICPVelocity, this.feedbackGains.getFeedbackPartMaxValueParallelToMotion(), this.feedbackGains.getFeedbackPartMaxValueOrthogonalToMotion());
        this.computeUnconstrainedFeedbackCMPGain();
        UnrolledInverseFromMinor_DDRM.inv((DMatrixRMaj)this.transformedGains, (DMatrixRMaj)this.inverseTransformedGains);
        this.solver.resetCoPFeedbackConditions();
        this.solver.resetFeedbackDirection();
        this.solver.setFeedbackConditions(this.scaledCoPFeedbackWeight, this.transformedGains, this.dynamicsObjectiveWeight.getValue());
        this.solver.setMaxCMPDistanceFromEdge(this.maxAllowedDistanceCMPSupport.getValue());
        this.solver.setCopSafeDistanceToEdge(this.safeCoPDistanceToEdge.getValue());
        this.solver.setDesiredFeedbackDirection((FrameVector2DReadOnly)this.unconstrainedFeedback, this.feedbackDirectionWeight.getValue());
        this.solver.setMaximumFeedbackMagnitude((FrameVector2DReadOnly)this.transformedMagnitudeLimits);
        this.solver.setMaximumFeedbackRate(this.feedbackGains.getFeedbackPartMaxRate(), this.controlDT);
        this.solver.setFeedbackRateWeight(this.copCMPFeedbackRateWeight.getValue() / this.controlDTSquare, this.feedbackRateWeight.getValue() / this.controlDTSquare);
        if (this.useCMPFeedback.getValue()) {
            this.solver.setCMPFeedbackConditions(this.cmpFeedbackWeight.getValue(), this.useAngularMomentum.getValue());
        }
    }

    private boolean solveQP() {
        boolean converged = this.solver.compute((FrameVector2DReadOnly)this.icpError, (FramePoint2DReadOnly)this.perfectCoP, (FrameVector2DReadOnly)this.perfectCMPOffset);
        this.previousTickFailed.set(this.solver.previousTickFailed());
        if (!converged) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                LogTools.warn((String)"The QP has not converged. Only showing this once if it happens repeatedly.");
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
        }
        return converged;
    }

    private void computeUnconstrainedFeedbackCMPGain() {
        this.unconstrainedFeedback.setX(this.transformedGains.get(0, 0) * this.icpError.getX() + this.transformedGains.get(0, 1) * this.icpError.getY());
        this.unconstrainedFeedback.setY(this.transformedGains.get(1, 0) * this.icpError.getX() + this.transformedGains.get(1, 1) * this.icpError.getY());
        this.unconstrainedFeedbackCMP.add((FrameTuple2DReadOnly)this.perfectCoP, (FrameTuple2DReadOnly)this.perfectCMPOffset);
        this.unconstrainedFeedbackCMP.add((FrameTuple2DReadOnly)this.unconstrainedFeedback);
    }

    private void extractSolutionsFromSolver(boolean converged) {
        this.numberOfIterations.set(this.solver.getNumberOfIterations());
        if (converged) {
            this.solver.getCoPFeedbackDifference((FixedFrameVector2DBasics)this.feedbackCoPDelta);
            this.solver.getCMPFeedbackDifference((FixedFrameVector2DBasics)this.feedbackCMPDelta);
            this.solver.getResidualDynamicsError((FixedFrameVector2DBasics)this.residualDynamicsError);
            this.feedbackCoPDelta.get((DMatrix)this.feedbackCMPDeltaMatrix);
            CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.inverseTransformedGains, (DMatrix1Row)this.feedbackCMPDeltaMatrix, (DMatrix1Row)this.residualDynamicsErrorConservativeMatrix);
            this.residualDynamicsErrorConservative.set((DMatrix)this.residualDynamicsErrorConservativeMatrix);
            this.residualDynamicsErrorConservative.add((FrameTuple2DReadOnly)this.icpError);
        }
        this.integrator.update((FrameVector2DReadOnly)this.desiredICPVelocity, (FrameVector2DReadOnly)this.currentCoMVelocity, (FrameVector2DReadOnly)this.icpError);
        this.feedbackCoP.add((FrameTuple2DReadOnly)this.perfectCoP, (FrameTuple2DReadOnly)this.feedbackCoPDelta);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.feedbackCoP, (FrameTuple2DReadOnly)this.perfectCMPOffset);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.feedbackCMPDelta);
        this.feedbackCMP.add((FrameTuple2DReadOnly)this.integrator.getFeedbackCMPIntegral());
    }

    private void scaleFeedbackWeightWithGain() {
        this.helper.transformFromDynamicsFrame((DMatrix1Row)this.scaledCoPFeedbackWeight, (FrameVector2DReadOnly)this.desiredICPVelocity, this.copFeedbackForwardWeight.getValue(), this.copFeedbackLateralWeight.getValue());
        if (this.scaleFeedbackWeightWithGain.getValue()) {
            double parallel = this.feedbackGains.getKpParallelToMotion();
            double orthogonal = this.feedbackGains.getKpOrthogonalToMotion();
            double magnitude = this.helper.transformGainsFromDynamicsFrame((DMatrix1Row)this.transformedGains, (FrameVector2DReadOnly)this.desiredICPVelocity, parallel, orthogonal);
            CommonOps_DDRM.scale((double)(1.0 / magnitude), (DMatrixD1)this.scaledCoPFeedbackWeight);
        }
    }

    public void setKeepCoPInsideSupportPolygon(boolean keepCoPInsideSupportPolygon) {
        this.copConstraintHandler.setKeepCoPInsideSupportPolygon(keepCoPInsideSupportPolygon);
    }

    public FrameVector2DReadOnly getResidualError() {
        return this.residualDynamicsErrorConservative;
    }
}

