/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;

public class SwingSpeedUpCalculator {
    private final FrameLine2D desiredICPToFinalICPLine = new FrameLine2D();
    private final FrameLineSegment2D desiredICPToFinalICPLineSegment = new FrameLineSegment2D();
    private final FramePoint2D projectedICPEstimate = new FramePoint2D();

    public double estimateDeltaTimeBetweenDesiredICPAndActualICP(FramePoint2DReadOnly desiredICPPosition, FramePoint2DReadOnly desiredCMPPosition, FramePoint2DReadOnly desiredICPAtTouchdown, FramePoint2DReadOnly actualICPPosition, double omega0) {
        if (desiredICPPosition.distance(desiredICPAtTouchdown) < 1.0E-10) {
            return Double.NaN;
        }
        this.desiredICPToFinalICPLineSegment.set(desiredICPPosition, desiredICPAtTouchdown);
        double percentAlongLineSegmentICP = this.desiredICPToFinalICPLineSegment.percentageAlongLineSegment(actualICPPosition);
        if (percentAlongLineSegmentICP < 0.0) {
            this.desiredICPToFinalICPLine.set(desiredICPPosition, desiredICPAtTouchdown);
            this.desiredICPToFinalICPLine.orthogonalProjection(actualICPPosition, (FramePoint2DBasics)this.projectedICPEstimate);
        } else {
            this.desiredICPToFinalICPLineSegment.orthogonalProjection(actualICPPosition, (FramePoint2DBasics)this.projectedICPEstimate);
        }
        double actualDistanceDueToDisturbance = desiredCMPPosition.distance((FramePoint2DReadOnly)this.projectedICPEstimate);
        double expectedDistanceAccordingToPlan = desiredCMPPosition.distance(desiredICPPosition);
        double distanceRatio = actualDistanceDueToDisturbance / expectedDistanceAccordingToPlan;
        if (distanceRatio < 0.001) {
            return 0.0;
        }
        return Math.log(distanceRatio) / omega0;
    }
}

