/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleOutput;
import us.ihmc.commonWalkingControlModules.capturePoint.SimpleLinearMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRMomentumController;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.messageHandlers.PlanarRegionsListHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.StepConstraintRegionHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.CapturePointCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.footstep.SimpleFootstep;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.FilteredVelocityYoFrameVector2d;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameVector;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimpleLinearMomentumRateControlModule {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Vector3DReadOnly linearMomentumRateWeight;
    private final Vector3DReadOnly recoveryLinearMomentumRateWeight;
    private final Vector3DReadOnly angularMomentumRateWeight;
    private final BooleanProvider allowMomentumRecoveryWeight;
    private final YoBoolean useRecoveryMomentumWeight;
    private final DoubleParameter maxMomentumRateWeightChangeRate;
    private final RateLimitedYoFrameVector desiredLinearMomentumRateWeight;
    private final YoBoolean minimizingAngularMomentumRateZ = new YoBoolean("MinimizingAngularMomentumRateZ", this.registry);
    private final YoFrameVector3D controlledCoMAcceleration;
    private final MomentumRateCommand momentumRateCommand = new MomentumRateCommand();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private double omega0;
    private double totalMass;
    private double gravityZ;
    private final ReferenceFrame centerOfMassFrame;
    private final FramePoint3D centerOfMass;
    private final FramePoint2D centerOfMass2d = new FramePoint2D();
    private final FramePoint2D capturePoint = new FramePoint2D();
    private final CapturePointCalculator capturePointCalculator;
    private final FixedFramePoint2DBasics desiredCapturePoint = new FramePoint2D();
    private final FixedFrameVector2DBasics desiredCapturePointVelocity = new FrameVector2D();
    private final FixedFramePoint2DBasics perfectCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics perfectCoP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCoP = new FramePoint2D();
    private final FixedFramePoint2DBasics achievedCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCoPInMidFeet;
    private final List<Polynomial3DReadOnly> vrpTrajectories = new ArrayList<Polynomial3DReadOnly>();
    private double timeInContactPhase = 0.0;
    private boolean controlHeightWithMomentum;
    private final FrameVector3D achievedLinearMomentumRate = new FrameVector3D();
    private final FrameVector2D achievedCoMAcceleration2d = new FrameVector2D();
    private double desiredCoMHeightAcceleration = 0.0;
    private final FramePoint3D cmp3d = new FramePoint3D();
    private final FrameVector3D linearMomentumRateOfChange = new FrameVector3D();
    private boolean desiredCMPcontainedNaN = false;
    private boolean desiredCoPcontainedNaN = false;
    private final LQRMomentumController lqrMomentumController;
    private final DMatrixRMaj currentState = new DMatrixRMaj(6, 1);
    private final BipedSupportPolygons bipedSupportPolygons;
    private final YoDouble yoTime;
    private final FixedFrameVector2DBasics perfectCMPDelta = new FrameVector2D();
    private RobotSide supportSide = null;
    private RobotSide transferToSide = null;
    private final YoFramePoint2D yoDesiredCMP = new YoFramePoint2D("desiredCMP", worldFrame, this.registry);
    private final YoFramePoint2D yoAchievedCMP = new YoFramePoint2D("achievedCMP", worldFrame, this.registry);
    private final YoFramePoint3D yoCenterOfMass = new YoFramePoint3D("centerOfMass", worldFrame, this.registry);
    private final YoFramePoint2D yoCapturePoint = new YoFramePoint2D("capturePoint", worldFrame, this.registry);
    private final FilteredVelocityYoFrameVector2d capturePointVelocity;
    private final DoubleProvider capturePointVelocityBreakFrequency = new DoubleParameter("capturePointVelocityBreakFrequency", this.registry, 26.5);
    private final DoubleParameter centerOfPressureWeight = new DoubleParameter("CenterOfPressureObjectiveWeight", this.registry, 0.0);
    private final CenterOfPressureCommand centerOfPressureCommand = new CenterOfPressureCommand();
    private final ReferenceFrame midFootZUpFrame;
    private boolean initializeForStanding;
    private boolean initializeForSingleSupport;
    private boolean initializeForTransfer;
    private boolean keepCoPInsideSupportPolygon;
    private double finalTransferDuration;
    private double remainingTimeInSwingUnderDisturbance;
    private final RecyclingArrayList<SimpleFootstep> footsteps = new RecyclingArrayList(SimpleFootstep.class);
    private final TDoubleArrayList swingDurations = new TDoubleArrayList();
    private final TDoubleArrayList transferDurations = new TDoubleArrayList();
    private final SideDependentList<PlaneContactStateCommand> contactStateCommands = new SideDependentList((Object)new PlaneContactStateCommand(), (Object)new PlaneContactStateCommand());
    private final LinearMomentumRateControlModuleOutput output = new LinearMomentumRateControlModuleOutput();
    private PlanarRegionsListHandler planarRegionsListHandler;
    private StepConstraintRegionHandler stepConstraintRegionHandler;

    public SimpleLinearMomentumRateControlModule(CommonHumanoidReferenceFrames referenceFrames, SideDependentList<ContactableFoot> contactableFeet, RigidBodyBasics elevator, WalkingControllerParameters walkingControllerParameters, YoDouble yoTime, double gravityZ, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry, double omega0) {
        this.totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)elevator);
        this.gravityZ = gravityZ;
        this.yoTime = yoTime;
        MomentumOptimizationSettings momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        this.linearMomentumRateWeight = new ParameterVector3D("LinearMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getLinearMomentumWeight(), this.registry);
        this.recoveryLinearMomentumRateWeight = new ParameterVector3D("RecoveryLinearMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getRecoveryLinearMomentumWeight(), this.registry);
        this.angularMomentumRateWeight = new ParameterVector3D("AngularMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getAngularMomentumWeight(), this.registry);
        this.allowMomentumRecoveryWeight = new BooleanParameter("allowMomentumRecoveryWeight", this.registry, false);
        this.maxMomentumRateWeightChangeRate = new DoubleParameter("maxMomentumRateWeightChangeRate", this.registry, 10.0);
        this.useRecoveryMomentumWeight = new YoBoolean("useRecoveryMomentumWeight", this.registry);
        this.useRecoveryMomentumWeight.set(false);
        this.desiredLinearMomentumRateWeight = new RateLimitedYoFrameVector("desiredLinearMomentumRateWeight", "", this.registry, (DoubleProvider)this.maxMomentumRateWeightChangeRate, controlDT, worldFrame);
        this.centerOfMassFrame = referenceFrames.getCenterOfMassFrame();
        this.midFootZUpFrame = referenceFrames.getMidFootZUpGroundFrame();
        this.centerOfMass = new FramePoint3D(this.centerOfMassFrame);
        this.controlledCoMAcceleration = new YoFrameVector3D("ControlledCoMAcceleration", "", this.centerOfMassFrame, this.registry);
        this.desiredCoPInMidFeet = new FramePoint2D(this.midFootZUpFrame);
        this.capturePointCalculator = new CapturePointCalculator(this.centerOfMassFrame, elevator);
        DoubleProvider capturePointVelocityAlpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.capturePointVelocityBreakFrequency.getValue(), (double)controlDT);
        this.capturePointVelocity = new FilteredVelocityYoFrameVector2d("capturePointVelocity", "", capturePointVelocityAlpha, controlDT, this.registry, worldFrame);
        if (yoGraphicsListRegistry != null) {
            YoGraphicPosition desiredCMPViz = new YoGraphicPosition("Desired CMP", this.yoDesiredCMP, 0.012, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition achievedCMPViz = new YoGraphicPosition("Achieved CMP", this.yoAchievedCMP, 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition centerOfMassViz = new YoGraphicPosition("Center Of Mass", this.yoCenterOfMass, 0.006, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition capturePointViz = new YoGraphicPosition("Capture Point", this.yoCapturePoint, 0.01, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)desiredCMPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)achievedCMPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)centerOfMassViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)capturePointViz.createArtifact());
        }
        this.yoDesiredCMP.setToNaN();
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
        this.yoCapturePoint.setToNaN();
        this.bipedSupportPolygons = new BipedSupportPolygons(referenceFrames, this.registry, null);
        this.lqrMomentumController = new LQRMomentumController(omega0, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.desiredLinearMomentumRateWeight.set((Tuple3DReadOnly)this.linearMomentumRateWeight);
        this.capturePointVelocity.reset();
        this.yoDesiredCMP.setToNaN();
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
        this.yoCapturePoint.setToNaN();
    }

    public void setPlanarRegionStepConstraintHandler(StepConstraintRegionHandler planarRegionStepConstraint) {
        this.stepConstraintRegionHandler = planarRegionStepConstraint;
    }

    public void setPlanarRegionsListHandler(PlanarRegionsListHandler planarRegionsListHandler) {
        this.planarRegionsListHandler = planarRegionsListHandler;
    }

    public void setInputFromWalkingStateMachine(SimpleLinearMomentumRateControlModuleInput input) {
        int i;
        this.omega0 = input.getOmega0();
        this.useRecoveryMomentumWeight.set(input.getUseMomentumRecoveryMode());
        this.desiredCapturePoint.setMatchingFrame((FrameTuple2DReadOnly)input.getDesiredCapturePoint());
        this.desiredCapturePointVelocity.setMatchingFrame((FrameTuple2DReadOnly)input.getDesiredCapturePointVelocity());
        this.desiredCoMHeightAcceleration = input.getDesiredCoMHeightAcceleration();
        this.vrpTrajectories.clear();
        this.vrpTrajectories.addAll(input.getVRPTrajectories());
        this.timeInContactPhase = input.getTimeInContactPhase();
        this.minimizingAngularMomentumRateZ.set(input.getMinimizeAngularMomentumRateZ());
        this.perfectCMP.setMatchingFrame((FrameTuple2DReadOnly)input.getPerfectCMP());
        this.perfectCoP.setMatchingFrame((FrameTuple2DReadOnly)input.getPerfectCoP());
        this.controlHeightWithMomentum = input.getControlHeightWithMomentum();
        this.supportSide = input.getSupportSide();
        this.transferToSide = input.getTransferToSide();
        this.footsteps.clear();
        for (i = 0; i < input.getFootsteps().size(); ++i) {
            ((SimpleFootstep)this.footsteps.add()).set((SimpleFootstep)input.getFootsteps().get(i));
        }
        this.swingDurations.reset();
        for (i = 0; i < input.getSwingDurations().size(); ++i) {
            this.swingDurations.add(input.getSwingDurations().get(i));
        }
        this.transferDurations.reset();
        for (i = 0; i < input.getTransferDurations().size(); ++i) {
            this.transferDurations.add(input.getTransferDurations().get(i));
        }
        this.finalTransferDuration = input.getFinalTransferDuration();
        this.initializeForStanding = input.getInitializeForStanding();
        this.initializeForSingleSupport = input.getInitializeForSingleSupport();
        this.initializeForTransfer = input.getInitializeForTransfer();
        this.remainingTimeInSwingUnderDisturbance = input.getRemainingTimeInSwingUnderDisturbance();
        this.keepCoPInsideSupportPolygon = input.getKeepCoPInsideSupportPolygon();
        for (RobotSide robotSide : RobotSide.values) {
            ((PlaneContactStateCommand)this.contactStateCommands.get((Enum)robotSide)).set((PlaneContactStateCommand)input.getContactStateCommands().get((Enum)robotSide));
        }
    }

    public void setInputFromControllerCore(ControllerCoreOutput controllerCoreOutput) {
        controllerCoreOutput.getLinearMomentumRate((FrameVector3DBasics)this.achievedLinearMomentumRate);
    }

    public LinearMomentumRateControlModuleOutput getOutputForWalkingStateMachine() {
        return this.output;
    }

    public MomentumRateCommand getMomentumRateCommand() {
        return this.momentumRateCommand;
    }

    public CenterOfPressureCommand getCenterOfPressureCommand() {
        return this.centerOfPressureCommand;
    }

    public boolean computeControllerCoreCommands() {
        this.capturePointCalculator.compute((FramePoint2DBasics)this.capturePoint, this.omega0);
        this.capturePointVelocity.update((FrameTuple2DReadOnly)this.capturePoint);
        boolean success = SimpleLinearMomentumRateControlModule.checkInputs((FramePoint2DReadOnly)this.capturePoint, this.desiredCapturePoint, this.desiredCapturePointVelocity, this.perfectCoP, this.perfectCMP);
        this.updatePolygons();
        this.updateICPControllerState();
        this.computeICPController();
        this.checkAndPackOutputs();
        if (this.allowMomentumRecoveryWeight.getValue() && this.useRecoveryMomentumWeight.getBooleanValue()) {
            this.desiredLinearMomentumRateWeight.update((Tuple3DReadOnly)this.recoveryLinearMomentumRateWeight);
        } else {
            this.desiredLinearMomentumRateWeight.update((Tuple3DReadOnly)this.linearMomentumRateWeight);
        }
        this.yoDesiredCMP.set((FrameTuple2DReadOnly)this.desiredCMP);
        this.yoCenterOfMass.setFromReferenceFrame(this.centerOfMassFrame);
        this.yoCapturePoint.set((FrameTuple2DReadOnly)this.capturePoint);
        success = success && this.computeDesiredLinearMomentumRateOfChange();
        this.selectionMatrix.setToLinearSelectionOnly();
        this.selectionMatrix.selectLinearZ(this.controlHeightWithMomentum);
        this.selectionMatrix.selectAngularZ(this.minimizingAngularMomentumRateZ.getValue());
        this.momentumRateCommand.setLinearMomentumRate(this.linearMomentumRateOfChange);
        this.momentumRateCommand.setSelectionMatrix(this.selectionMatrix);
        this.momentumRateCommand.setWeights((Tuple3DReadOnly)this.angularMomentumRateWeight, (Tuple3DReadOnly)this.desiredLinearMomentumRateWeight);
        this.desiredCoPInMidFeet.setMatchingFrame((FrameTuple2DReadOnly)this.desiredCoP);
        this.centerOfPressureCommand.setDesiredCoP((FramePoint2DReadOnly)this.desiredCoP);
        this.centerOfPressureCommand.setWeight(this.midFootZUpFrame, this.centerOfPressureWeight.getValue(), this.centerOfPressureWeight.getValue());
        return success;
    }

    public void computeAchievedCMP() {
        if (this.achievedLinearMomentumRate.containsNaN()) {
            this.yoAchievedCMP.setToNaN();
            return;
        }
        this.centerOfMass2d.setToZero(this.centerOfMassFrame);
        this.centerOfMass2d.changeFrame(worldFrame);
        this.achievedCoMAcceleration2d.setIncludingFrame((FrameTuple3DReadOnly)this.achievedLinearMomentumRate);
        this.achievedCoMAcceleration2d.scale(1.0 / this.totalMass);
        this.achievedCoMAcceleration2d.changeFrame(worldFrame);
        this.achievedCMP.set((FrameTuple2DReadOnly)this.achievedCoMAcceleration2d);
        this.achievedCMP.scale(-1.0 / (this.omega0 * this.omega0));
        this.achievedCMP.add((FrameTuple2DReadOnly)this.centerOfMass2d);
        this.yoAchievedCMP.set((FrameTuple2DReadOnly)this.achievedCMP);
    }

    private void updatePolygons() {
        this.bipedSupportPolygons.updateUsingContactStateCommand(this.contactStateCommands);
    }

    private void updateICPControllerState() {
        if (this.initializeForStanding && this.initializeForTransfer || this.initializeForTransfer && this.initializeForSingleSupport || this.initializeForSingleSupport && this.initializeForStanding) {
            throw new RuntimeException("Can only initialize once per compute.");
        }
    }

    public void updateCurrentState(FramePoint3DReadOnly CenterOfMassPosition, FrameVector3DReadOnly CenterOfMassVelocity) {
        CenterOfMassPosition.get((DMatrix)this.currentState);
        CenterOfMassVelocity.get(3, (DMatrix)this.currentState);
    }

    private void computeICPController() {
        this.lqrMomentumController.setOmega(this.omega0);
        this.lqrMomentumController.setVRPTrajectory(this.vrpTrajectories);
        this.lqrMomentumController.computeControlInput(this.currentState, this.timeInContactPhase);
    }

    private void checkAndPackOutputs() {
        if (this.desiredCMP.containsNaN()) {
            if (!this.desiredCMPcontainedNaN) {
                LogTools.error((String)"Desired CMP contains NaN, setting it to the ICP - only showing this error once");
            }
            this.desiredCMP.set((FrameTuple2DReadOnly)this.capturePoint);
            this.desiredCMPcontainedNaN = true;
        } else {
            this.desiredCMPcontainedNaN = false;
        }
        if (this.desiredCoP.containsNaN()) {
            if (!this.desiredCoPcontainedNaN) {
                LogTools.error((String)"Desired CoP contains NaN, setting it to the desiredCMP - only showing this error once");
            }
            this.desiredCoP.set((FrameTuple2DReadOnly)this.desiredCMP);
            this.desiredCoPcontainedNaN = true;
        } else {
            this.desiredCoPcontainedNaN = false;
        }
        this.output.setDesiredCMP((FramePoint2DReadOnly)this.desiredCMP);
    }

    private boolean computeDesiredLinearMomentumRateOfChange() {
        boolean success = true;
        this.linearMomentumRateOfChange.setIncludingFrame(ReferenceFrame.getWorldFrame(), (DMatrix)this.lqrMomentumController.getU());
        this.linearMomentumRateOfChange.scale(this.totalMass);
        this.linearMomentumRateOfChange.changeFrame(this.centerOfMassFrame);
        this.linearMomentumRateOfChange.checkReferenceFrameMatch(this.centerOfMassFrame);
        if (this.linearMomentumRateOfChange.containsNaN()) {
            LogTools.error((String)"Desired LinearMomentumRateOfChange contained NaN, setting it to zero and failing.");
            this.linearMomentumRateOfChange.setToZero();
            success = false;
        }
        this.controlledCoMAcceleration.set((FrameTuple3DReadOnly)this.linearMomentumRateOfChange);
        this.controlledCoMAcceleration.scale(1.0 / this.totalMass);
        this.linearMomentumRateOfChange.changeFrame(worldFrame);
        return success;
    }

    private static boolean checkInputs(FramePoint2DReadOnly capturePoint, FixedFramePoint2DBasics desiredCapturePoint, FixedFrameVector2DBasics desiredCapturePointVelocity, FixedFramePoint2DBasics perfectCoP, FixedFramePoint2DBasics perfectCMP) {
        boolean inputsAreOk = true;
        if (desiredCapturePoint.containsNaN()) {
            LogTools.error((String)"Desired ICP contains NaN, setting it to the current ICP and failing.");
            desiredCapturePoint.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        if (desiredCapturePointVelocity.containsNaN()) {
            LogTools.error((String)"Desired ICP Velocity contains NaN, setting it to zero and failing.");
            desiredCapturePointVelocity.setToZero();
            inputsAreOk = false;
        }
        if (perfectCoP.containsNaN()) {
            LogTools.error((String)"Perfect CoP contains NaN, setting it to the current ICP and failing.");
            perfectCoP.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        if (perfectCMP.containsNaN()) {
            LogTools.error((String)"Perfect CMP contains NaN, setting it to the current ICP and failing.");
            perfectCMP.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        return inputsAreOk;
    }
}

