/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsProvider;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterizedICPControlGains
implements ICPControlGainsProvider {
    private final DoubleProvider kpParallelToMotion;
    private final DoubleProvider kpOrthogonalToMotion;
    private final DoubleProvider ki;
    private final DoubleProvider integralLeakRatio;
    private final DoubleProvider maxIntegralError;
    private final DoubleProvider feedbackPartMaxRate;
    private final DoubleProvider feedbackPartMaxValueParallelToMotion;
    private final DoubleProvider feedbackPartMaxValueOrthogonalToMotion;

    public ParameterizedICPControlGains(String suffix, YoRegistry registry) {
        this.kpParallelToMotion = new DoubleParameter("captureKpParallel" + suffix, registry);
        this.kpOrthogonalToMotion = new DoubleParameter("captureKpOrthogonal" + suffix, registry);
        this.ki = new DoubleParameter("captureKi" + suffix, registry);
        this.integralLeakRatio = new DoubleParameter("captureIntegralLeakRatio" + suffix, registry, 1.0);
        this.maxIntegralError = new DoubleParameter("captureMaxIntegralError" + suffix, registry, Double.POSITIVE_INFINITY);
        this.feedbackPartMaxRate = new DoubleParameter("feedbackPartMaxRate" + suffix, registry, Double.POSITIVE_INFINITY);
        this.feedbackPartMaxValueParallelToMotion = new DoubleParameter("feedbackPartMaxValueParallelToMotion" + suffix, registry, Double.POSITIVE_INFINITY);
        this.feedbackPartMaxValueOrthogonalToMotion = new DoubleParameter("feedbackPartMaxValueOrthogonalToMotion" + suffix, registry, Double.POSITIVE_INFINITY);
    }

    public ParameterizedICPControlGains(String suffix, ICPControlGainsReadOnly defaults, YoRegistry registry) {
        this.kpParallelToMotion = new DoubleParameter("captureKpParallel" + suffix, registry, defaults.getKpParallelToMotion());
        this.kpOrthogonalToMotion = new DoubleParameter("captureKpOrthogonal" + suffix, registry, defaults.getKpOrthogonalToMotion());
        this.ki = new DoubleParameter("captureKi" + suffix, registry, defaults.getKi());
        this.integralLeakRatio = new DoubleParameter("captureIntegralLeakRatio" + suffix, registry, defaults.getIntegralLeakRatio());
        this.maxIntegralError = new DoubleParameter("captureMaxIntegralError" + suffix, registry, defaults.getMaxIntegralError());
        this.feedbackPartMaxRate = new DoubleParameter("feedbackPartMaxRate" + suffix, registry, defaults.getFeedbackPartMaxRate());
        this.feedbackPartMaxValueParallelToMotion = new DoubleParameter("feedbackPartMaxValueParallelToMotion" + suffix, registry, defaults.getFeedbackPartMaxValueParallelToMotion());
        this.feedbackPartMaxValueOrthogonalToMotion = new DoubleParameter("feedbackPartMaxValueOrthogonalToMotion" + suffix, registry, defaults.getFeedbackPartMaxValueOrthogonalToMotion());
    }

    @Override
    public DoubleProvider getYoKpParallelToMotion() {
        return this.kpParallelToMotion;
    }

    @Override
    public DoubleProvider getYoKpOrthogonalToMotion() {
        return this.kpOrthogonalToMotion;
    }

    @Override
    public DoubleProvider getYoKi() {
        return this.ki;
    }

    @Override
    public DoubleProvider getYoIntegralLeakRatio() {
        return this.integralLeakRatio;
    }

    @Override
    public DoubleProvider getYoMaxIntegralError() {
        return this.maxIntegralError;
    }

    @Override
    public DoubleProvider getYoFeedbackPartMaxRate() {
        return this.feedbackPartMaxRate;
    }

    @Override
    public DoubleProvider getYoFeedbackPartMaxValueParallelToMotion() {
        return this.feedbackPartMaxValueParallelToMotion;
    }

    @Override
    public DoubleProvider getYoFeedbackPartMaxValueOrthogonalToMotion() {
        return this.feedbackPartMaxValueOrthogonalToMotion;
    }
}

