/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ICPControlPolygons {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final Color combinedColor = Color.red;
    private static final Color leftFootColor = new Color(250, 128, 114);
    private static final Color rightFootColor = new Color(255, 160, 122);
    private static final SideDependentList<Color> feetColors = new SideDependentList((Object)leftFootColor, (Object)rightFootColor);
    private static boolean VISUALIZE = false;
    private static final int maxNumberOfContactPointsPerFoot = 6;
    private final YoRegistry registry = new YoRegistry("ICPControlPolygons");
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footControlPolygonsInWorldFrame = new SideDependentList();
    private final FixedFrameConvexPolygon2DBasics controlPolygonInWorld;
    private final YoFrameConvexPolygon2D controlPolygonViz;
    private final SideDependentList<YoFrameConvexPolygon2D> controlFootPolygonsViz = new SideDependentList();
    private final ICPControlPlane icpControlPlane;
    private final FramePoint3D tempProjectedContactPosition = new FramePoint3D();
    private final FramePoint3D tempContactPosition = new FramePoint3D();

    public ICPControlPolygons(ICPControlPlane icpControlPlane, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.icpControlPlane = icpControlPlane;
        this.controlPolygonViz = new YoFrameConvexPolygon2D("combinedPolygon", "", worldFrame, 12, this.registry);
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoArtifactPolygon controlPolygonArtifact = new YoArtifactPolygon("Combined Control Polygon", this.controlPolygonViz, combinedColor, false);
        artifactList.add((Artifact)controlPolygonArtifact);
        this.controlPolygonInWorld = new FrameConvexPolygon2D(worldFrame);
        for (RobotSide robotSide : RobotSide.values) {
            this.footControlPolygonsInWorldFrame.put((Enum)robotSide, (Object)new FrameConvexPolygon2D(worldFrame));
            String robotSidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            if (!VISUALIZE) continue;
            YoFrameConvexPolygon2D controlFootPolygonViz = new YoFrameConvexPolygon2D(robotSidePrefix + "controlFootPolygon", "", worldFrame, 6, this.registry);
            this.controlFootPolygonsViz.put((Enum)robotSide, (Object)controlFootPolygonViz);
            YoArtifactPolygon footPolygonArtifact = new YoArtifactPolygon(robotSide.getCamelCaseNameForMiddleOfExpression() + " Control Foot Polygon", controlFootPolygonViz, (Color)feetColors.get((Enum)robotSide), false);
            artifactList.add((Artifact)footPolygonArtifact);
        }
        if (VISUALIZE && yoGraphicsListRegistry != null) {
            yoGraphicsListRegistry.registerArtifactList(artifactList);
        }
        parentRegistry.addChild(this.registry);
    }

    public void updateUsingContactStates(SideDependentList<? extends PlaneContactState> contactStates) {
        boolean inDoubleSupport = true;
        boolean neitherFootIsSupportingFoot = true;
        RobotSide supportSide = null;
        for (RobotSide robotSide : RobotSide.values) {
            PlaneContactState contactState = (PlaneContactState)contactStates.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInWorldFrame = (FixedFrameConvexPolygon2DBasics)this.footControlPolygonsInWorldFrame.get((Enum)robotSide);
            footPolygonInWorldFrame.clearAndUpdate();
            if (contactState.inContact()) {
                supportSide = robotSide;
                neitherFootIsSupportingFoot = false;
                for (int i = 0; i < contactState.getTotalNumberOfContactPoints(); ++i) {
                    ContactPointBasics contactPoint = contactState.getContactPoints().get(i);
                    if (!contactPoint.isInContact()) continue;
                    this.icpControlPlane.projectPointOntoControlPlane(worldFrame, (FramePoint3DReadOnly)contactPoint, this.tempProjectedContactPosition);
                    footPolygonInWorldFrame.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempProjectedContactPosition);
                }
                footPolygonInWorldFrame.update();
                continue;
            }
            inDoubleSupport = false;
        }
        this.updateSupportPolygon(inDoubleSupport, neitherFootIsSupportingFoot, supportSide);
        this.updateVisualize();
    }

    public void updateUsingContactStateCommand(SideDependentList<PlaneContactStateCommand> contactStateCommands) {
        boolean inDoubleSupport = true;
        boolean neitherFootIsSupportingFoot = true;
        RobotSide supportSide = null;
        for (RobotSide robotSide : RobotSide.values) {
            PlaneContactStateCommand contactStateCommand = (PlaneContactStateCommand)contactStateCommands.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInWorldFrame = (FixedFrameConvexPolygon2DBasics)this.footControlPolygonsInWorldFrame.get((Enum)robotSide);
            footPolygonInWorldFrame.clearAndUpdate();
            if (!contactStateCommand.isEmpty()) {
                supportSide = robotSide;
                neitherFootIsSupportingFoot = false;
                for (int i = 0; i < contactStateCommand.getNumberOfContactPoints(); ++i) {
                    this.tempContactPosition.setIncludingFrame((FrameTuple3DReadOnly)contactStateCommand.getContactPoint(i));
                    this.icpControlPlane.projectPointOntoControlPlane(worldFrame, (FramePoint3DReadOnly)this.tempContactPosition, this.tempProjectedContactPosition);
                    footPolygonInWorldFrame.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempProjectedContactPosition);
                }
                footPolygonInWorldFrame.update();
                continue;
            }
            inDoubleSupport = false;
        }
        this.updateSupportPolygon(inDoubleSupport, neitherFootIsSupportingFoot, supportSide);
        this.updateVisualize();
    }

    private void updateSupportPolygon(boolean inDoubleSupport, boolean neitherFootIsSupportingFoot, RobotSide supportSide) {
        if (neitherFootIsSupportingFoot) {
            throw new RuntimeException("neither foot is a supporting foot!");
        }
        if (inDoubleSupport) {
            this.controlPolygonInWorld.set((FrameVertex2DSupplier)this.footControlPolygonsInWorldFrame.get((Enum)RobotSide.LEFT), (FrameVertex2DSupplier)this.footControlPolygonsInWorldFrame.get((Enum)RobotSide.RIGHT));
        } else {
            this.controlPolygonInWorld.set((FrameVertex2DSupplier)this.footControlPolygonsInWorldFrame.get((Enum)supportSide));
        }
    }

    private void updateVisualize() {
        this.controlPolygonViz.set((FrameVertex2DSupplier)this.controlPolygonInWorld);
        if (VISUALIZE) {
            for (RobotSide robotSide : RobotSide.values) {
                YoFrameConvexPolygon2D footPolygonViz = (YoFrameConvexPolygon2D)this.controlFootPolygonsViz.get((Enum)robotSide);
                FixedFrameConvexPolygon2DBasics footPolygon = (FixedFrameConvexPolygon2DBasics)this.footControlPolygonsInWorldFrame.get((Enum)robotSide);
                if (footPolygon.isEmpty()) {
                    footPolygonViz.clear();
                    continue;
                }
                footPolygonViz.set((FrameVertex2DSupplier)footPolygon);
            }
        }
    }

    public FrameConvexPolygon2DReadOnly getFootControlPolygonInWorldFrame(RobotSide robotSide) {
        return (FrameConvexPolygon2DReadOnly)this.footControlPolygonsInWorldFrame.get((Enum)robotSide);
    }

    public FrameConvexPolygon2DReadOnly getControlPolygonInWorldFrame() {
        return this.controlPolygonInWorld;
    }

    public ICPControlPlane getIcpControlPlane() {
        return this.icpControlPlane;
    }
}

