/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ICPControlPlane {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble controlPlaneHeight;
    private final ReferenceFrame centerOfMassFrame;
    private final RecyclingArrayList<Point3D> vertexInWorldProvider = new RecyclingArrayList(Point3D::new);
    private final RecyclingArrayList<Point2DBasics> pointsInPlane = new RecyclingArrayList(Point2D::new);
    private final FramePoint3D tempFramePoint = new FramePoint3D();
    private final FramePoint3D tempProjectedFramePoint = new FramePoint3D();
    private final FramePoint3D planeOrigin = new FramePoint3D();
    private final FrameVector3D planeNormal = new FrameVector3D();
    private final FramePoint3D centerOfMassPosition = new FramePoint3D();
    private final FrameVector3D rayDirection = new FrameVector3D();
    private final double gravityZ;

    public ICPControlPlane(ReferenceFrame centerOfMassFrame, double gravityZ, YoRegistry parentRegistry) {
        this.centerOfMassFrame = centerOfMassFrame;
        this.gravityZ = gravityZ;
        this.controlPlaneHeight = new YoDouble("controlPlaneHeight", this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setOmega0(double omega0) {
        double heightOfPlane = -this.gravityZ / MathTools.square((double)omega0);
        this.controlPlaneHeight.set(heightOfPlane);
    }

    public double getControlPlaneHeight() {
        return this.controlPlaneHeight.getDoubleValue();
    }

    public void projectPointOntoControlPlane(ReferenceFrame desiredReferenceFrame, FramePoint3DReadOnly pointToProject, FramePoint3D projectionToPack) {
        ICPControlPlane.projectPointThroughReferenceFrame(this.centerOfMassFrame, pointToProject, (FramePoint3DBasics)projectionToPack, this.controlPlaneHeight.getDoubleValue());
        projectionToPack.changeFrame(desiredReferenceFrame);
    }

    public void projectPointFromControlPlaneOntoSurface(ReferenceFrame desiredReferenceFrame, FramePoint2DReadOnly pointToProject, FramePoint3DBasics projectionToPack, double surfaceHeightInWorld) {
        this.tempFramePoint.setIncludingFrame((FrameTuple2DReadOnly)pointToProject, 0.0);
        this.tempFramePoint.changeFrame(worldFrame);
        this.tempFramePoint.setZ(surfaceHeightInWorld);
        this.tempFramePoint.changeFrame(this.centerOfMassFrame);
        double surfaceHeightInCoMFrame = this.tempFramePoint.getZ();
        this.tempFramePoint.setZ(this.controlPlaneHeight.getDoubleValue());
        ICPControlPlane.projectPointThroughReferenceFrame(this.centerOfMassFrame, (FramePoint3DReadOnly)this.tempFramePoint, projectionToPack, surfaceHeightInCoMFrame);
        projectionToPack.changeFrame(desiredReferenceFrame);
    }

    public void projectPointFromControlPlaneOntoPlanarRegion(ReferenceFrame desiredReferenceFrame, FramePoint2DReadOnly pointToProject, FramePoint3D projectionToPack, PlanarRegion planarRegion) {
        planarRegion.getOrigin((Point3DBasics)this.planeOrigin);
        planarRegion.getNormal((Vector3DBasics)this.planeNormal);
        this.projectPointFromControlPlaneOntoRegion(desiredReferenceFrame, pointToProject, projectionToPack, (Point3DReadOnly)this.planeOrigin, (FrameVector3DReadOnly)this.planeNormal);
    }

    public void projectPointFromControlPlaneOntoConstraintRegion(ReferenceFrame desiredReferenceFrame, FramePoint2DReadOnly pointToProject, FramePoint3D projectionToPack, StepConstraintRegion stepConstraintRegion) {
        stepConstraintRegion.getNormal((Vector3DBasics)this.planeNormal);
        stepConstraintRegion.getRegionOriginInWorld((Point3DBasics)this.planeOrigin);
        this.projectPointFromControlPlaneOntoRegion(desiredReferenceFrame, pointToProject, projectionToPack, (Point3DReadOnly)this.planeOrigin, (FrameVector3DReadOnly)this.planeNormal);
    }

    public void projectPointFromControlPlaneOntoRegion(ReferenceFrame desiredReferenceFrame, FramePoint2DReadOnly pointToProject, FramePoint3D projectionToPack, Point3DReadOnly regionOrigin, FrameVector3DReadOnly regionNormal) {
        this.tempFramePoint.setIncludingFrame((FrameTuple2DReadOnly)pointToProject, 0.0);
        this.tempFramePoint.changeFrame(this.centerOfMassFrame);
        this.tempFramePoint.setZ(this.controlPlaneHeight.getDoubleValue());
        this.tempFramePoint.changeFrame(worldFrame);
        this.centerOfMassPosition.setToZero(this.centerOfMassFrame);
        this.centerOfMassPosition.changeFrame(worldFrame);
        this.rayDirection.set((FrameTuple3DReadOnly)this.tempFramePoint);
        this.rayDirection.sub((FrameTuple3DReadOnly)this.centerOfMassPosition);
        projectionToPack.setToZero(worldFrame);
        EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)regionOrigin, (Vector3DReadOnly)regionNormal, (Point3DReadOnly)this.centerOfMassPosition, (Vector3DReadOnly)this.rayDirection, (Point3DBasics)projectionToPack);
        projectionToPack.changeFrame(desiredReferenceFrame);
    }

    public void projectPlanarRegionConvexHullOntoControlPlane(PlanarRegion planarRegion, ConvexPolygon2DBasics convexPolygonInControlPlaneToPack) {
        this.projectVerticesOntoControlPlane((Vertex2DSupplier)planarRegion.getConvexHull(), planarRegion.getTransformToWorld(), convexPolygonInControlPlaneToPack);
    }

    public void projectPlanarRegionConvexHullInWorldOntoControlPlane(ConvexPolygon2DReadOnly convexHullInWorld, PlanarRegion heightProvider, ConvexPolygon2DBasics convexPolygonInControlPlaneToPack) {
        int i;
        this.vertexInWorldProvider.clear();
        for (i = 0; i < convexHullInWorld.getNumberOfVertices(); ++i) {
            Point3D vertexInWorld = (Point3D)this.vertexInWorldProvider.add();
            Point2DReadOnly vertex = convexHullInWorld.getVertex(i);
            vertexInWorld.set((Tuple2DReadOnly)vertex, heightProvider.getPlaneZGivenXY(vertex.getX(), vertex.getY()));
        }
        this.projectPointsInWorldOntoControlPlane((List<? extends Point3DReadOnly>)this.vertexInWorldProvider, (RecyclingArrayList<? extends Point2DBasics>)this.pointsInPlane);
        convexPolygonInControlPlaneToPack.clear();
        for (i = 0; i < this.pointsInPlane.size(); ++i) {
            convexPolygonInControlPlaneToPack.addVertex((Point2DReadOnly)this.pointsInPlane.get(i));
        }
        convexPolygonInControlPlaneToPack.update();
    }

    public void projectVerticesOntoControlPlane(Vertex2DSupplier convexHullInLocal, RigidBodyTransformReadOnly transformFromLocalToWorld, ConvexPolygon2DBasics convexPolygonInControlPlaneToPack) {
        int i;
        this.vertexInWorldProvider.clear();
        for (i = 0; i < convexHullInLocal.getNumberOfVertices(); ++i) {
            Point3D vertexInWorld = (Point3D)this.vertexInWorldProvider.add();
            vertexInWorld.set((Tuple2DReadOnly)convexHullInLocal.getVertex(i), 0.0);
            transformFromLocalToWorld.transform((Point3DBasics)vertexInWorld);
        }
        this.projectPointsInWorldOntoControlPlane((List<? extends Point3DReadOnly>)this.vertexInWorldProvider, (RecyclingArrayList<? extends Point2DBasics>)this.pointsInPlane);
        convexPolygonInControlPlaneToPack.clear();
        for (i = 0; i < this.pointsInPlane.size(); ++i) {
            convexPolygonInControlPlaneToPack.addVertex((Point2DReadOnly)this.pointsInPlane.get(i));
        }
        convexPolygonInControlPlaneToPack.update();
    }

    public void projectPointsInWorldOntoControlPlane(List<? extends Point3DReadOnly> convexHullInWorld, RecyclingArrayList<? extends Point2DBasics> pointsInControlPlane) {
        pointsInControlPlane.clear();
        for (int vertexIndex = 0; vertexIndex < convexHullInWorld.size(); ++vertexIndex) {
            this.tempFramePoint.setIncludingFrame(worldFrame, (Tuple3DReadOnly)convexHullInWorld.get(vertexIndex));
            ICPControlPlane.projectPointThroughReferenceFrame(this.centerOfMassFrame, (FramePoint3DReadOnly)this.tempFramePoint, (FramePoint3DBasics)this.tempProjectedFramePoint, this.controlPlaneHeight.getDoubleValue());
            this.tempProjectedFramePoint.changeFrame(worldFrame);
            ((Point2DBasics)pointsInControlPlane.add()).set(this.tempProjectedFramePoint.getX(), this.tempProjectedFramePoint.getY());
        }
    }

    private static void projectPointThroughReferenceFrame(ReferenceFrame frameOfProjection, FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack, double projectedHeight) {
        projectionToPack.setIncludingFrame((FrameTuple3DReadOnly)pointToProject);
        projectionToPack.changeFrame(frameOfProjection);
        double unprojectedHeight = projectionToPack.getZ();
        projectionToPack.scale(projectedHeight / unprojectedHeight);
        projectionToPack.setZ(projectedHeight);
    }
}

