/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.CenterOfMassHeightControlState;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisAndCenterOfMassHeightControlState;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class CenterOfMassHeightManager {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final StateMachine<PelvisHeightControlMode, PelvisAndCenterOfMassHeightControlState> stateMachine;
    private final YoEnum<PelvisHeightControlMode> requestedState;
    private final CenterOfMassHeightControlState centerOfMassHeightControlState;
    private final PelvisHeightControlState pelvisHeightControlState;
    private final YoBoolean enableUserPelvisControlDuringWalking = new YoBoolean("centerOfMassHeightManagerEnableUserPelvisControlDuringWalking", this.registry);
    private final YoBoolean doPrepareForLocomotion = new YoBoolean("doPrepareCenterOfMassHeightForLocomotion", this.registry);

    public CenterOfMassHeightManager(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        this.pelvisHeightControlState = new PelvisHeightControlState(controllerToolbox, this.registry);
        YoDouble yoTime = controllerToolbox.getYoTime();
        String namePrefix = this.getClass().getSimpleName();
        this.requestedState = new YoEnum(namePrefix + "RequestedControlMode", this.registry, PelvisHeightControlMode.class, true);
        this.centerOfMassHeightControlState = new CenterOfMassHeightControlState(controllerToolbox, walkingControllerParameters, this.registry);
        this.stateMachine = this.setupStateMachine(namePrefix, (DoubleProvider)yoTime);
    }

    private StateMachine<PelvisHeightControlMode, PelvisAndCenterOfMassHeightControlState> setupStateMachine(String namePrefix, DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(PelvisHeightControlMode.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)PelvisHeightControlMode.WALKING_CONTROLLER, (State)this.centerOfMassHeightControlState);
        factory.addState((Enum)PelvisHeightControlMode.USER, (State)this.pelvisHeightControlState);
        for (PelvisHeightControlMode from : PelvisHeightControlMode.values()) {
            factory.addRequestedTransition((Enum)from, this.requestedState);
        }
        return factory.build((Enum)PelvisHeightControlMode.WALKING_CONTROLLER);
    }

    public void initialize() {
        this.enableUserPelvisControlDuringWalking.set(false);
        this.stateMachine.resetToInitialState();
        this.centerOfMassHeightControlState.initialize();
        this.pelvisHeightControlState.initialize();
    }

    public void setPelvisTaskspaceWeights(Vector3DReadOnly weight) {
        this.pelvisHeightControlState.setWeights(weight);
        this.centerOfMassHeightControlState.setWeights(weight);
    }

    public void setPrepareForLocomotion(boolean value) {
        this.doPrepareForLocomotion.set(value);
    }

    public void compute(FrameVector2DReadOnly desiredICPVelocity, FrameVector2DReadOnly desiredCoMVelocity, boolean isInDoubleSupport, double omega0, boolean isRecoveringFromPush, FeetManager feetManager) {
        this.stateMachine.doActionAndTransition();
        ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).computeCoMHeightCommand(desiredICPVelocity, desiredCoMVelocity, isInDoubleSupport, omega0, isRecoveringFromPush, feetManager);
    }

    public void prepareForLocomotion() {
        if (!this.doPrepareForLocomotion.getValue()) {
            return;
        }
        if (this.enableUserPelvisControlDuringWalking.getBooleanValue()) {
            return;
        }
        if (((PelvisHeightControlMode)this.stateMachine.getCurrentStateKey()).equals((Object)PelvisHeightControlMode.USER)) {
            this.centerOfMassHeightControlState.initializeDesiredHeightToCurrent();
            this.requestState(PelvisHeightControlMode.WALKING_CONTROLLER);
        }
    }

    private void requestState(PelvisHeightControlMode state) {
        if (this.stateMachine.getCurrentStateKey() != state) {
            this.requestedState.set((Enum)state);
        }
    }

    public void initializeDesiredHeightToCurrent() {
        ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).initializeDesiredHeightToCurrent();
    }

    public void handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        if (command.isEnableUserPelvisControl()) {
            this.enableUserPelvisControlDuringWalking.set(command.isEnableUserPelvisControlDuringWalking());
            if (this.pelvisHeightControlState.handlePelvisTrajectoryCommand(command)) {
                this.requestState(PelvisHeightControlMode.USER);
                return;
            }
            LogTools.info((String)"pelvisHeightControlState failed to handle PelvisTrajectoryCommand");
            return;
        }
        this.centerOfMassHeightControlState.handlePelvisTrajectoryCommand(command);
        this.requestState(PelvisHeightControlMode.WALKING_CONTROLLER);
    }

    public void handlePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command) {
        if (command.isEnableUserPelvisControl()) {
            this.enableUserPelvisControlDuringWalking.set(command.isEnableUserPelvisControlDuringWalking());
            if (this.pelvisHeightControlState.handlePelvisHeightTrajectoryCommand(command)) {
                this.requestState(PelvisHeightControlMode.USER);
                return;
            }
            LogTools.info((String)"pelvisHeightControlState failed to handle PelvisTrajectoryCommand");
            return;
        }
        this.centerOfMassHeightControlState.handlePelvisHeightTrajectoryCommand(command);
        this.requestState(PelvisHeightControlMode.WALKING_CONTROLLER);
    }

    public void goHome(double trajectoryTime) {
        ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).goHome(trajectoryTime);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).handleStopAllTrajectoryCommand(command);
    }

    public void setSupportLeg(RobotSide supportLeg) {
        this.centerOfMassHeightControlState.setSupportLeg(supportLeg);
    }

    public void initialize(TransferToAndNextFootstepsData transferToAndNextFootstepsData, double extraToeOffHeight) {
        this.centerOfMassHeightControlState.initialize(transferToAndNextFootstepsData, extraToeOffHeight);
    }

    public void initializeToNominalDesiredHeight() {
        this.centerOfMassHeightControlState.initializeToNominalDesiredHeight();
    }

    public void initializeTransitionToFall(double transitionDuration) {
        this.centerOfMassHeightControlState.initializeTransitionToFall(transitionDuration);
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).getFeedbackControlCommand();
    }

    public FeedbackControlCommand<?> getHeightControlCommand() {
        return ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).getHeightControlCommand();
    }

    public FeedbackControlCommand<?> createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (PelvisHeightControlMode mode : PelvisHeightControlMode.values()) {
            PelvisAndCenterOfMassHeightControlState state = (PelvisAndCenterOfMassHeightControlState)this.stateMachine.getState((Enum)mode);
            if (state == null || state.getFeedbackControlCommand() == null) continue;
            ret.addCommand(state.getFeedbackControlCommand());
        }
        return ret;
    }

    public boolean getControlHeightWithMomentum() {
        return ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).getControlHeightWithMomentum();
    }

    public void setComHeightGains(PIDGainsReadOnly walkingControllerComHeightGains, DoubleProvider walkingControllerMaxComHeightVelocity, PIDGainsReadOnly userModeCoMHeightGains) {
        this.centerOfMassHeightControlState.setGains((PDGainsReadOnly)walkingControllerComHeightGains, walkingControllerMaxComHeightVelocity);
        this.pelvisHeightControlState.setGains(userModeCoMHeightGains);
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return ((PelvisAndCenterOfMassHeightControlState)this.stateMachine.getCurrentState()).pollStatusToReport();
    }
}

