/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;

public class CapturePointTools {
    private static final double EPSILON = 1.0E-15;

    public static void computeCapturePointPosition(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity, double omega0, FixedFramePoint3DBasics icpToPack) {
        icpToPack.scaleAdd(1.0 / omega0, (FrameTuple3DReadOnly)centerOfMassVelocity, (FrameTuple3DReadOnly)centerOfMassPosition);
    }

    public static void computeCapturePointPosition(FramePoint2DReadOnly centerOfMassPosition, FrameVector2DReadOnly centerOfMassVelocity, double omega0, FixedFramePoint2DBasics icpToPack) {
        icpToPack.scaleAdd(1.0 / omega0, (FrameTuple2DReadOnly)centerOfMassVelocity, (FrameTuple2DReadOnly)centerOfMassPosition);
    }

    public static void computeCapturePointVelocity(FrameVector3DReadOnly centerOfMassVelocity, FrameVector3DReadOnly centerOfMassAcceleration, double omega0, FixedFrameVector3DBasics icpVelocityToPack) {
        icpVelocityToPack.scaleAdd(1.0 / omega0, (FrameTuple3DReadOnly)centerOfMassAcceleration, (FrameTuple3DReadOnly)centerOfMassVelocity);
    }

    public static void computeCapturePointVelocity(FrameVector2DReadOnly centerOfMassVelocity, FrameVector2DReadOnly centerOfMassAcceleration, double omega0, FixedFrameVector2DBasics icpVelocityToPack) {
        icpVelocityToPack.scaleAdd(1.0 / omega0, (FrameTuple2DReadOnly)centerOfMassAcceleration, (FrameTuple2DReadOnly)centerOfMassVelocity);
    }

    public static void computeCapturePointVelocity(FramePoint3DReadOnly capturePointPosition, FramePoint3DReadOnly cmpPosition, double omega0, FixedFrameVector3DBasics icpVelocityToPack) {
        icpVelocityToPack.sub((FrameTuple3DReadOnly)capturePointPosition, (FrameTuple3DReadOnly)cmpPosition);
        icpVelocityToPack.scale(omega0);
    }

    public static void computeCapturePointVelocity(FramePoint2DReadOnly capturePointPosition, FramePoint2DReadOnly cmpPosition, double omega0, FixedFrameVector2DBasics icpVelocityToPack) {
        icpVelocityToPack.sub((FrameTuple2DReadOnly)capturePointPosition, (FrameTuple2DReadOnly)cmpPosition);
        icpVelocityToPack.scale(omega0);
    }

    public static void computeCapturePointAcceleration(double omega0, FrameVector3DReadOnly capturePointVelocity, FixedFrameVector3DBasics icpAccelerationAccelerationToPack) {
        icpAccelerationAccelerationToPack.setMatchingFrame((FrameTuple3DReadOnly)capturePointVelocity);
        icpAccelerationAccelerationToPack.scale(omega0);
    }

    public static void computeCentroidalMomentumPivot(FramePoint2DReadOnly capturePointPosition, FrameVector2DReadOnly capturePointVelocity, double omega0, FixedFramePoint2DBasics cmpPositionToPack) {
        cmpPositionToPack.scaleAdd(-1.0 / omega0, (FrameTuple2DReadOnly)capturePointVelocity, (FrameTuple2DReadOnly)capturePointPosition);
    }

    public static void computeCentroidalMomentumPivot(FramePoint3DReadOnly capturePointPosition, FrameVector3DReadOnly capturePointVelocity, double omega0, FixedFramePoint3DBasics cmpPositionToPack) {
        cmpPositionToPack.scaleAdd(-1.0 / omega0, (FrameTuple3DReadOnly)capturePointVelocity, (FrameTuple3DReadOnly)capturePointPosition);
    }

    public static void computeCentroidalMomentumPivotVelocity(FrameVector3DReadOnly capturePointVelocity, FrameVector3DReadOnly capturePointAcceleration, double omega0, FixedFrameVector3DBasics cmpVelocityToPack) {
        cmpVelocityToPack.scaleAdd(-1.0 / omega0, (FrameTuple3DReadOnly)capturePointAcceleration, (FrameTuple3DReadOnly)capturePointVelocity);
    }

    public static void computeDesiredCapturePointPosition(double omega0, double time, FramePoint3DReadOnly initialDesiredCapturePoint, FramePoint3DReadOnly initialDesiredCMP, FixedFramePoint3DBasics desiredCapturePointToPack) {
        if (initialDesiredCapturePoint.distance(initialDesiredCMP) > 1.0E-15) {
            desiredCapturePointToPack.interpolate((FrameTuple3DReadOnly)initialDesiredCMP, (FrameTuple3DReadOnly)initialDesiredCapturePoint, Math.exp(omega0 * time));
        } else {
            desiredCapturePointToPack.set((FrameTuple3DReadOnly)initialDesiredCapturePoint);
        }
    }

    public static void computeDesiredCapturePointPosition(double omega0, double time, FramePoint2DReadOnly initialDesiredCapturePoint, FramePoint2DReadOnly constantDesiredCMP, FixedFramePoint2DBasics desiredCapturePointToPack) {
        if (initialDesiredCapturePoint.distance(constantDesiredCMP) > 1.0E-15) {
            desiredCapturePointToPack.interpolate((FrameTuple2DReadOnly)constantDesiredCMP, (FrameTuple2DReadOnly)initialDesiredCapturePoint, Math.exp(omega0 * time));
        } else {
            desiredCapturePointToPack.set((FrameTuple2DReadOnly)initialDesiredCapturePoint);
        }
    }

    public static void computeDesiredCapturePointPosition(double omega0, double time, double timeAtFinalCMP, FramePoint2DReadOnly initialDesiredCapturePoint, FramePoint2DReadOnly initialDesiredCMP, FramePoint2DReadOnly finalDesiredCMP, FixedFramePoint2DBasics desiredCapturePointToPack) {
        if (initialDesiredCapturePoint.distance(initialDesiredCMP) > 1.0E-15) {
            desiredCapturePointToPack.sub((FrameTuple2DReadOnly)finalDesiredCMP, (FrameTuple2DReadOnly)initialDesiredCMP);
            desiredCapturePointToPack.scale(1.0 / (omega0 * timeAtFinalCMP));
            desiredCapturePointToPack.add((FrameTuple2DReadOnly)initialDesiredCMP);
            desiredCapturePointToPack.interpolate((FrameTuple2DReadOnly)initialDesiredCapturePoint, Math.exp(omega0 * time));
            desiredCapturePointToPack.scaleAdd(time / timeAtFinalCMP, (FrameTuple2DReadOnly)finalDesiredCMP, (FrameTuple2DReadOnly)desiredCapturePointToPack);
            desiredCapturePointToPack.scaleAdd(-time / timeAtFinalCMP, (FrameTuple2DReadOnly)initialDesiredCMP, (FrameTuple2DReadOnly)desiredCapturePointToPack);
        } else {
            desiredCapturePointToPack.set((FrameTuple2DReadOnly)initialDesiredCapturePoint);
        }
    }

    public static void computeDesiredCapturePointVelocity(double omega0, double time, FramePoint3DReadOnly initialDesiredCapturePoint, FramePoint3DReadOnly initialDesiredCMP, FixedFrameVector3DBasics desiredCapturePointVelocityToPack) {
        if (initialDesiredCapturePoint.distance(initialDesiredCMP) > 1.0E-15) {
            desiredCapturePointVelocityToPack.sub((FrameTuple3DReadOnly)initialDesiredCapturePoint, (FrameTuple3DReadOnly)initialDesiredCMP);
            desiredCapturePointVelocityToPack.scale(omega0 * Math.exp(omega0 * time));
        } else {
            desiredCapturePointVelocityToPack.setToZero();
        }
    }

    public static void computeDesiredCapturePointAcceleration(double omega0, double time, FramePoint3DReadOnly initialDesiredCapturePoint, FramePoint3DReadOnly initialDesiredCMP, FixedFrameVector3DBasics desiredCapturePointAccelerationToPack) {
        if (initialDesiredCapturePoint.distance(initialDesiredCMP) > 1.0E-15) {
            desiredCapturePointAccelerationToPack.sub((FrameTuple3DReadOnly)initialDesiredCapturePoint, (FrameTuple3DReadOnly)initialDesiredCMP);
            desiredCapturePointAccelerationToPack.scale(omega0 * omega0 * Math.exp(omega0 * time));
        } else {
            desiredCapturePointAccelerationToPack.setToZero();
        }
    }

    public static double computeDistanceToCapturePointFreezeLineIn2d(FramePoint2DReadOnly currentCapturePointPosition, FramePoint2DReadOnly desiredCapturePointPosition, FrameVector2DReadOnly desiredCapturePointVelocity) {
        currentCapturePointPosition.checkReferenceFrameMatch((ReferenceFrameHolder)desiredCapturePointPosition);
        desiredCapturePointVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)desiredCapturePointPosition);
        double desiredCapturePointVelocityMagnitude = Math.sqrt(MathTools.square((double)desiredCapturePointVelocity.getX()) + MathTools.square((double)desiredCapturePointVelocity.getY()));
        if (desiredCapturePointVelocityMagnitude == 0.0) {
            return Double.NaN;
        }
        double normalizedCapturePointVelocityX = desiredCapturePointVelocity.getX() / desiredCapturePointVelocityMagnitude;
        double normalizedCapturePointVelocityY = desiredCapturePointVelocity.getY() / desiredCapturePointVelocityMagnitude;
        double capturePointErrorX = currentCapturePointPosition.getX() - desiredCapturePointPosition.getX();
        double capturePointErrorY = currentCapturePointPosition.getY() - desiredCapturePointPosition.getY();
        return -(normalizedCapturePointVelocityX * capturePointErrorX + normalizedCapturePointVelocityY * capturePointErrorY);
    }

    public static void computeCenterOfMassVelocity(FramePoint2DReadOnly comPosition, FramePoint2DReadOnly dcmPosition, double omega0, FixedFrameVector2DBasics comVelocityToPack) {
        comVelocityToPack.sub((FrameTuple2DReadOnly)dcmPosition, (FrameTuple2DReadOnly)comPosition);
        comVelocityToPack.scale(omega0);
    }

    public static void computeCenterOfMassVelocity(FramePoint3DReadOnly comPosition, FramePoint3DReadOnly dcmPosition, double omega0, FixedFrameVector3DBasics comVelocityToPack) {
        comVelocityToPack.sub((FrameTuple3DReadOnly)dcmPosition, (FrameTuple3DReadOnly)comPosition);
        comVelocityToPack.scale(omega0);
    }

    public static void computeCenterOfMassAcceleration(FrameVector3DReadOnly comVelocity, FrameVector3DReadOnly dcmVelocity, double omega0, FixedFrameVector3DBasics comAccelerationToPack) {
        comAccelerationToPack.sub((FrameTuple3DReadOnly)dcmVelocity, (FrameTuple3DReadOnly)comVelocity);
        comAccelerationToPack.scale(omega0);
    }
}

