/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.calculators;

import us.ihmc.commonWalkingControlModules.calculators.Omega0CalculatorInterface;
import us.ihmc.commonWalkingControlModules.controlModules.CenterOfPressureResolver;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.robotics.referenceFrames.OriginAndPointFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class Omega0Calculator
implements Omega0CalculatorInterface {
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final CenterOfPressureResolver centerOfPressureResolver = new CenterOfPressureResolver();
    private final OriginAndPointFrame copToCoPFrame = new OriginAndPointFrame("copToCoP", this.worldFrame);
    private final ReferenceFrame centerOfMassFrame;
    private final double totalMass;
    private final SideDependentList<FramePoint3D> cops = new SideDependentList();
    private final FramePoint2D pseudoCoP2d = new FramePoint2D();
    private final FramePoint3D pseudoCoP = new FramePoint3D();
    private final SpatialForce totalGroundReactionWrench = new SpatialForce();
    private double omega0;
    private final FramePoint3D tempCoP3d = new FramePoint3D();

    public Omega0Calculator(ReferenceFrame centerOfMassFrame, double totalMass, double initialOmega0) {
        this.centerOfMassFrame = centerOfMassFrame;
        this.totalMass = totalMass;
        this.omega0 = initialOmega0;
        for (RobotSide robotSide : RobotSide.values) {
            this.cops.put((Enum)robotSide, (Object)new FramePoint3D());
        }
    }

    @Override
    public double computeOmega0(SideDependentList<FramePoint2D> cop2ds, SpatialForceReadOnly newTotalGroundReactionWrench) {
        this.totalGroundReactionWrench.setIncludingFrame((SpatialVectorReadOnly)newTotalGroundReactionWrench);
        this.totalGroundReactionWrench.changeFrame(this.centerOfMassFrame);
        double fz = this.totalGroundReactionWrench.getLinearPartZ();
        int numberOfValidCoPs = 0;
        for (RobotSide robotSide : RobotSide.values) {
            numberOfValidCoPs += ((FramePoint2D)cop2ds.get((Enum)robotSide)).containsNaN() ? 0 : 1;
        }
        double deltaZ = Double.NaN;
        if (numberOfValidCoPs == 1) {
            for (RobotSide robotSide : RobotSide.values) {
                FramePoint2D cop2d = (FramePoint2D)cop2ds.get((Enum)robotSide);
                if (cop2d.containsNaN()) continue;
                this.tempCoP3d.setIncludingFrame((FrameTuple2DReadOnly)cop2d, 0.0);
                this.tempCoP3d.changeFrame(this.centerOfMassFrame);
                deltaZ = -this.tempCoP3d.getZ();
                break;
            }
        } else {
            for (RobotSide robotSide : RobotSide.values) {
                FramePoint2D cop2d = (FramePoint2D)cop2ds.get((Enum)robotSide);
                ((FramePoint3D)this.cops.get((Enum)robotSide)).setIncludingFrame(cop2d.getReferenceFrame(), cop2d.getX(), cop2d.getY(), 0.0);
                ((FramePoint3D)this.cops.get((Enum)robotSide)).changeFrame(this.copToCoPFrame.getParent());
            }
            this.copToCoPFrame.setOriginAndPositionToPointAt((FramePoint3D)this.cops.get((Enum)RobotSide.LEFT), (FramePoint3D)this.cops.get((Enum)RobotSide.RIGHT));
            this.copToCoPFrame.update();
            this.pseudoCoP2d.setToZero((ReferenceFrame)this.copToCoPFrame);
            this.centerOfPressureResolver.resolveCenterOfPressureAndNormalTorque((FramePoint2DBasics)this.pseudoCoP2d, (SpatialForceReadOnly)this.totalGroundReactionWrench, (ReferenceFrame)this.copToCoPFrame);
            this.pseudoCoP.setIncludingFrame((FrameTuple2DReadOnly)this.pseudoCoP2d, 0.0);
            this.pseudoCoP.changeFrame(this.centerOfMassFrame);
            deltaZ = -this.pseudoCoP.getZ();
        }
        double newOmega0 = Math.sqrt(fz / (this.totalMass * deltaZ));
        if (!Double.isNaN(newOmega0)) {
            this.omega0 = newOmega0;
        }
        return this.omega0;
    }
}

