/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ModifiableContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.lists.FrameTuple2dArrayList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoPlaneContactState
implements PlaneContactState,
ModifiableContactState {
    private static final double THRESHOLD = 1.0E-7;
    protected final YoRegistry registry;
    private final RigidBodyBasics rigidBody;
    private final ReferenceFrame planeFrame;
    private final YoBoolean inContact;
    private final YoDouble coefficientOfFriction;
    private final FrameVector3D contactNormalFrameVector;
    private final int totalNumberOfContactPoints;
    private final List<YoContactPoint> contactPoints;
    private final HashMap<YoContactPoint, YoDouble> rhoWeights = new HashMap();
    private final HashMap<YoContactPoint, YoDouble> maxContactPointNormalForces = new HashMap();
    private final FrameConvexPolygon2D contactPointsPolygon = new FrameConvexPolygon2D();
    private final YoFramePoint2D contactPointCentroid;
    private final YoBoolean hasContactStateChanged;

    public YoPlaneContactState(String namePrefix, RigidBodyBasics rigidBody, ReferenceFrame planeFrame, List<FramePoint2D> contactFramePoints, double coefficientOfFriction, YoRegistry parentRegistry) {
        this(namePrefix, rigidBody, planeFrame, contactFramePoints, coefficientOfFriction, Double.NaN, parentRegistry);
    }

    public YoPlaneContactState(String namePrefix, RigidBodyBasics rigidBody, ReferenceFrame planeFrame, List<FramePoint2D> contactFramePoints, double coefficientOfFriction, double defaultRhoWeight, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.inContact = new YoBoolean(namePrefix + "InContact", this.registry);
        this.coefficientOfFriction = new YoDouble(namePrefix + "CoefficientOfFriction", this.registry);
        this.coefficientOfFriction.set(coefficientOfFriction);
        this.rigidBody = rigidBody;
        this.planeFrame = planeFrame;
        parentRegistry.addChild(this.registry);
        this.contactNormalFrameVector = new FrameVector3D(planeFrame, 0.0, 0.0, 1.0);
        this.contactPoints = new ArrayList<YoContactPoint>(contactFramePoints.size());
        for (int i = 0; i < contactFramePoints.size(); ++i) {
            YoContactPoint contactPoint = new YoContactPoint(namePrefix, i, contactFramePoints.get(i), (PlaneContactState)this, this.registry);
            contactPoint.setInContact(true);
            this.contactPoints.add(contactPoint);
            YoDouble maxContactPointNormalForce = new YoDouble(namePrefix + "MaxContactPointNormalForce" + i, this.registry);
            maxContactPointNormalForce.set(Double.POSITIVE_INFINITY);
            this.maxContactPointNormalForces.put(contactPoint, maxContactPointNormalForce);
            YoDouble rhoWeight = new YoDouble(namePrefix + "RhoWeight" + i, this.registry);
            rhoWeight.set(defaultRhoWeight);
            this.rhoWeights.put(contactPoint, rhoWeight);
        }
        this.inContact.set(true);
        this.totalNumberOfContactPoints = this.contactPoints.size();
        this.contactPointCentroid = new YoFramePoint2D(namePrefix + "ContactPointCentroid", planeFrame, this.registry);
        this.contactPointCentroid.setToNaN();
        this.hasContactStateChanged = new YoBoolean(namePrefix + "HasChanged", this.registry);
    }

    public void attachContactChangeListener(YoVariableChangedListener variableChangedListener) {
        this.inContact.addListener(variableChangedListener);
    }

    @Override
    public void getPlaneContactStateCommand(PlaneContactStateCommand planeContactStateCommandToPack) {
        planeContactStateCommandToPack.clearContactPoints();
        planeContactStateCommandToPack.setContactingRigidBody(this.rigidBody);
        planeContactStateCommandToPack.setCoefficientOfFriction(this.coefficientOfFriction.getDoubleValue());
        planeContactStateCommandToPack.setContactNormal((FrameVector3DReadOnly)this.contactNormalFrameVector);
        planeContactStateCommandToPack.setHasContactStateChanged(this.hasContactStateChanged.getBooleanValue());
        if (!this.inContact()) {
            return;
        }
        int contactedPointIndex = 0;
        for (int i = 0; i < this.getTotalNumberOfContactPoints(); ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            planeContactStateCommandToPack.addPointInContact((FramePoint3DReadOnly)contactPoint);
            YoDouble maxForce = this.maxContactPointNormalForces.get(contactPoint);
            planeContactStateCommandToPack.setMaxContactPointNormalForce(contactedPointIndex, maxForce.getDoubleValue());
            YoDouble rhoWeight = this.rhoWeights.get(contactPoint);
            planeContactStateCommandToPack.setRhoWeight(contactedPointIndex, rhoWeight.getDoubleValue());
            ++contactedPointIndex;
        }
    }

    @Override
    public void updateFromPlaneContactStateCommand(PlaneContactStateCommand planeContactStateCommand) {
        int i;
        if (planeContactStateCommand.getContactingRigidBody() != this.rigidBody) {
            throw new RuntimeException("The rigid body in the command does not match this rigid body: command.rigidBody = " + planeContactStateCommand.getContactingRigidBody() + ", contactState.rigidBody = " + this.rigidBody);
        }
        this.coefficientOfFriction.set(planeContactStateCommand.getCoefficientOfFriction());
        this.contactNormalFrameVector.setIncludingFrame((FrameTuple3DReadOnly)planeContactStateCommand.getContactNormal());
        this.hasContactStateChanged.set(planeContactStateCommand.getHasContactStateChanged());
        if (planeContactStateCommand.isEmpty()) {
            this.clear();
        } else {
            this.inContact.set(true);
        }
        for (i = 0; i < planeContactStateCommand.getNumberOfContactPoints(); ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            contactPoint.setMatchingFrame((FrameTuple3DReadOnly)planeContactStateCommand.getContactPoint(i));
            contactPoint.setInContact(true);
            double maxContactPointNormalForce = planeContactStateCommand.getMaxContactPointNormalForce(i);
            this.maxContactPointNormalForces.get(contactPoint).set(maxContactPointNormalForce);
            double rhoWeight = planeContactStateCommand.getRhoWeight(i);
            this.rhoWeights.get(contactPoint).set(rhoWeight);
        }
        for (i = planeContactStateCommand.getNumberOfContactPoints(); i < this.getTotalNumberOfContactPoints(); ++i) {
            this.contactPoints.get(i).setInContact(false);
        }
    }

    public void setCoefficientOfFriction(double coefficientOfFriction) {
        this.coefficientOfFriction.set(coefficientOfFriction);
    }

    public void setContactNormalVector(FrameVector3DReadOnly normalContactVector) {
        if (normalContactVector == null) {
            this.contactNormalFrameVector.setIncludingFrame(this.planeFrame, 0.0, 0.0, 1.0);
        } else {
            this.contactNormalFrameVector.setIncludingFrame((FrameTuple3DReadOnly)normalContactVector);
        }
    }

    public void setMaxContactPointNormalForce(YoContactPoint contactPoint, double maxNormalForce) {
        this.maxContactPointNormalForces.get(contactPoint).set(maxNormalForce);
    }

    public void setRhoWeight(YoContactPoint contactPoint, double rhoWeight) {
        this.rhoWeights.get(contactPoint).set(rhoWeight);
    }

    public void setRhoWeights(double rhoWeight) {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            this.rhoWeights.get(this.contactPoints.get(i)).set(rhoWeight);
        }
    }

    public void clearRhoWeights() {
        this.setRhoWeights(Double.NaN);
    }

    public List<YoContactPoint> getContactPoints() {
        return this.contactPoints;
    }

    public void setContactPoints(List<Point2D> contactPointLocations) {
        int i;
        int contactPointLocationsSize = contactPointLocations.size();
        if (contactPointLocationsSize != this.totalNumberOfContactPoints) {
            throw new RuntimeException("contactPointLocationsSize != totalNumberOfContactPoints");
        }
        for (i = 0; i < contactPointLocationsSize; ++i) {
            Point2D contactPointLocation = contactPointLocations.get(i);
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            yoContactPoint.set((Tuple2DReadOnly)contactPointLocation);
        }
        this.contactPointsPolygon.clear(this.planeFrame);
        for (i = 0; i < contactPointLocations.size(); ++i) {
            this.contactPointsPolygon.addVertex((Point2DReadOnly)contactPointLocations.get(i));
        }
        this.contactPointsPolygon.update();
        this.contactPointCentroid.set((FrameTuple2DReadOnly)this.contactPointsPolygon.getCentroid());
    }

    public void setContactFramePoints(List<FramePoint2D> contactPointLocations) {
        int i;
        int contactPointLocationsSize = contactPointLocations.size();
        if (contactPointLocationsSize != this.totalNumberOfContactPoints) {
            throw new RuntimeException("contactPointLocationsSize != totalNumberOfContactPoints");
        }
        for (i = 0; i < contactPointLocationsSize; ++i) {
            FramePoint2D contactPointLocation = contactPointLocations.get(i);
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            yoContactPoint.set((FrameTuple2DReadOnly)contactPointLocation);
        }
        this.contactPointsPolygon.clear(contactPointLocations.get(0).getReferenceFrame());
        for (i = 0; i < contactPointLocations.size(); ++i) {
            this.contactPointsPolygon.addVertex((FramePoint2DReadOnly)contactPointLocations.get(i));
        }
        this.contactPointsPolygon.update();
        this.contactPointCentroid.set((FrameTuple2DReadOnly)this.contactPointsPolygon.getCentroid());
    }

    public void getContactPointCentroid(FramePoint2D centroidToPack) {
        centroidToPack.setIncludingFrame((FrameTuple2DReadOnly)this.contactPointCentroid);
    }

    @Override
    public List<FramePoint3D> getContactFramePointsInContactCopy() {
        ArrayList<FramePoint3D> ret = new ArrayList<FramePoint3D>(this.totalNumberOfContactPoints);
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            ret.add(new FramePoint3D((FrameTuple3DReadOnly)contactPoint));
        }
        return ret;
    }

    @Override
    public void getContactFramePointsInContact(List<FramePoint3D> contactPointListToPack) {
        int i;
        int counter = 0;
        for (i = 0; i < this.totalNumberOfContactPoints; ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            if (counter >= contactPointListToPack.size()) {
                contactPointListToPack.add(new FramePoint3D());
            }
            contactPointListToPack.get(counter).setIncludingFrame((FrameTuple3DReadOnly)contactPoint);
            ++counter;
        }
        for (i = contactPointListToPack.size() - 1; i >= counter; --i) {
            contactPointListToPack.remove(i);
        }
    }

    public void getContactPointsInContact(List<YoContactPoint> contactPointListToPack) {
        contactPointListToPack.clear();
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            contactPointListToPack.add(contactPoint);
        }
    }

    public void getContactFramePoint2dsInContact(List<FramePoint2D> contactPointListToPack) {
        int i;
        int counter = 0;
        for (i = 0; i < this.totalNumberOfContactPoints; ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            if (counter >= contactPointListToPack.size()) {
                if (contactPointListToPack instanceof RecyclingArrayList) {
                    ((RecyclingArrayList)contactPointListToPack).add();
                } else {
                    contactPointListToPack.add(new FramePoint2D());
                }
            }
            contactPointListToPack.get(counter).setIncludingFrame((FrameTuple3DReadOnly)contactPoint);
            ++counter;
        }
        for (i = contactPointListToPack.size() - 1; i >= counter; --i) {
            contactPointListToPack.remove(i);
        }
    }

    public void getAllContactPoints(FrameTuple2dArrayList<FramePoint2D> contactPointListToPack) {
        contactPointListToPack.clear();
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            FramePoint2D contactPointLocation = (FramePoint2D)contactPointListToPack.getAndGrowIfNeeded(i);
            contactPointLocation.setIncludingFrame((FrameTuple3DReadOnly)this.contactPoints.get(i));
        }
    }

    @Override
    public List<FramePoint2D> getContactFramePoints2dInContactCopy() {
        ArrayList<FramePoint2D> ret = new ArrayList<FramePoint2D>(this.totalNumberOfContactPoints);
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.isInContact()) continue;
            ret.add(new FramePoint2D((FrameTuple3DReadOnly)contactPoint));
        }
        return ret;
    }

    public YoContactPoint findContactPoint(FramePoint2D contactPointPosition2d) {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint contactPoint = this.contactPoints.get(i);
            if (!contactPoint.epsilonEquals(contactPointPosition2d, 1.0E-7)) continue;
            return contactPoint;
        }
        return null;
    }

    public void setContactPointsInContact(boolean[] inContact) {
        if (inContact.length != this.totalNumberOfContactPoints) {
            throw new RuntimeException("Arrays should be of same length!");
        }
        this.inContact.set(false);
        for (int i = 0; i < inContact.length; ++i) {
            this.contactPoints.get(i).setInContact(inContact[i]);
            if (!inContact[i]) continue;
            this.inContact.set(true);
        }
    }

    public void setContactPointInContact(int contactPointIndex, boolean inContact) {
        this.contactPoints.get(contactPointIndex).setInContact(inContact);
        if (inContact) {
            this.inContact.set(true);
        } else {
            this.updateInContact();
        }
    }

    public void updateInContact() {
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            if (!this.contactPoints.get(i).isInContact()) continue;
            this.inContact.set(true);
            return;
        }
        this.inContact.set(false);
    }

    public void computeSupportPolygon() {
        this.contactPointsPolygon.clear(this.planeFrame);
        for (int i = 0; i < this.getTotalNumberOfContactPoints(); ++i) {
            this.contactPointsPolygon.addVertexMatchingFrame((FramePoint3DReadOnly)this.contactPoints.get(i));
        }
        this.contactPointsPolygon.update();
    }

    public double getFootholdArea() {
        return this.contactPointsPolygon.getArea();
    }

    public ConvexPolygon2DReadOnly getSupportPolygonInPlaneFrame() {
        return this.contactPointsPolygon;
    }

    @Override
    public int getTotalNumberOfContactPoints() {
        return this.totalNumberOfContactPoints;
    }

    @Override
    public ReferenceFrame getFrameAfterParentJoint() {
        return this.rigidBody.getParentJoint().getFrameAfterJoint();
    }

    @Override
    public ReferenceFrame getPlaneFrame() {
        return this.planeFrame;
    }

    @Override
    public boolean inContact() {
        return this.inContact.getBooleanValue();
    }

    @Override
    public double getCoefficientOfFriction() {
        return this.coefficientOfFriction.getDoubleValue();
    }

    @Override
    public int getNumberOfContactPointsInContact() {
        int numberOfContactPointsInContact = 0;
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            if (!this.contactPoints.get(i).isInContact()) continue;
            ++numberOfContactPointsInContact;
        }
        return numberOfContactPointsInContact;
    }

    @Override
    public FrameVector3D getContactNormalFrameVectorCopy() {
        return new FrameVector3D((FrameTuple3DReadOnly)this.contactNormalFrameVector);
    }

    @Override
    public void getContactNormalFrameVector(FrameVector3D frameVectorToPack) {
        frameVectorToPack.setIncludingFrame((FrameTuple3DReadOnly)this.contactNormalFrameVector);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            this.contactPoints.get(i).setInContact(false);
        }
        this.inContact.set(false);
    }

    public void setFullyConstrained() {
        for (int i = 0; i < this.totalNumberOfContactPoints; ++i) {
            this.contactPoints.get(i).setInContact(true);
        }
        this.inContact.set(true);
    }

    @Override
    public void notifyContactStateHasChanged() {
        this.hasContactStateChanged.set(true);
    }

    @Override
    public boolean pollContactHasChangedNotification() {
        boolean ret = this.hasContactStateChanged.getBooleanValue();
        this.hasContactStateChanged.set(false);
        return ret;
    }

    @Override
    public boolean peekContactHasChangedNotification() {
        return this.hasContactStateChanged.getValue();
    }

    @Override
    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public String toString() {
        return "Body: " + this.rigidBody.getName() + ", in contact: " + this.inContact() + ", nunber of CPs: " + this.getTotalNumberOfContactPoints();
    }
}

