/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class QuadrupedSupportPolygons {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final Color defaultFrontLeftColor = new Color(0.85f, 0.35f, 0.65f, 1.0f);
    private static final Color defaultHindRightColor = new Color(0.85f, 0.35f, 0.65f, 1.0f);
    private static final Color defaultFrontRightColor = new Color(0.15f, 0.8f, 0.15f, 1.0f);
    private static final Color defaultHindLeftColor = new Color(0.15f, 0.8f, 0.15f, 1.0f);
    private static final QuadrantDependentList<Color> defaultFeetColors = new QuadrantDependentList((Object)defaultFrontLeftColor, (Object)defaultFrontRightColor, (Object)defaultHindLeftColor, (Object)defaultHindRightColor);
    private static boolean VISUALIZE = true;
    private final YoRegistry registry = new YoRegistry("QuadrupedSupportPolygons");
    private final ReferenceFrame centerOfFeetZUpFrame;
    private final QuadrantDependentList<MovingReferenceFrame> soleZUpFrames;
    private final QuadrantDependentList<FrameConvexPolygon2D> footPolygonsInWorldFrame = new QuadrantDependentList();
    private final QuadrantDependentList<FrameConvexPolygon2D> footPolygonsInSoleFrame = new QuadrantDependentList();
    private final QuadrantDependentList<FrameConvexPolygon2D> footPolygonsInSoleZUpFrame = new QuadrantDependentList();
    private final QuadrantDependentList<FrameConvexPolygon2D> footPolygonsInMidFeetZUp = new QuadrantDependentList();
    private final FrameConvexPolygon2D supportPolygonInMidFeetZUp = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D supportPolygonInWorld = new FrameConvexPolygon2D();
    private final YoFrameConvexPolygon2D supportPolygonViz;
    private final YoFramePoint2D supportPolygonCentroid;
    private final QuadrantDependentList<YoFrameConvexPolygon2D> footPolygonsViz = new QuadrantDependentList();

    public QuadrupedSupportPolygons(ReferenceFrame centerOfFeetZUpFrame, QuadrantDependentList<YoPlaneContactState> contactStates, QuadrantDependentList<MovingReferenceFrame> soleZUpFrames, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.centerOfFeetZUpFrame = centerOfFeetZUpFrame;
        this.soleZUpFrames = soleZUpFrames;
        this.supportPolygonViz = new YoFrameConvexPolygon2D("combinedPolygon", "", worldFrame, 4 * ((YoPlaneContactState)contactStates.get((Enum)RobotQuadrant.FRONT_LEFT)).getTotalNumberOfContactPoints(), this.registry);
        this.supportPolygonCentroid = new YoFramePoint2D("supportPolygonCentroid", worldFrame, this.registry);
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoArtifactPolygon supportPolygonArtifact = new YoArtifactPolygon("Combined Polygon", this.supportPolygonViz, Color.pink, false);
        artifactList.add((Artifact)supportPolygonArtifact);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            this.footPolygonsInWorldFrame.put((Enum)robotQuadrant, (Object)new FrameConvexPolygon2D());
            this.footPolygonsInSoleFrame.put((Enum)robotQuadrant, (Object)new FrameConvexPolygon2D());
            this.footPolygonsInSoleZUpFrame.put((Enum)robotQuadrant, (Object)new FrameConvexPolygon2D());
            this.footPolygonsInMidFeetZUp.put((Enum)robotQuadrant, (Object)new FrameConvexPolygon2D());
            String robotSidePrefix = robotQuadrant.getCamelCaseNameForStartOfExpression();
            YoFrameConvexPolygon2D footPolygonViz = new YoFrameConvexPolygon2D(robotSidePrefix + "FootPolygon", "", worldFrame, ((YoPlaneContactState)contactStates.get((Enum)robotQuadrant)).getTotalNumberOfContactPoints(), this.registry);
            this.footPolygonsViz.put((Enum)robotQuadrant, (Object)footPolygonViz);
            YoArtifactPolygon footPolygonArtifact = new YoArtifactPolygon(robotQuadrant.getCamelCaseNameForMiddleOfExpression() + " Foot Polygon", footPolygonViz, (Color)defaultFeetColors.get((Enum)robotQuadrant), false);
            artifactList.add((Artifact)footPolygonArtifact);
        }
        if (yoGraphicsListRegistry != null) {
            yoGraphicsListRegistry.registerArtifactList(artifactList);
        }
        parentRegistry.addChild(this.registry);
    }

    public void updateUsingContactStates(QuadrantDependentList<? extends PlaneContactState> contactStates) {
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            PlaneContactState contactState = (PlaneContactState)contactStates.get((Enum)robotQuadrant);
            FrameConvexPolygon2D footPolygonInWorldFrame = (FrameConvexPolygon2D)this.footPolygonsInWorldFrame.get((Enum)robotQuadrant);
            FrameConvexPolygon2D footPolygonInSoleFrame = (FrameConvexPolygon2D)this.footPolygonsInSoleFrame.get((Enum)robotQuadrant);
            FrameConvexPolygon2D footPolygonInSoleZUpFrame = (FrameConvexPolygon2D)this.footPolygonsInSoleZUpFrame.get((Enum)robotQuadrant);
            FrameConvexPolygon2D footPolygonInMidFeetZUp = (FrameConvexPolygon2D)this.footPolygonsInMidFeetZUp.get((Enum)robotQuadrant);
            footPolygonInWorldFrame.clearAndUpdate(worldFrame);
            footPolygonInSoleFrame.clearAndUpdate(contactState.getPlaneFrame());
            footPolygonInSoleZUpFrame.clearAndUpdate((ReferenceFrame)this.soleZUpFrames.get((Enum)robotQuadrant));
            footPolygonInMidFeetZUp.clearAndUpdate(this.centerOfFeetZUpFrame);
            if (!contactState.inContact()) continue;
            for (int i = 0; i < contactState.getTotalNumberOfContactPoints(); ++i) {
                ContactPointBasics contactPoint = contactState.getContactPoints().get(i);
                if (!contactPoint.isInContact()) continue;
                footPolygonInWorldFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                footPolygonInSoleFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                footPolygonInSoleZUpFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                footPolygonInMidFeetZUp.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
            }
            footPolygonInWorldFrame.update();
            footPolygonInSoleFrame.update();
            footPolygonInSoleZUpFrame.update();
            footPolygonInMidFeetZUp.update();
        }
        this.updateSupportPolygon(contactStates);
        this.supportPolygonCentroid.set((FrameTuple2DReadOnly)this.supportPolygonInWorld.getCentroid());
        if (VISUALIZE) {
            this.visualize();
        }
    }

    private void updateSupportPolygon(QuadrantDependentList<? extends PlaneContactState> contactStates) {
        this.supportPolygonInMidFeetZUp.clearAndUpdate();
        this.supportPolygonInMidFeetZUp.setReferenceFrame(this.centerOfFeetZUpFrame);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            if (!((PlaneContactState)contactStates.get((Enum)robotQuadrant)).inContact()) continue;
            this.supportPolygonInMidFeetZUp.addVertices((FrameVertex2DSupplier)this.footPolygonsInMidFeetZUp.get((Enum)robotQuadrant));
        }
        this.supportPolygonInMidFeetZUp.update();
        this.supportPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.supportPolygonInMidFeetZUp);
        this.supportPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
    }

    private void visualize() {
        this.supportPolygonViz.set((FrameVertex2DSupplier)this.supportPolygonInWorld);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            YoFrameConvexPolygon2D footPolygonViz = (YoFrameConvexPolygon2D)this.footPolygonsViz.get((Enum)robotQuadrant);
            FrameConvexPolygon2D footPolygon = (FrameConvexPolygon2D)this.footPolygonsInWorldFrame.get((Enum)robotQuadrant);
            if (footPolygon.isEmpty()) {
                footPolygonViz.clear();
                continue;
            }
            footPolygonViz.set((FrameVertex2DSupplier)footPolygon);
        }
    }

    public ReferenceFrame getMidFeetZUpFrame() {
        return this.centerOfFeetZUpFrame;
    }

    public QuadrantDependentList<MovingReferenceFrame> getSoleZUpFrames() {
        return this.soleZUpFrames;
    }

    public FrameConvexPolygon2D getSupportPolygonInMidFeetZUp() {
        return this.supportPolygonInMidFeetZUp;
    }

    public FrameConvexPolygon2D getSupportPolygonInWorld() {
        return this.supportPolygonInWorld;
    }

    public FrameConvexPolygon2D getFootPolygonInSoleFrame(RobotQuadrant robotQuadrant) {
        return (FrameConvexPolygon2D)this.footPolygonsInSoleFrame.get((Enum)robotQuadrant);
    }

    public FrameConvexPolygon2D getFootPolygonInSoleZUpFrame(RobotQuadrant robotQuadrant) {
        return (FrameConvexPolygon2D)this.footPolygonsInSoleZUpFrame.get((Enum)robotQuadrant);
    }

    public FrameConvexPolygon2D getFootPolygonInWorldFrame(RobotQuadrant robotQuadrant) {
        return (FrameConvexPolygon2D)this.footPolygonsInWorldFrame.get((Enum)robotQuadrant);
    }

    public QuadrantDependentList<FrameConvexPolygon2D> getFootPolygonsInWorldFrame() {
        return this.footPolygonsInWorldFrame;
    }

    public String toString() {
        return "supportPolygonInMidFeetZUp = " + this.supportPolygonInMidFeetZUp;
    }
}

