/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;

public class ListOfPointsContactablePlaneBody
implements ContactablePlaneBody {
    private final RigidBodyBasics rigidBody;
    private final ReferenceFrame soleFrame;
    private final List<Point2D> contactPoints = new ArrayList<Point2D>();
    private final List<FramePoint2D> frameContactPoints = new ArrayList<FramePoint2D>();
    private final int totalNumberOfContactPoints;

    public ListOfPointsContactablePlaneBody(RigidBodyBasics rigidBody, ReferenceFrame soleFrame, List<Point2D> contactPointsInSoleFrame) {
        this.rigidBody = rigidBody;
        this.soleFrame = soleFrame;
        for (Point2D contactPoint : contactPointsInSoleFrame) {
            Point2D point = new Point2D((Tuple2DReadOnly)contactPoint);
            this.contactPoints.add(point);
            this.frameContactPoints.add(new FramePoint2D(soleFrame, (Tuple2DReadOnly)point));
        }
        this.totalNumberOfContactPoints = this.contactPoints.size();
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public String getName() {
        return this.rigidBody.getName();
    }

    public List<FramePoint3D> getContactPointsCopy() {
        ArrayList<FramePoint3D> ret = new ArrayList<FramePoint3D>(this.contactPoints.size());
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            Tuple2DBasics point = (Tuple2DBasics)this.contactPoints.get(i);
            ret.add(new FramePoint3D(this.soleFrame, point.getX(), point.getY(), 0.0));
        }
        return ret;
    }

    public MovingReferenceFrame getFrameAfterParentJoint() {
        return this.rigidBody.getParentJoint().getFrameAfterJoint();
    }

    public FrameConvexPolygon2D getContactPolygonCopy() {
        return new FrameConvexPolygon2D(this.soleFrame, Vertex2DSupplier.asVertex2DSupplier(this.contactPoints));
    }

    public ReferenceFrame getSoleFrame() {
        return this.soleFrame;
    }

    public List<FramePoint2D> getContactPoints2d() {
        return this.frameContactPoints;
    }

    public int getTotalNumberOfContactPoints() {
        return this.totalNumberOfContactPoints;
    }

    public void setSoleFrameTransformFromParentJoint(RigidBodyTransform transform) {
        throw new UnsupportedOperationException();
    }
}

