/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactPointVisualizer
implements Updatable {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<YoFramePoint3D> contactPointsWorld = new ArrayList<YoFramePoint3D>();
    private final List<YoGraphicPosition> yoGraphicPositions = new ArrayList<YoGraphicPosition>();
    private final List<YoGraphicVector> yoGraphicVectors = new ArrayList<YoGraphicVector>();
    private final List<YoFrameVector3D> normalVectors = new ArrayList<YoFrameVector3D>();
    private final double normalVectorScale = 0.1;
    private final int maxNumberOfYoGraphicPositions;
    private final List<? extends PlaneContactState> contactStates;
    private final FrameVector3D tempFrameVector = new FrameVector3D(worldFrame);

    public ContactPointVisualizer(List<? extends PlaneContactState> contactStates, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        int i;
        this.contactStates = contactStates;
        int totalNumberOfContactPoints = 0;
        for (i = 0; i < contactStates.size(); ++i) {
            totalNumberOfContactPoints += contactStates.get(i).getTotalNumberOfContactPoints();
        }
        this.maxNumberOfYoGraphicPositions = totalNumberOfContactPoints;
        for (i = 0; i < this.maxNumberOfYoGraphicPositions; ++i) {
            YoFramePoint3D contactPointWorld = new YoFramePoint3D("contactPoint" + i, worldFrame, this.registry);
            this.contactPointsWorld.add(contactPointWorld);
            YoGraphicPosition yoGraphicPosition = new YoGraphicPosition("contactViz" + i, contactPointWorld, 0.01, YoAppearance.Crimson());
            this.yoGraphicPositions.add(yoGraphicPosition);
            yoGraphicsListRegistry.registerYoGraphic("contactPoints", (YoGraphic)yoGraphicPosition);
            YoFrameVector3D normalVector = new YoFrameVector3D("contactNormal" + i, worldFrame, this.registry);
            this.normalVectors.add(normalVector);
            YoGraphicVector yoGraphicVector = new YoGraphicVector("contactNormalViz" + i, contactPointWorld, normalVector, YoAppearance.Crimson());
            this.yoGraphicVectors.add(yoGraphicVector);
            yoGraphicsListRegistry.registerYoGraphic("contactPoints", (YoGraphic)yoGraphicVector);
        }
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void update(double time) {
        int i = 0;
        for (int j = 0; j < this.contactStates.size(); ++j) {
            PlaneContactState contactState = this.contactStates.get(j);
            contactState.getContactNormalFrameVector(this.tempFrameVector);
            this.tempFrameVector.changeFrame(worldFrame);
            this.tempFrameVector.scale(0.1);
            List<? extends ContactPointBasics> contactPoints = contactState.getContactPoints();
            for (int k = 0; k < contactPoints.size(); ++k) {
                this.updateContactPointYoGraphics(i++, contactPoints.get(k));
            }
        }
    }

    private void updateContactPointYoGraphics(int i, ContactPointBasics contactPoint) {
        if (contactPoint.isInContact()) {
            this.contactPointsWorld.get(i).setMatchingFrame((FrameTuple3DReadOnly)contactPoint);
            this.normalVectors.get(i).set((FrameTuple3DReadOnly)this.tempFrameVector);
            this.yoGraphicPositions.get(i).showGraphicObject();
            this.yoGraphicVectors.get(i).showGraphicObject();
        } else {
            this.contactPointsWorld.get(i).setToNaN();
            this.normalVectors.get(i).set(Double.NaN, Double.NaN, Double.NaN);
            this.yoGraphicPositions.get(i).hideGraphicObject();
            this.yoGraphicVectors.get(i).hideGraphicObject();
        }
        this.yoGraphicPositions.get(i).update();
        this.yoGraphicVectors.get(i).update();
    }
}

