/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.barrierScheduler.context;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextRootJointData;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.tasks.InPlaceCopyable;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class HumanoidRobotContextJointData
implements InPlaceCopyable<HumanoidRobotContextJointData> {
    private final HumanoidRobotContextRootJointData rootJointData = new HumanoidRobotContextRootJointData();
    private final TDoubleArrayList jointQ = new TDoubleArrayList(50);
    private final TDoubleArrayList jointQd = new TDoubleArrayList(50);
    private final TDoubleArrayList jointQdd = new TDoubleArrayList(50);
    private final TDoubleArrayList jointTau = new TDoubleArrayList(50);

    public HumanoidRobotContextJointData() {
    }

    public HumanoidRobotContextJointData(int degreesOfFreedom) {
        for (int i = 0; i < degreesOfFreedom; ++i) {
            this.addJoint(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public void clear() {
        this.jointQ.resetQuick();
        this.jointQd.resetQuick();
        this.jointQdd.resetQuick();
        this.jointTau.resetQuick();
    }

    public void addJoint(double q, double qd, double qdd, double tau) {
        this.jointQ.add(q);
        this.jointQd.add(qd);
        this.jointQdd.add(qdd);
        this.jointTau.add(tau);
    }

    public void setJointQForIndex(int index, double value) {
        this.jointQ.set(index, value);
    }

    public void setJointQdForIndex(int index, double value) {
        this.jointQd.set(index, value);
    }

    public void setJointQddForIndex(int index, double value) {
        this.jointQdd.set(index, value);
    }

    public void setJointTauForIndex(int index, double value) {
        this.jointTau.set(index, value);
    }

    public void setRootJointData(HumanoidRobotContextRootJointData other) {
        this.rootJointData.copyFrom(other);
    }

    public void setRootJointAngularData(QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity, Vector3DReadOnly angularAcceleration) {
        this.rootJointData.setRootJointOrientation(orientation);
        this.rootJointData.setRootJointAngularVelocity(angularVelocity);
        this.rootJointData.setRootJointAngularAcceleration(angularAcceleration);
    }

    public void setRootJointLinearData(Point3DReadOnly location, Vector3DReadOnly linearVelocity, Vector3DReadOnly linearAcceleration) {
        this.rootJointData.setRootJointLocation((Tuple3DReadOnly)location);
        this.rootJointData.setRootJointLinearVelocity((Tuple3DReadOnly)linearVelocity);
        this.rootJointData.setRootJointLinearAcceleration((Tuple3DReadOnly)linearAcceleration);
    }

    public void setRootJointData(Pose3DReadOnly pose, TwistReadOnly velocity, SpatialAccelerationReadOnly acceleration) {
        this.rootJointData.setRootJointOrientation(pose.getOrientation());
        this.rootJointData.setRootJointAngularVelocity((Vector3DReadOnly)velocity.getAngularPart());
        this.rootJointData.setRootJointAngularAcceleration((Vector3DReadOnly)acceleration.getAngularPart());
        this.rootJointData.setRootJointLocation((Tuple3DReadOnly)pose.getPosition());
        this.rootJointData.setRootJointLinearVelocity((Tuple3DReadOnly)velocity.getLinearPart());
        this.rootJointData.setRootJointLinearAcceleration((Tuple3DReadOnly)acceleration.getLinearPart());
    }

    public HumanoidRobotContextRootJointData getRootJointData() {
        return this.rootJointData;
    }

    public double getJointQForIndex(int index) {
        return this.jointQ.get(index);
    }

    public double getJointQdForIndex(int index) {
        return this.jointQd.get(index);
    }

    public double getJointQddForIndex(int index) {
        return this.jointQdd.get(index);
    }

    public double getJointTauForIndex(int index) {
        return this.jointTau.get(index);
    }

    public void set(HumanoidRobotContextJointData other) {
        this.copyFrom(other);
    }

    public void copyFrom(HumanoidRobotContextJointData src) {
        HumanoidRobotContextJointData.copy((TDoubleList)src.jointQ, this.jointQ);
        HumanoidRobotContextJointData.copy((TDoubleList)src.jointQd, this.jointQd);
        HumanoidRobotContextJointData.copy((TDoubleList)src.jointQdd, this.jointQdd);
        HumanoidRobotContextJointData.copy((TDoubleList)src.jointTau, this.jointTau);
        this.rootJointData.copyFrom(src.rootJointData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HumanoidRobotContextJointData) {
            HumanoidRobotContextJointData other = (HumanoidRobotContextJointData)obj;
            if (!this.jointQ.equals((Object)other.jointQ)) {
                return false;
            }
            if (!this.jointQd.equals((Object)other.jointQd)) {
                return false;
            }
            if (!this.jointQdd.equals((Object)other.jointQdd)) {
                return false;
            }
            if (!this.jointTau.equals((Object)other.jointTau)) {
                return false;
            }
            return this.rootJointData.equals(other.rootJointData);
        }
        return false;
    }

    private static void copy(TDoubleList src, TDoubleArrayList dest) {
        dest.resetQuick();
        for (int i = 0; i < src.size(); ++i) {
            dest.add(src.get(i));
        }
    }
}

