/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticEquilibrium;

import java.util.Collection;
import java.util.List;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.CenterOfMassStaticStabilityRegionCalculator;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.ContactStateExamples;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.MutableWholeBodyContactState;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.WholeBodyContactStateInterface;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.conversion.YoGraphicConversionTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;

public class CenterOfMassStabilityRegionCalculatorVisualizer {
    private static final boolean showSupportRegion = true;

    public CenterOfMassStabilityRegionCalculatorVisualizer(WholeBodyContactStateInterface input) {
        this.runWithSCS2(input);
    }

    private void runWithSCS2(WholeBodyContactStateInterface input) {
        SimulationConstructionSet2 scs2 = new SimulationConstructionSet2(PhysicsEngineFactory.newDoNothingPhysicsEngineFactory());
        scs2.start(true, true, false);
        YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
        CenterOfMassStaticStabilityRegionCalculator calculator = new CenterOfMassStaticStabilityRegionCalculator(1.0, scs2.getRootRegistry(), graphicsListRegistry);
        calculator.updateContactState(input);
        List graphicDefinitions = YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)graphicsListRegistry);
        scs2.addYoGraphics((Collection)graphicDefinitions);
        LogTools.info((String)"----- Support Region -----");
        while (!calculator.hasSolvedWholeRegion()) {
            calculator.update();
            scs2.simulateNow(1L);
        }
        ConvexPolygon2DReadOnly supportRegion0 = calculator.getSupportRegion();
        for (int i = 0; i < supportRegion0.getNumberOfVertices(); ++i) {
            System.out.println("\t" + supportRegion0.getVertex(i));
        }
        VisualDefinitionFactory supportRegionGraphics = new VisualDefinitionFactory();
        for (int i = 0; i < input.getNumberOfContactPoints(); ++i) {
            FramePoint3D contactPoint = new FramePoint3D(input.getContactFrame(i));
            FrameVector3D surfaceNormal = new FrameVector3D(input.getContactFrame(i), (Tuple3DReadOnly)Axis3D.Z);
            contactPoint.changeFrame(ReferenceFrame.getWorldFrame());
            surfaceNormal.changeFrame(ReferenceFrame.getWorldFrame());
            supportRegionGraphics.identity();
            supportRegionGraphics.appendTranslation((Tuple3DReadOnly)contactPoint);
            supportRegionGraphics.addSphere(0.03, new ColorDefinition());
            Quaternion surfaceOrientation = new Quaternion();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)surfaceNormal, (Orientation3DBasics)surfaceOrientation);
            supportRegionGraphics.appendRotation((Orientation3DReadOnly)surfaceOrientation);
            supportRegionGraphics.appendTranslation(0.0, 0.0, -0.01);
            ColorDefinition beige = new ColorDefinition();
            beige.setRed(255);
            beige.setGreen(255);
            beige.setBlue(180);
            supportRegionGraphics.addCylinder(0.02, 0.15, beige);
        }
        double renderedHeight = 0.0;
        ConvexPolygon2DReadOnly supportRegion = calculator.getSupportRegion();
        supportRegionGraphics.identity();
        supportRegionGraphics.appendTranslation(0.0, 0.0, renderedHeight);
        ColorDefinition glass = new ColorDefinition();
        glass.setRed(120);
        glass.setGreen(180);
        glass.setBlue(240);
        glass.setAlpha(0.5);
        supportRegionGraphics.addExtrudedPolygon(supportRegion, 0.01, glass);
        supportRegionGraphics.identity();
        scs2.addStaticVisuals((Collection)supportRegionGraphics.getVisualDefinitions());
        scs2.cropBuffer();
        scs2.startSimulationThread();
        ThreadTools.sleepForever();
    }

    public static void main(String[] args) {
        MutableWholeBodyContactState input = ContactStateExamples.createBipedFeetWithTwoHandholds();
        new CenterOfMassStabilityRegionCalculatorVisualizer((WholeBodyContactStateInterface)input);
    }
}

