/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.captureRegion.MultiStepPushRecoveryCalculator;
import us.ihmc.commonWalkingControlModules.captureRegion.MultiStepPushRecoveryCalculatorVisualizer;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PushRecoveryCoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PushRecoveryState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMContinuityCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMContinuousContinuityCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanner;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.pushRecoveryController.DefaultPushRecoveryControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.pushRecoveryController.PushRecoveryControllerParameters;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.gui.tools.SimulationOverheadPlotterFactory;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.tools.thread.ExecutorServiceTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class PushRecoveryCoMTrajectoryPlannerVisualizer {
    private static final double gravity = 9.81;
    private static final double nominalHeight = 1.09;
    private static final double finalTransferDuration = 1.0;
    private static final double stepWidth = 0.15;
    private static final double defaultMinSwingTime = 0.4;
    private static final double defaultMaxSwingTime = 0.8;
    private static final double defaultTransferTime = 0.05;
    private static final double simDt = 0.005;
    private static final int BUFFER_SIZE = 160000;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final SimulationConstructionSet scs;
    private final YoDouble yoTime;
    private final YoDouble timeInPhase;
    private final PushRecoveryState state;
    private final PushRecoveryCoPTrajectoryGenerator copPlanner;
    private final CoMTrajectoryPlanner comPlanner;
    private final ConvexPolygon2DBasics defaultSupportPolygon = new ConvexPolygon2D();
    private final FrameConvexPolygon2DBasics leftSupport;
    private final FrameConvexPolygon2DBasics rightSupport;
    private final YoFrameConvexPolygon2D nextFootPolygon;
    private final YoFrameConvexPolygon2D nextNextFootPolygon;
    private final YoFrameConvexPolygon2D nextNextNextFootPolygon;
    private final List<YoFrameConvexPolygon2D> nextFootPolygons = new ArrayList<YoFrameConvexPolygon2D>();
    private final YoBoolean shouldReplan;
    private final YoBoolean replan;
    private final YoFramePoint3D initialCoMPosition;
    private final YoFrameVector3D initialCoMVelocity;
    private final YoFramePoint3D desiredCoMPosition;
    private final YoFrameVector3D desiredCoMVelocity;
    private final YoFrameVector3D desiredCoMAcceleration;
    private final YoFramePoint3D desiredDCMPosition;
    private final YoFrameVector3D desiredDCMVelocity;
    private final YoFramePoint3D desiredVRPPosition;
    private final YoFrameVector3D desiredGroundReactionForce;
    private final YoFramePoint3D desiredECMPPosition;
    private final YoDouble minSwingTime;
    private final YoDouble maxSwingTime;
    private final YoDouble transferTime;
    private final BagOfBalls dcmTrajectory;
    private final BagOfBalls comTrajectory;
    private final BagOfBalls vrpTrajectory;
    private final MultiStepPushRecoveryCalculator recoveryStepCalculator;
    private final MultiStepPushRecoveryCalculatorVisualizer recoveryStepCalculatorVisualizer;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)2, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private final YoDouble omega;
    private final FramePoint2D icp = new FramePoint2D();
    private final PoseReferenceFrame newPoseFrame = new PoseReferenceFrame("newPose", worldFrame);

    public PushRecoveryCoMTrajectoryPlannerVisualizer() {
        YoRegistry registry = new YoRegistry("testJacobian");
        YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
        this.initialCoMPosition = new YoFramePoint3D("initialCoMPosition", worldFrame, registry);
        this.initialCoMVelocity = new YoFrameVector3D("initialCoMVelocity", worldFrame, registry);
        this.desiredCoMPosition = new YoFramePoint3D("desiredCoMPosition", worldFrame, registry);
        this.desiredCoMVelocity = new YoFrameVector3D("desiredCoMVelocity", worldFrame, registry);
        this.desiredCoMAcceleration = new YoFrameVector3D("desiredCoMAcceleration", worldFrame, registry);
        this.desiredDCMPosition = new YoFramePoint3D("desiredDCMPosition", worldFrame, registry);
        this.desiredDCMVelocity = new YoFrameVector3D("desiredDCMVelocity", worldFrame, registry);
        this.desiredVRPPosition = new YoFramePoint3D("desiredVRPPosition", worldFrame, registry);
        this.desiredGroundReactionForce = new YoFrameVector3D("desiredGroundReactionForce", worldFrame, registry);
        this.desiredECMPPosition = new YoFramePoint3D("desiredECMPPosition", worldFrame, registry);
        this.omega = new YoDouble("omega", registry);
        this.omega.set(Math.sqrt(9.0));
        this.minSwingTime = new YoDouble("minSwingTime", registry);
        this.maxSwingTime = new YoDouble("maxSwingTime", registry);
        this.transferTime = new YoDouble("transferTime", registry);
        this.dcmTrajectory = new BagOfBalls(100, 0.01, "dcmTrajectory", YoAppearance.Yellow(), YoGraphicPosition.GraphicType.SOLID_BALL, registry, graphicsListRegistry);
        this.comTrajectory = new BagOfBalls(100, 0.01, "comTrajectory", YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL, registry, graphicsListRegistry);
        this.vrpTrajectory = new BagOfBalls(100, 0.01, "vrpTrajectory", YoAppearance.Green(), YoGraphicPosition.GraphicType.SOLID_BALL, registry, graphicsListRegistry);
        this.yoTime = new YoDouble("timeToCheck", registry);
        this.timeInPhase = new YoDouble("timeInPhase", registry);
        this.defaultSupportPolygon.addVertex(0.1, 0.05);
        this.defaultSupportPolygon.addVertex(0.1, -0.05);
        this.defaultSupportPolygon.addVertex(-0.1, -0.05);
        this.defaultSupportPolygon.addVertex(-0.1, 0.05);
        this.defaultSupportPolygon.update();
        this.state = new PushRecoveryState(registry);
        this.minSwingTime.set(0.4);
        this.maxSwingTime.set(0.8);
        this.transferTime.set(0.05);
        this.copPlanner = new PushRecoveryCoPTrajectoryGenerator((ConvexPolygon2DReadOnly)this.defaultSupportPolygon, registry);
        this.copPlanner.registerState((YoSaveableModuleState)this.state);
        this.comPlanner = new CoMTrajectoryPlanner(9.81, 1.09, registry);
        this.comPlanner.setComContinuityCalculator((CoMContinuityCalculator)new CoMContinuousContinuityCalculator(9.81, this.omega, registry));
        this.comPlanner.setMaintainInitialCoMVelocityContinuity(true);
        FramePose3D leftStancePose = new FramePose3D();
        FramePose3D rightStancePose = new FramePose3D();
        leftStancePose.getPosition().setY(0.15);
        rightStancePose.getPosition().setY(-0.15);
        PoseReferenceFrame leftStepFrame = new PoseReferenceFrame("LeftStepFrame", worldFrame);
        PoseReferenceFrame rightStepFrame = new PoseReferenceFrame("RightStepFrame", worldFrame);
        leftStepFrame.setPoseAndUpdate((FramePose3DReadOnly)leftStancePose);
        rightStepFrame.setPoseAndUpdate((FramePose3DReadOnly)rightStancePose);
        this.leftSupport = new FrameConvexPolygon2D((ReferenceFrame)leftStepFrame);
        this.rightSupport = new FrameConvexPolygon2D((ReferenceFrame)rightStepFrame);
        this.leftSupport.set((Vertex2DSupplier)this.defaultSupportPolygon);
        this.rightSupport.set((Vertex2DSupplier)this.defaultSupportPolygon);
        this.state.initializeStance(RobotSide.LEFT, (FrameConvexPolygon2DReadOnly)this.leftSupport, (ReferenceFrame)leftStepFrame);
        this.state.initializeStance(RobotSide.RIGHT, (FrameConvexPolygon2DReadOnly)this.rightSupport, (ReferenceFrame)rightStepFrame);
        YoGraphicPosition initialDcmViz = new YoGraphicPosition("initialDCM", this.initialCoMPosition, 0.02, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoGraphicPosition dcmViz = new YoGraphicPosition("desiredDCM", this.desiredDCMPosition, 0.02, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoGraphicPosition comViz = new YoGraphicPosition("desiredCoM", this.desiredCoMPosition, 0.02, YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL);
        YoGraphicPosition vrpViz = new YoGraphicPosition("desiredVRP", this.desiredVRPPosition, 0.02, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
        YoGraphicVector forceViz = new YoGraphicVector("desiredGRF", this.desiredECMPPosition, this.desiredGroundReactionForce, 0.05, YoAppearance.Red());
        YoFrameConvexPolygon2D leftFootPolygon = new YoFrameConvexPolygon2D("leftFootPolygon", worldFrame, 4, registry);
        YoFrameConvexPolygon2D rightFootPolygon = new YoFrameConvexPolygon2D("rightFootPolygon", worldFrame, 4, registry);
        this.nextFootPolygon = new YoFrameConvexPolygon2D("nextFootPolygon", worldFrame, 4, registry);
        this.nextNextFootPolygon = new YoFrameConvexPolygon2D("nextNextFootPolygon", worldFrame, 4, registry);
        this.nextNextNextFootPolygon = new YoFrameConvexPolygon2D("nextNextNextFootPolygon", worldFrame, 4, registry);
        this.nextFootPolygons.add(this.nextFootPolygon);
        this.nextFootPolygons.add(this.nextNextFootPolygon);
        this.nextFootPolygons.add(this.nextNextNextFootPolygon);
        YoArtifactPolygon leftFootPolygonArtifact = new YoArtifactPolygon("leftFootArtifact", leftFootPolygon, Color.green, false);
        YoArtifactPolygon rightFootPolygonArtifact = new YoArtifactPolygon("rightFootArtifact", rightFootPolygon, Color.green, false);
        YoArtifactPolygon nextFootPolygonArtifact = new YoArtifactPolygon("nextFootArtifact", this.nextFootPolygon, Color.blue, false);
        YoArtifactPolygon nextNextFootPolygonArtifact = new YoArtifactPolygon("nextNextFootArtifact", this.nextNextFootPolygon, Color.blue, false);
        YoArtifactPolygon nextNextNextFootPolygonArtifact = new YoArtifactPolygon("nextNextNextFootArtifact", this.nextNextNextFootPolygon, Color.blue, false);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)leftFootPolygonArtifact);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)rightFootPolygonArtifact);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)nextFootPolygonArtifact);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)nextNextFootPolygonArtifact);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)nextNextNextFootPolygonArtifact);
        graphicsListRegistry.registerYoGraphic("dcmPlanner", (YoGraphic)forceViz);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)initialDcmViz.createArtifact());
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)dcmViz.createArtifact());
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)comViz.createArtifact());
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)vrpViz.createArtifact());
        leftFootPolygon.setMatchingFrame((FrameVertex2DSupplier)this.state.getFootPolygonInSole(RobotSide.LEFT), false);
        rightFootPolygon.setMatchingFrame((FrameVertex2DSupplier)this.state.getFootPolygonInSole(RobotSide.RIGHT), false);
        double footWidth = 0.1;
        double kinematicsStepRange = 1.0;
        this.recoveryStepCalculator = new MultiStepPushRecoveryCalculator(() -> kinematicsStepRange, () -> footWidth, (PushRecoveryControllerParameters)new DefaultPushRecoveryControllerParameters(), new SideDependentList((Object)leftStepFrame, (Object)rightStepFrame), (ConvexPolygon2DReadOnly)this.defaultSupportPolygon);
        this.recoveryStepCalculatorVisualizer = new MultiStepPushRecoveryCalculatorVisualizer("", 3, registry, graphicsListRegistry);
        this.shouldReplan = new YoBoolean("shouldReplan", registry);
        this.replan = new YoBoolean("replan", registry);
        SimulationConstructionSetParameters scsParameters = new SimulationConstructionSetParameters(true, 160000);
        Robot robot = new Robot("Dummy");
        this.scs = new SimulationConstructionSet(robot, scsParameters);
        this.scs.setDT(0.005, 1);
        this.scs.addYoRegistry(registry);
        this.scs.addYoGraphicsListRegistry(graphicsListRegistry);
        this.scs.setPlaybackRealTimeRate(0.75);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        this.scs.addStaticLinkGraphics(linkGraphics);
        this.scs.setCameraFix(0.0, 0.0, 0.5);
        this.scs.setCameraPosition(-0.5, 0.0, 1.0);
        this.addButton("replan", 1.0);
        SimulationOverheadPlotterFactory simulationOverheadPlotterFactory = this.scs.createSimulationOverheadPlotterFactory();
        simulationOverheadPlotterFactory.addYoGraphicsListRegistries(graphicsListRegistry);
        simulationOverheadPlotterFactory.createOverheadPlotter();
        this.initialCoMPosition.setToZero();
        this.initialCoMPosition.setZ(1.09);
        this.initialCoMPosition.setX(0.25);
        this.initialCoMPosition.setY(-0.05);
        this.initialCoMVelocity.setToZero();
        this.replan.set(true);
        this.executorService.scheduleAtFixedRate(() -> {
            if (this.replan.getBooleanValue()) {
                this.replan.set(false, false);
                this.shouldReplan.set(true);
                this.updateState();
                this.simulate();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        this.scs.startOnAThread();
    }

    private void addButton(String yoVariableName, final double newValue) {
        YoRegistry registry = this.scs.getRootRegistry();
        final YoVariable var = registry.findVariable(yoVariableName);
        JButton button = new JButton(yoVariableName);
        this.scs.addButton((AbstractButton)button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                var.setValueFromDouble(newValue);
            }
        });
    }

    private void updateState() {
        int i;
        CapturePointTools.computeCapturePointPosition((FramePoint2DReadOnly)new FramePoint2D((FrameTuple3DReadOnly)this.initialCoMPosition), (FrameVector2DReadOnly)new FrameVector2D((FrameTuple3DReadOnly)this.initialCoMVelocity), (double)(1.0 / this.omega.getDoubleValue()), (FixedFramePoint2DBasics)this.icp);
        LogTools.info((String)"Computing recovery steps");
        this.recoveryStepCalculator.computeRecoverySteps(RobotSide.LEFT, this.transferTime.getDoubleValue(), this.minSwingTime.getDoubleValue(), this.maxSwingTime.getDoubleValue(), (FramePoint2DReadOnly)this.icp, this.omega.getDoubleValue(), (FrameConvexPolygon2DReadOnly)this.rightSupport);
        this.recoveryStepCalculatorVisualizer.visualize(this.recoveryStepCalculator);
        LogTools.info((String)"Updating CoP state");
        this.state.clear();
        this.state.setIcpAtStartOfState((FramePoint2DReadOnly)this.icp);
        this.state.setFinalTransferDuration(1.0);
        this.state.setFinalTransferDuration(1.0);
        for (i = 0; i < this.recoveryStepCalculator.getNumberOfRecoverySteps(); ++i) {
            this.state.addFootstep(this.recoveryStepCalculator.getRecoveryStep(i));
            this.state.addFootstepTiming(this.recoveryStepCalculator.getRecoveryStepTiming(i));
        }
        for (i = 0; i < this.state.getNumberOfFootsteps(); ++i) {
            this.newPoseFrame.setPoseAndUpdate(this.state.getFootstep(i).getFootstepPose());
            FrameConvexPolygon2D newPolygon = new FrameConvexPolygon2D((ReferenceFrame)this.newPoseFrame);
            newPolygon.set((Vertex2DSupplier)this.defaultSupportPolygon);
            newPolygon.changeFrameAndProjectToXYPlane(worldFrame);
            this.nextFootPolygons.get(i).set((FrameVertex2DSupplier)newPolygon);
        }
        while (i < this.nextFootPolygons.size()) {
            this.nextFootPolygons.get(i).setToNaN();
            ++i;
        }
    }

    private void simulate() {
        this.timeInPhase.set(0.0);
        this.shouldReplan.set(false);
        LogTools.info((String)"Solving for CoP plan");
        this.copPlanner.compute(this.state);
        LogTools.info((String)"Solving for CoM plan");
        this.comPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.initialCoMPosition, (FrameVector3DReadOnly)this.initialCoMVelocity);
        this.comPlanner.solveForTrajectory(this.copPlanner.getContactStateProviders());
        LogTools.info((String)"Visualizing CoM plan");
        while (this.timeInPhase.getDoubleValue() < ((SettableContactStateProvider)this.copPlanner.getContactStateProviders().get(this.copPlanner.getContactStateProviders().size() - 1)).getTimeInterval().getEndTime()) {
            this.comPlanner.compute(this.timeInPhase.getDoubleValue());
            this.desiredCoMPosition.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredCoMPosition());
            this.desiredCoMVelocity.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredCoMVelocity());
            this.desiredCoMAcceleration.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredCoMAcceleration());
            this.desiredDCMPosition.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredDCMPosition());
            this.desiredDCMVelocity.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredDCMVelocity());
            this.desiredVRPPosition.set((FrameTuple3DReadOnly)this.comPlanner.getDesiredVRPPosition());
            this.desiredGroundReactionForce.set((FrameTuple3DReadOnly)this.desiredCoMAcceleration);
            this.desiredGroundReactionForce.addZ(9.81);
            this.desiredECMPPosition.set((FrameTuple3DReadOnly)this.desiredVRPPosition);
            this.desiredECMPPosition.subZ(9.81 / (this.omega.getDoubleValue() * this.omega.getDoubleValue()));
            this.dcmTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredDCMPosition);
            this.comTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredCoMPosition);
            this.vrpTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredVRPPosition);
            this.yoTime.add(0.005);
            this.timeInPhase.add(0.005);
            this.scs.tickAndUpdate();
        }
        LogTools.info((String)"Finished!");
    }

    public static void main(String[] args) {
        PushRecoveryCoMTrajectoryPlannerVisualizer visualizer = new PushRecoveryCoMTrajectoryPlannerVisualizer();
    }
}

