/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanner;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerInterface;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.gui.tools.SimulationOverheadPlotterFactory;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CoMTrajectoryPlannerVisualizer {
    private static final double gravity = 9.81;
    private static final double nominalHeight = 1.09;
    private static final double initialTransferDuration = 1.0;
    private static final double finalTransferDuration = 1.0;
    private static final double settlingTime = 1.0;
    private static final double stepDuration = 0.4;
    private static final double flightDuration = 0.1;
    private static final double stepLength = 0.5;
    private static final int numberOfSteps = 5;
    private static final double initialVerticalOffsetBound = 0.0;
    private static final double finalVerticalOffsetBound = 0.0;
    private static final double verticalOffset = 0.0;
    private static final boolean includeFlight = true;
    private static final double simDt = 0.001;
    private double simDuration;
    private static final int BUFFER_SIZE = 160000;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final SimulationConstructionSet scs;
    private final YoDouble yoTime;
    private final YoDouble timeInPhase;
    private final CoMTrajectoryPlannerInterface planner;
    private List<ContactStateProvider> contactStates;
    private final YoFramePoint3D desiredCoMPosition;
    private final YoFrameVector3D desiredCoMVelocity;
    private final YoFrameVector3D desiredCoMAcceleration;
    private final YoFramePoint3D desiredDCMPosition;
    private final YoFrameVector3D desiredDCMVelocity;
    private final YoFramePoint3D desiredVRPPosition;
    private final YoFrameVector3D desiredGroundReactionForce;
    private final YoFramePoint3D desiredECMPPosition;
    private final BagOfBalls dcmTrajectory;
    private final BagOfBalls comTrajectory;
    private final BagOfBalls vrpTrajectory;
    private final YoDouble omega;

    public CoMTrajectoryPlannerVisualizer() {
        YoRegistry registry = new YoRegistry("testJacobian");
        YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
        this.desiredCoMPosition = new YoFramePoint3D("desiredCoMPosition", worldFrame, registry);
        this.desiredCoMVelocity = new YoFrameVector3D("desiredCoMVelocity", worldFrame, registry);
        this.desiredCoMAcceleration = new YoFrameVector3D("desiredCoMAcceleration", worldFrame, registry);
        this.desiredDCMPosition = new YoFramePoint3D("desiredDCMPosition", worldFrame, registry);
        this.desiredDCMVelocity = new YoFrameVector3D("desiredDCMVelocity", worldFrame, registry);
        this.desiredVRPPosition = new YoFramePoint3D("desiredVRPPosition", worldFrame, registry);
        this.desiredGroundReactionForce = new YoFrameVector3D("desiredGroundReactionForce", worldFrame, registry);
        this.desiredECMPPosition = new YoFramePoint3D("desiredECMPPosition", worldFrame, registry);
        this.omega = new YoDouble("omega", registry);
        this.omega.set(Math.sqrt(9.0));
        this.dcmTrajectory = new BagOfBalls(50, 0.02, "dcmTrajectory", YoAppearance.Yellow(), registry, graphicsListRegistry);
        this.comTrajectory = new BagOfBalls(50, 0.02, "comTrajectory", YoAppearance.Black(), registry, graphicsListRegistry);
        this.vrpTrajectory = new BagOfBalls(50, 0.02, "vrpTrajectory", YoAppearance.Green(), registry, graphicsListRegistry);
        this.yoTime = new YoDouble("timeToCheck", registry);
        this.timeInPhase = new YoDouble("timeInPhase", registry);
        this.contactStates = this.createContacts();
        this.planner = new CoMTrajectoryPlanner(9.81, 1.09, registry);
        ((CoMTrajectoryPlanner)this.planner).setCornerPointViewer(new CornerPointViewer(registry, graphicsListRegistry));
        YoGraphicPosition dcmViz = new YoGraphicPosition("desiredDCM", this.desiredDCMPosition, 0.02, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoGraphicPosition comViz = new YoGraphicPosition("desiredCoM", this.desiredCoMPosition, 0.02, YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL);
        YoGraphicPosition vrpViz = new YoGraphicPosition("desiredVRP", this.desiredVRPPosition, 0.02, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
        YoGraphicVector forceViz = new YoGraphicVector("desiredGRF", this.desiredECMPPosition, this.desiredGroundReactionForce, 0.05, YoAppearance.Red());
        graphicsListRegistry.registerYoGraphic("dcmPlanner", (YoGraphic)forceViz);
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)dcmViz.createArtifact());
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)comViz.createArtifact());
        graphicsListRegistry.registerArtifact("dcmPlanner", (Artifact)vrpViz.createArtifact());
        SimulationConstructionSetParameters scsParameters = new SimulationConstructionSetParameters(true, 160000);
        Robot robot = new Robot("Dummy");
        this.scs = new SimulationConstructionSet(robot, scsParameters);
        this.scs.setDT(0.001, 1);
        this.scs.addYoRegistry(registry);
        this.scs.addYoGraphicsListRegistry(graphicsListRegistry);
        this.scs.setPlaybackRealTimeRate(0.75);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        this.scs.addStaticLinkGraphics(linkGraphics);
        this.scs.setCameraFix(0.0, 0.0, 0.5);
        this.scs.setCameraPosition(-0.5, 0.0, 1.0);
        SimulationOverheadPlotterFactory simulationOverheadPlotterFactory = this.scs.createSimulationOverheadPlotterFactory();
        simulationOverheadPlotterFactory.addYoGraphicsListRegistries(graphicsListRegistry);
        simulationOverheadPlotterFactory.createOverheadPlotter();
        this.scs.startOnAThread();
        this.simulate();
        ThreadTools.sleepForever();
    }

    private List<ContactStateProvider> createContacts() {
        ArrayList<ContactStateProvider> contacts = new ArrayList<ContactStateProvider>();
        double contactPosition = 0.0;
        SettableContactStateProvider initialContactStateProvider = new SettableContactStateProvider();
        initialContactStateProvider.getTimeInterval().setInterval(0.0, 0.5);
        initialContactStateProvider.setStartECMPPosition((FramePoint3DReadOnly)new FramePoint3D(worldFrame, contactPosition, 0.0, 0.0));
        initialContactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)new FramePoint3D(worldFrame, contactPosition, 0.0, 0.0));
        initialContactStateProvider.setLinearECMPVelocity();
        initialContactStateProvider.setContactState(ContactState.IN_CONTACT);
        double currentTime = 1.0;
        for (int i = 0; i < 5; ++i) {
            SettableContactStateProvider contactStateProvider = new SettableContactStateProvider();
            contactStateProvider.setStartECMPPosition((FramePoint3DReadOnly)new FramePoint3D(worldFrame, contactPosition, 0.0, -0.0));
            contactStateProvider.setEndECMPPosition(contactStateProvider.getECMPStartPosition());
            initialContactStateProvider.setLinearECMPVelocity();
            contactStateProvider.getTimeInterval().setInterval(currentTime, currentTime + 0.4);
            contactStateProvider.setContactState(ContactState.IN_CONTACT);
            contacts.add((ContactStateProvider)contactStateProvider);
            SettableContactStateProvider flightStateProvider = new SettableContactStateProvider();
            flightStateProvider.getTimeInterval().setInterval(currentTime += 0.4, currentTime + 0.1);
            flightStateProvider.setContactState(ContactState.FLIGHT);
            contacts.add((ContactStateProvider)flightStateProvider);
            currentTime += 0.1;
            contactPosition += 0.5;
        }
        SettableContactStateProvider finalStateProvider = new SettableContactStateProvider();
        finalStateProvider.setStartECMPPosition((FramePoint3DReadOnly)new FramePoint3D(worldFrame, contactPosition, 0.0, -0.0));
        finalStateProvider.setEndECMPPosition((FramePoint3DReadOnly)new FramePoint3D(worldFrame, contactPosition, 0.0, -0.0));
        finalStateProvider.getTimeInterval().setInterval(currentTime, currentTime + 1.0);
        finalStateProvider.setLinearECMPVelocity();
        finalStateProvider.setContactState(ContactState.IN_CONTACT);
        contacts.add((ContactStateProvider)finalStateProvider);
        this.simDuration = currentTime + 1.0;
        return contacts;
    }

    private void simulate() {
        this.desiredCoMPosition.setToZero();
        this.desiredCoMPosition.setZ(1.09);
        this.desiredCoMVelocity.setToZero();
        this.planner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.desiredCoMPosition, (FrameVector3DReadOnly)this.desiredCoMVelocity);
        this.planner.solveForTrajectory(this.contactStates);
        while (this.simDuration > this.yoTime.getDoubleValue()) {
            if (!MathTools.epsilonEquals((double)this.contactStates.get(0).getTimeInterval().getStartTime(), (double)0.0, (double)1.0E-5)) {
                throw new RuntimeException("This is a problem");
            }
            this.planner.compute(this.timeInPhase.getDoubleValue());
            this.desiredCoMPosition.set((FrameTuple3DReadOnly)this.planner.getDesiredCoMPosition());
            this.desiredCoMVelocity.set((FrameTuple3DReadOnly)this.planner.getDesiredCoMVelocity());
            this.desiredCoMAcceleration.set((FrameTuple3DReadOnly)this.planner.getDesiredCoMAcceleration());
            this.desiredDCMPosition.set((FrameTuple3DReadOnly)this.planner.getDesiredDCMPosition());
            this.desiredDCMVelocity.set((FrameTuple3DReadOnly)this.planner.getDesiredDCMVelocity());
            this.desiredVRPPosition.set((FrameTuple3DReadOnly)this.planner.getDesiredVRPPosition());
            this.desiredGroundReactionForce.set((FrameTuple3DReadOnly)this.desiredCoMAcceleration);
            this.desiredGroundReactionForce.addZ(9.81);
            this.desiredECMPPosition.set((FrameTuple3DReadOnly)this.desiredVRPPosition);
            this.desiredECMPPosition.subZ(9.81 / (this.omega.getDoubleValue() * this.omega.getDoubleValue()));
            this.dcmTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredDCMPosition);
            this.comTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredCoMPosition);
            this.vrpTrajectory.setBallLoop((FramePoint3DReadOnly)this.desiredVRPPosition);
            this.yoTime.add(0.001);
            this.timeInPhase.add(0.001);
            this.updateContactState();
            this.scs.tickAndUpdate();
        }
    }

    private void updateContactState() {
        if (this.timeInPhase.getDoubleValue() > this.contactStates.get(0).getTimeInterval().getEndTime() && this.contactStates.size() > 1) {
            this.contactStates.remove(0);
            double timeShift = -this.contactStates.get(0).getTimeInterval().getStartTime();
            for (ContactStateProvider contactState : this.contactStates) {
                contactState.getTimeInterval().shiftInterval(timeShift);
            }
            this.planner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.desiredCoMPosition, (FrameVector3DReadOnly)this.desiredCoMVelocity);
            this.planner.solveForTrajectory(this.contactStates);
            this.timeInPhase.set(0.0);
        }
    }

    public static void main(String[] args) {
        CoMTrajectoryPlannerVisualizer visualizer = new CoMTrajectoryPlannerVisualizer();
    }
}

