/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.kinematics;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import us.ihmc.commonWalkingControlModules.contact.kinematics.ContactDetectorTestTools;
import us.ihmc.commonWalkingControlModules.contact.kinematics.MeshBasedContactDetector;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.FrameCylinder3D;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class MeshBasedContactDetectorVisualizer {
    private static final double contactThreshold = 0.04;
    private static final ColorDefinition color = ColorDefinitions.DarkGreen();

    public static void main(String[] args) {
        MeshBasedContactDetectorVisualizer.visualizeCapsuleContact();
    }

    private static void visualizeSphereContact() {
        double radius = 0.2;
        RobotDefinition sphereRobot = ContactDetectorTestTools.newSphereRobot("sphere", radius, 1.0, radius, color);
        Function<RigidBodyBasics, Collidable> collidableBuilder = body -> new Collidable(body, -1L, -1L, (FrameShape3DReadOnly)new FrameSphere3D((ReferenceFrame)body.getBodyFixedFrame(), radius));
        MeshBasedContactDetectorVisualizer.runVisualizer(sphereRobot, collidableBuilder);
    }

    private static void visualizeCylinderContact() {
        double radius = 0.15;
        double length = 0.3;
        RobotDefinition cylinderRobot = ContactDetectorTestTools.newCylinderRobot("cylinder", radius, length, 1.0, radius, color);
        Function<RigidBodyBasics, Collidable> collidableBuilder = body -> new Collidable(body, -1L, -1L, (FrameShape3DReadOnly)new FrameCylinder3D((ReferenceFrame)body.getBodyFixedFrame(), length, radius));
        MeshBasedContactDetectorVisualizer.runVisualizer(cylinderRobot, collidableBuilder);
    }

    private static void visualizeCapsuleContact() {
        double radius = 0.1;
        double length = 0.4;
        RobotDefinition capsuleRobot = ContactDetectorTestTools.newCapsuleRobot("capsule", radius, length, 1.0, 0.1, color);
        Function<RigidBodyBasics, Collidable> collidableBuilder = body -> new Collidable(body, -1L, -1L, (FrameShape3DReadOnly)new FrameCapsule3D((ReferenceFrame)body.getBodyFixedFrame(), length, radius));
        MeshBasedContactDetectorVisualizer.runVisualizer(capsuleRobot, collidableBuilder);
    }

    private static void visualizeBoxContact() {
        double sizeX = 0.1;
        double sizeY = 0.2;
        double sizeZ = 0.25;
        RobotDefinition boxRobot = ContactDetectorTestTools.newBoxRobot("box", sizeX, sizeY, sizeZ, 1.0, 0.1, color);
        Function<RigidBodyBasics, Collidable> collidableBuilder = body -> new Collidable(body, -1L, -1L, (FrameShape3DReadOnly)new FrameBox3D((ReferenceFrame)body.getBodyFixedFrame(), sizeX, sizeY, sizeZ));
        MeshBasedContactDetectorVisualizer.runVisualizer(boxRobot, collidableBuilder);
    }

    private static void runVisualizer(RobotDefinition robotDefinition, Function<RigidBodyBasics, Collidable> collidableBuilder) {
        String linkName = robotDefinition.getName() + "Link";
        RobotCollisionModel collisionModel = RobotCollisionModel.singleBodyCollisionModel((String)linkName, collidableBuilder);
        robotDefinition.ignoreAllJoints();
        RigidBodyBasics rootBody = robotDefinition.newInstance(ReferenceFrame.getWorldFrame());
        MeshBasedContactDetector contactDetector = new MeshBasedContactDetector(collisionModel.getRobotCollidables(rootBody));
        SimulationSession simulationSession = new SimulationSession();
        Robot robot = simulationSession.getPhysicsEngine().addRobot(robotDefinition);
        robot.addController(MeshBasedContactDetectorVisualizer.setupContactController(robot, rootBody, contactDetector, simulationSession.getRootRegistry()));
        MeshBasedContactDetectorVisualizer.setContactGraphics(contactDetector, simulationSession);
        simulationSession.getRootRegistry().addChild(contactDetector.getRegistry());
        simulationSession.addYoGraphicDefinition(contactDetector.getSCS2YoGraphics());
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    private static void setContactGraphics(MeshBasedContactDetector contactDetector, SimulationSession simulation) {
        simulation.getSimulationSessionControls().setRealTimeRateSimulation(true);
        Box3DDefinition contactPlane = new Box3DDefinition(3.0, 3.0, 0.002);
        ColorDefinition gray = ColorDefinitions.Gray();
        gray.setAlpha(0.8);
        VisualDefinition environmentVisual = new VisualDefinition((GeometryDefinition)contactPlane, gray);
        CollisionShapeDefinition boxCollisionShape = new CollisionShapeDefinition((GeometryDefinition)contactPlane);
        boxCollisionShape.getOriginPose().getTranslation().setZ(0.04);
        simulation.addTerrainObject(new TerrainObjectDefinition(environmentVisual, boxCollisionShape));
        List<FrameBox3D> environmentShapes = List.of(new FrameBox3D(ReferenceFrame.getWorldFrame(), (Point3DReadOnly)new Point3D(0.0, 0.0, -0.5), (Orientation3DReadOnly)new Quaternion(), 10.0, 10.0, 1.0));
        contactDetector.setEnvironmentShapes(environmentShapes);
        contactDetector.setContactThreshold(0.04);
    }

    private static MeshDataHolder newConvexPolytope3DMesh(ConvexPolytope3DReadOnly convexPolytope3D) {
        MeshDataBuilder meshBuilder = new MeshDataBuilder();
        for (Face3DReadOnly face : convexPolytope3D.getFaces()) {
            List ccwFaceVertices = face.getVertices().stream().map(Point3D::new).collect(Collectors.toList());
            Collections.reverse(ccwFaceVertices);
            meshBuilder.addMesh(MeshDataGenerator.Polygon(ccwFaceVertices));
        }
        return meshBuilder.generateMeshDataHolder();
    }

    static Controller setupContactController(Robot robot, RigidBodyBasics rootBody, MeshBasedContactDetector contactDetector, YoRegistry registry) {
        SixDoFJoint rootJoint = (SixDoFJoint)rootBody.getChildrenJoints().get(0);
        SimFloatingJointBasics floatingJoint = robot.getFloatingRootJoint();
        floatingJoint.getJointPose().getPosition().setZ(0.2);
        Random random = new Random(390L);
        YoBoolean setToRandomOrientation = new YoBoolean("setToRandomOrientation", registry);
        return () -> {
            if (setToRandomOrientation.getValue()) {
                setToRandomOrientation.set(false);
                floatingJoint.getJointPose().getOrientation().set((Orientation3DReadOnly)EuclidCoreRandomTools.nextOrientation3D((Random)random));
            }
            rootJoint.getJointPose().set((Tuple3DReadOnly)floatingJoint.getJointPose().getPosition(), (Orientation3DReadOnly)floatingJoint.getJointPose().getOrientation());
            rootBody.updateFramesRecursively();
            contactDetector.update();
        };
    }

    static {
        color.setAlpha(0.3);
    }
}

