/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.kinematics;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class ContactDetectorTestTools {
    static RobotDefinition newSphereRobot(String name, double radius, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition("floatingJoint");
        RigidBodyDefinition sphere = ContactDetectorTestTools.newSphereLink(name + "Link", radius, mass, radiusOfGyrationPercent, color);
        RobotDefinition robotDescription = new RobotDefinition(name);
        robotDescription.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(sphere);
        return robotDescription;
    }

    public static RigidBodyDefinition newSphereLink(String name, double radius, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition sphere = new RigidBodyDefinition(name);
        sphere.setMass(mass);
        double radiusOfGyration = radiusOfGyrationPercent * radius;
        sphere.getMomentOfInertia().setToDiagonal(radiusOfGyration, radiusOfGyration, radiusOfGyration);
        Sphere3DDefinition geometryDefinition = new Sphere3DDefinition(radius);
        MaterialDefinition materialDefinition = new MaterialDefinition(color);
        sphere.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        sphere.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return sphere;
    }

    static RobotDefinition newCylinderRobot(String name, double radius, double length, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition("floatingJoint");
        RigidBodyDefinition cylinder = ContactDetectorTestTools.newCylinderLink(name + "Link", radius, length, mass, radiusOfGyrationPercent, color);
        RobotDefinition robotDescription = new RobotDefinition(name);
        robotDescription.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(cylinder);
        return robotDescription;
    }

    public static RigidBodyDefinition newCylinderLink(String name, double radius, double length, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition cylinder = new RigidBodyDefinition(name);
        cylinder.setMass(mass);
        double mR = radiusOfGyrationPercent * radius;
        double mL = radiusOfGyrationPercent * length;
        cylinder.getMomentOfInertia().setToDiagonal(mR, mR, mL);
        Cylinder3DDefinition geometryDefinition = new Cylinder3DDefinition(length, radius);
        MaterialDefinition materialDefinition = new MaterialDefinition(color);
        cylinder.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        cylinder.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return cylinder;
    }

    static RobotDefinition newCapsuleRobot(String name, double radius, double length, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition("floatingJoint");
        RigidBodyDefinition capsule = ContactDetectorTestTools.newCapsuleLink(name + "Link", radius, length, mass, radiusOfGyrationPercent, color);
        RobotDefinition robotDescription = new RobotDefinition(name);
        robotDescription.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(capsule);
        return robotDescription;
    }

    static RigidBodyDefinition newCapsuleLink(String name, double radius, double length, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition capsule = new RigidBodyDefinition(name);
        capsule.setMass(mass);
        double mR = radiusOfGyrationPercent * radius;
        double mL = radiusOfGyrationPercent * length;
        capsule.getMomentOfInertia().setToDiagonal(mR, mR, mL);
        Capsule3DDefinition geometryDefinition = new Capsule3DDefinition(length, radius);
        MaterialDefinition materialDefinition = new MaterialDefinition(color);
        capsule.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        capsule.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return capsule;
    }

    static RobotDefinition newBoxRobot(String name, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        return ContactDetectorTestTools.newBoxRobot(name, size.getX(), size.getY(), size.getZ(), mass, radiusOfGyrationPercent, color);
    }

    static RobotDefinition newBoxRobot(String name, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition("floatingJoint");
        RigidBodyDefinition box = ContactDetectorTestTools.newBoxLink(name + "Link", sizeX, sizeY, sizeZ, mass, radiusOfGyrationPercent, color);
        RobotDefinition robotDescription = new RobotDefinition(name);
        robotDescription.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(box);
        return robotDescription;
    }

    static RigidBodyDefinition newBoxLink(String name, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RigidBodyDefinition box = new RigidBodyDefinition(name);
        box.setMass(mass);
        box.getMomentOfInertia().setToDiagonal(radiusOfGyrationPercent * sizeX, radiusOfGyrationPercent * sizeY, radiusOfGyrationPercent * sizeZ);
        Box3DDefinition geometryDefinition = new Box3DDefinition(sizeX, sizeY, sizeZ);
        MaterialDefinition materialDefinition = new MaterialDefinition(color);
        box.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        box.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return box;
    }
}

