/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state.implementations;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PoseState
extends State {
    public static final int orientationStart = 0;
    public static final int angularVelocityStart = 3;
    public static final int angularAccelerationStart = 6;
    public static final int positionStart = 9;
    public static final int linearVelocityStart = 12;
    public static final int linearAccelerationStart = 15;
    public static final int size = 18;
    private final Vector3DBasics rotationVector = new Vector3D();
    private final QuaternionBasics orientation = new Quaternion();
    private final Vector3DBasics linearVelocity = new Vector3D();
    private final Vector3DBasics angularVelocity = new Vector3D();
    private final Quaternion tempRotation = new Quaternion();
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    private final Matrix3D result = new Matrix3D();
    private final Vector3D tempLinearVelocity1 = new Vector3D();
    private final Vector3D tempLinearVelocity2 = new Vector3D();
    private final Matrix3D matrix = new Matrix3D();
    private final RotationMatrix tempRotationMatrix = new RotationMatrix();
    private final Matrix3D tildeForm = new Matrix3D();
    private final Matrix3D term1 = new Matrix3D();
    private final Matrix3D term2 = new Matrix3D();
    private final DMatrixRMaj stateVector = new DMatrixRMaj(18, 1);
    private final DoubleProvider angularAccelerationVariance;
    private final DoubleProvider linearAccelerationVariance;
    private final DMatrixRMaj Qref = new DMatrixRMaj(9, 9);
    private final double dt;
    private final double sqrtHz;
    private final ReferenceFrame bodyFrame;
    private final String name;
    private final DMatrixRMaj tempBlock = new DMatrixRMaj(3, 3);

    public PoseState(String bodyName, double dt, ReferenceFrame bodyFrame, YoRegistry registry) {
        this.dt = dt;
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.bodyFrame = bodyFrame;
        this.name = FilterTools.stringToPrefix(bodyName);
        this.angularAccelerationVariance = FilterTools.findOrCreate(this.name + "AngularAccelerationVariance", registry, 1.0);
        this.linearAccelerationVariance = FilterTools.findOrCreate(this.name + "LinearAccelerationVariance", registry, 1.0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void initialize(RigidBodyTransform transform, TwistReadOnly twist) {
        twist.checkReferenceFrameMatch(this.bodyFrame, this.bodyFrame.getParent(), this.bodyFrame);
        this.orientation.set((Orientation3DReadOnly)transform.getRotation());
        this.stateVector.set(0, 0.0);
        this.stateVector.set(1, 0.0);
        this.stateVector.set(2, 0.0);
        this.stateVector.set(3, twist.getAngularPartX());
        this.stateVector.set(4, twist.getAngularPartY());
        this.stateVector.set(5, twist.getAngularPartZ());
        this.stateVector.set(6, 0.0);
        this.stateVector.set(7, 0.0);
        this.stateVector.set(8, 0.0);
        transform.getTranslation().get(9, (DMatrix)this.stateVector);
        this.stateVector.set(12, twist.getLinearPartX());
        this.stateVector.set(13, twist.getLinearPartY());
        this.stateVector.set(14, twist.getLinearPartZ());
        this.stateVector.set(15, 0.0);
        this.stateVector.set(16, 0.0);
        this.stateVector.set(17, 0.0);
    }

    @Override
    public void setStateVector(DMatrix1Row newState) {
        FilterTools.checkVectorDimensions(newState, (DMatrix1Row)this.stateVector);
        this.stateVector.set((DMatrixD1)newState);
        this.rotationVector.set(0, (DMatrix)newState);
        this.add(this.orientation, (Vector3DReadOnly)this.rotationVector);
        this.rotationVector.setToZero();
        this.rotationVector.get(0, (DMatrix)this.stateVector);
    }

    @Override
    public void getStateVector(DMatrix1Row vectorToPack) {
        vectorToPack.set((DMatrixD1)this.stateVector);
    }

    @Override
    public int getSize() {
        return 18;
    }

    @Override
    public void predict() {
        this.rotationVector.setElement(0, this.stateVector.get(3));
        this.rotationVector.setElement(1, this.stateVector.get(4));
        this.rotationVector.setElement(2, this.stateVector.get(5));
        this.orientation.transform((Tuple3DBasics)this.rotationVector);
        this.linearVelocity.set(12, (DMatrix)this.stateVector);
        this.orientation.transform((Tuple3DBasics)this.linearVelocity);
        this.rotationVector.scale(this.dt);
        this.add(this.orientation, (Vector3DReadOnly)this.rotationVector);
        this.stateVector.add(3, 0, this.dt * this.stateVector.get(6));
        this.stateVector.add(4, 0, this.dt * this.stateVector.get(7));
        this.stateVector.add(5, 0, this.dt * this.stateVector.get(8));
        this.stateVector.add(9, 0, this.dt * this.linearVelocity.getElement(0));
        this.stateVector.add(10, 0, this.dt * this.linearVelocity.getElement(1));
        this.stateVector.add(11, 0, this.dt * this.linearVelocity.getElement(2));
        this.stateVector.add(12, 0, this.dt * this.stateVector.get(15));
        this.stateVector.add(13, 0, this.dt * this.stateVector.get(16));
        this.stateVector.add(14, 0, this.dt * this.stateVector.get(17));
    }

    @Override
    public void getFMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(18, 18);
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        matrixToPack.set(3, 6, this.dt);
        matrixToPack.set(4, 7, this.dt);
        matrixToPack.set(5, 8, this.dt);
        matrixToPack.set(12, 15, this.dt);
        matrixToPack.set(13, 16, this.dt);
        matrixToPack.set(14, 17, this.dt);
        this.packLinearVelocityTermForPosition((DMatrix1Row)this.tempBlock, (QuaternionReadOnly)this.orientation, this.dt);
        CommonOps_DDRM.insert((DMatrix)this.tempBlock, (DMatrix)matrixToPack, (int)9, (int)12);
        this.linearVelocity.set(12, (DMatrix)this.stateVector);
        this.packOrientatonTermForPosition((DMatrix1Row)this.tempBlock, (QuaternionReadOnly)this.orientation, (Vector3DReadOnly)this.linearVelocity, this.dt);
        CommonOps_DDRM.insert((DMatrix)this.tempBlock, (DMatrix)matrixToPack, (int)9, (int)0);
        this.angularVelocity.set(3, (DMatrix)this.stateVector);
        this.packAngularVelocityTermForOrientation((DMatrix1Row)this.tempBlock, (QuaternionReadOnly)this.orientation, (Vector3DReadOnly)this.angularVelocity, this.dt);
        CommonOps_DDRM.insert((DMatrix)this.tempBlock, (DMatrix)matrixToPack, (int)0, (int)3);
    }

    @Override
    public void getQMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(18, 18);
        CommonOps_DDRM.fill((DMatrixD1)matrixToPack, (double)0.0);
        FilterTools.packQref(this.dt, (DMatrix1Row)this.Qref, 3);
        CommonOps_DDRM.scale((double)(this.angularAccelerationVariance.getValue() * this.sqrtHz), (DMatrixD1)this.Qref);
        CommonOps_DDRM.insert((DMatrix)this.Qref, (DMatrix)matrixToPack, (int)0, (int)0);
        FilterTools.packQref(this.dt, (DMatrix1Row)this.Qref, 3);
        CommonOps_DDRM.scale((double)(this.linearAccelerationVariance.getValue() * this.sqrtHz), (DMatrixD1)this.Qref);
        CommonOps_DDRM.insert((DMatrix)this.Qref, (DMatrix)matrixToPack, (int)9, (int)9);
    }

    public void getOrientation(FrameQuaternion orientationToPack) {
        orientationToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (QuaternionReadOnly)this.orientation);
    }

    public void getAngularVelocity(FrameVector3D angularVelocityToPack) {
        angularVelocityToPack.setToZero(this.bodyFrame);
        angularVelocityToPack.set(3, (DMatrix)this.stateVector);
    }

    public void getAngularAcceleration(FrameVector3D angularAccelerationToPack) {
        angularAccelerationToPack.setToZero(this.bodyFrame);
        angularAccelerationToPack.set(6, (DMatrix)this.stateVector);
    }

    public void getPosition(FramePoint3D positionToPack) {
        positionToPack.setToZero(ReferenceFrame.getWorldFrame());
        positionToPack.set(9, (DMatrix)this.stateVector);
    }

    public void getLinearVelocity(FrameVector3D linearVelocityToPack) {
        linearVelocityToPack.setToZero(this.bodyFrame);
        linearVelocityToPack.set(12, (DMatrix)this.stateVector);
    }

    public void getLinearAcceleration(FrameVector3D linearAccelerationToPack) {
        linearAccelerationToPack.setToZero(this.bodyFrame);
        linearAccelerationToPack.set(15, (DMatrix)this.stateVector);
    }

    public void getTransform(RigidBodyTransform transformToPack) {
        transformToPack.getRotation().set((Orientation3DReadOnly)this.orientation);
        transformToPack.getTranslation().setX(this.stateVector.get(9));
        transformToPack.getTranslation().setY(this.stateVector.get(10));
        transformToPack.getTranslation().setZ(this.stateVector.get(11));
    }

    public void getTwist(Twist twistToPack) {
        twistToPack.setToZero(this.bodyFrame, this.bodyFrame.getParent(), this.bodyFrame);
        twistToPack.setAngularPartX(this.stateVector.get(3));
        twistToPack.setAngularPartY(this.stateVector.get(4));
        twistToPack.setAngularPartZ(this.stateVector.get(5));
        twistToPack.setLinearPartX(this.stateVector.get(12));
        twistToPack.setLinearPartY(this.stateVector.get(13));
        twistToPack.setLinearPartZ(this.stateVector.get(14));
    }

    public void add(QuaternionBasics orientation, Vector3DReadOnly rotationVector) {
        this.tempRotation.setRotationVector(rotationVector);
        orientation.preMultiply((QuaternionReadOnly)this.tempRotation);
    }

    public void packAngularVelocityTermForOrientation(DMatrix1Row block, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, double dt) {
        orientation.get((CommonMatrix3DBasics)this.rotationMatrix);
        this.tempLinearVelocity1.set((Tuple3DReadOnly)linearVelocity);
        this.tempLinearVelocity1.scale(dt);
        this.packJacobianOfExponentialMap(this.result, (Vector3DReadOnly)this.tempLinearVelocity1);
        this.result.preMultiply((Matrix3DReadOnly)this.rotationMatrix);
        this.result.scale(dt);
        this.result.get((DMatrix)block);
    }

    public void packOrientatonTermForPosition(DMatrix1Row block, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, double dt) {
        this.tempLinearVelocity2.set((Tuple3DReadOnly)linearVelocity);
        orientation.transform((Tuple3DBasics)this.tempLinearVelocity2);
        this.matrix.setToTildeForm((Tuple3DReadOnly)this.tempLinearVelocity2);
        this.matrix.get((DMatrix)block);
        CommonOps_DDRM.scale((double)(-dt), (DMatrixD1)block);
    }

    public void packLinearVelocityTermForPosition(DMatrix1Row block, QuaternionReadOnly orientation, double dt) {
        orientation.get((CommonMatrix3DBasics)this.tempRotationMatrix);
        this.tempRotationMatrix.get((DMatrix)block);
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)block);
    }

    public void packJacobianOfExponentialMap(Matrix3D jacobianToPack, Vector3DReadOnly rotationVector) {
        jacobianToPack.setIdentity();
        this.tildeForm.setToTildeForm((Tuple3DReadOnly)rotationVector);
        double norm = rotationVector.length();
        if (norm < 1.0E-7) {
            this.tildeForm.scale(0.5);
            jacobianToPack.add((Matrix3DReadOnly)this.tildeForm);
        } else {
            double scaler1 = (1.0 - Math.cos(norm)) / (norm * norm);
            double scaler2 = (norm - Math.sin(norm)) / (norm * norm * norm);
            this.term1.set(this.tildeForm);
            this.term1.scale(scaler1);
            this.term2.set(this.tildeForm);
            this.term2.multiply((Matrix3DReadOnly)this.tildeForm);
            this.term2.scale(scaler2);
            jacobianToPack.add((Matrix3DReadOnly)this.term1);
            jacobianToPack.add((Matrix3DReadOnly)this.term2);
        }
    }
}

