/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state.implementations;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BiasState
extends State {
    private static final int size = 3;
    private final DMatrixRMaj bias = new DMatrixRMaj(3, 1);
    private final List<YoDouble> yoState = new ArrayList<YoDouble>();
    private final DoubleProvider variance;
    private final double sqrtHz;
    private final String name;

    public BiasState(String prefix, double dt, YoRegistry registry) {
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.name = prefix + "Bias";
        for (int i = 0; i < 3; ++i) {
            this.yoState.add(new YoDouble(prefix + "Bias" + i, registry));
        }
        this.variance = FilterTools.findOrCreate(prefix + "BiasVariance", registry, 1.0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getBias(int index) {
        return this.bias.get(index);
    }

    @Override
    public void setStateVector(DMatrix1Row newState) {
        FilterTools.checkVectorDimensions(newState, (DMatrix1Row)this.bias);
        this.bias.set((DMatrixD1)newState);
        for (int i = 0; i < 3; ++i) {
            this.yoState.get(i).set(this.bias.get(i));
        }
    }

    @Override
    public void getStateVector(DMatrix1Row vectorToPack) {
        vectorToPack.set((DMatrixD1)this.bias);
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public void predict() {
    }

    @Override
    public void getFMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(3, 3);
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
    }

    @Override
    public void getQMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(3, 3);
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)(this.variance.getValue() * this.sqrtHz), (DMatrixD1)matrixToPack);
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.bias.set(i, 0.0);
            this.yoState.get(i).set(this.bias.get(i));
        }
    }
}

