/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.hadoop.metadata;

import java.util.Arrays;
import java.util.Set;
import org.kitesdk.shaded.org.apache.parquet.column.Encoding;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.Canonicalizer;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.kitesdk.shaded.org.apache.parquet.schema.PrimitiveType;

public class ColumnChunkProperties {
    private static Canonicalizer<ColumnChunkProperties> properties = new Canonicalizer();
    private final CompressionCodecName codec;
    private final ColumnPath path;
    private final PrimitiveType.PrimitiveTypeName type;
    private final Set<Encoding> encodings;

    public static ColumnChunkProperties get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings) {
        return properties.canonicalize(new ColumnChunkProperties(codec, path, type, encodings));
    }

    private ColumnChunkProperties(CompressionCodecName codec, ColumnPath path, PrimitiveType.PrimitiveTypeName type, Set<Encoding> encodings) {
        this.codec = codec;
        this.path = path;
        this.type = type;
        this.encodings = encodings;
    }

    public CompressionCodecName getCodec() {
        return this.codec;
    }

    public ColumnPath getPath() {
        return this.path;
    }

    public PrimitiveType.PrimitiveTypeName getType() {
        return this.type;
    }

    public Set<Encoding> getEncodings() {
        return this.encodings;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnChunkProperties) {
            ColumnChunkProperties other = (ColumnChunkProperties)obj;
            return other.codec == this.codec && other.path.equals(this.path) && other.type == this.type && this.equals(other.encodings, this.encodings);
        }
        return false;
    }

    private boolean equals(Set<Encoding> a, Set<Encoding> b) {
        return a.size() == b.size() && a.containsAll(b);
    }

    public int hashCode() {
        return this.codec.hashCode() ^ this.path.hashCode() ^ this.type.hashCode() ^ Arrays.hashCode(this.encodings.toArray());
    }

    public String toString() {
        return (Object)((Object)this.codec) + " " + this.path + " " + (Object)((Object)this.type) + "  " + this.encodings;
    }
}

