/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.kitesdk.shaded.org.apache.parquet.Preconditions;
import org.kitesdk.shaded.org.apache.parquet.filter.UnboundRecordFilter;
import org.kitesdk.shaded.org.apache.parquet.filter2.compat.FilterCompat;
import org.kitesdk.shaded.org.apache.parquet.filter2.compat.RowGroupFilter;
import org.kitesdk.shaded.org.apache.parquet.hadoop.Footer;
import org.kitesdk.shaded.org.apache.parquet.hadoop.InternalParquetRecordReader;
import org.kitesdk.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.kitesdk.shaded.org.apache.parquet.hadoop.api.ReadSupport;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.kitesdk.shaded.org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.kitesdk.shaded.org.apache.parquet.schema.MessageType;

public class ParquetReader<T>
implements Closeable {
    private final ReadSupport<T> readSupport;
    private final Configuration conf;
    private final Iterator<Footer> footersIterator;
    private final FilterCompat.Filter filter;
    private InternalParquetRecordReader<T> reader;

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport) throws IOException {
        this(conf, file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(conf, file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    private ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, FilterCompat.Filter filter) throws IOException {
        this.readSupport = readSupport;
        this.filter = Preconditions.checkNotNull(filter, "filter");
        this.conf = conf;
        FileSystem fs = file.getFileSystem(conf);
        List<FileStatus> statuses = Arrays.asList(fs.listStatus(file, (PathFilter)HiddenFileFilter.INSTANCE));
        List<Footer> footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(conf, statuses, false);
        this.footersIterator = footers.iterator();
    }

    public T read() throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                return this.reader.getCurrentValue();
            }
            this.initReader();
            return this.reader == null ? null : (T)this.read();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.footersIterator.hasNext()) {
            Footer footer = this.footersIterator.next();
            List<BlockMetaData> blocks = footer.getParquetMetadata().getBlocks();
            MessageType fileSchema = footer.getParquetMetadata().getFileMetaData().getSchema();
            List<BlockMetaData> filteredBlocks = RowGroupFilter.filterRowGroups(this.filter, blocks, fileSchema);
            this.reader = new InternalParquetRecordReader<T>(this.readSupport, this.filter);
            this.reader.initialize(fileSchema, footer.getParquetMetadata().getFileMetaData(), footer.getFile(), filteredBlocks, this.conf);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static <T> Builder<T> builder(ReadSupport<T> readSupport, Path path) {
        return new Builder(readSupport, path);
    }

    public static class Builder<T> {
        private final ReadSupport<T> readSupport;
        private final Path file;
        private FilterCompat.Filter filter;
        protected Configuration conf;

        private Builder(ReadSupport<T> readSupport, Path path) {
            this.readSupport = Preconditions.checkNotNull(readSupport, "readSupport");
            this.file = Preconditions.checkNotNull(path, "path");
            this.conf = new Configuration();
            this.filter = FilterCompat.NOOP;
        }

        protected Builder(Path path) {
            this.readSupport = null;
            this.file = Preconditions.checkNotNull(path, "path");
            this.conf = new Configuration();
            this.filter = FilterCompat.NOOP;
        }

        public Builder<T> withConf(Configuration conf) {
            this.conf = Preconditions.checkNotNull(conf, "conf");
            return this;
        }

        public Builder<T> withFilter(FilterCompat.Filter filter) {
            this.filter = Preconditions.checkNotNull(filter, "filter");
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            Preconditions.checkArgument(this.readSupport != null, "[BUG] Classes that extend Builder should override getReadSupport()");
            return this.readSupport;
        }

        public ParquetReader<T> build() throws IOException {
            return new ParquetReader(this.conf, this.file, this.getReadSupport(), this.filter);
        }
    }
}

