/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.filter;

import org.kitesdk.shaded.org.apache.parquet.Preconditions;
import org.kitesdk.shaded.org.apache.parquet.column.ColumnReader;
import org.kitesdk.shaded.org.apache.parquet.filter.RecordFilter;
import org.kitesdk.shaded.org.apache.parquet.filter.UnboundRecordFilter;

public final class OrRecordFilter
implements RecordFilter {
    private final RecordFilter boundFilter1;
    private final RecordFilter boundFilter2;

    public static final UnboundRecordFilter or(final UnboundRecordFilter filter1, final UnboundRecordFilter filter2) {
        Preconditions.checkNotNull(filter1, "filter1");
        Preconditions.checkNotNull(filter2, "filter2");
        return new UnboundRecordFilter(){

            @Override
            public RecordFilter bind(Iterable<ColumnReader> readers) {
                return new OrRecordFilter(filter1.bind(readers), filter2.bind(readers));
            }
        };
    }

    private OrRecordFilter(RecordFilter boundFilter1, RecordFilter boundFilter2) {
        this.boundFilter1 = boundFilter1;
        this.boundFilter2 = boundFilter2;
    }

    @Override
    public boolean isMatch() {
        return this.boundFilter1.isMatch() || this.boundFilter2.isMatch();
    }
}

