/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking;

import org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking.BytePacker;
import org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking.BytePackerFactory;
import org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking.IntPacker;
import org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking.IntPackerFactory;

public enum Packer {
    BIG_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return beIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return beBytePackerFactory.newBytePacker(width);
        }
    }
    ,
    LITTLE_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return leIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return leBytePackerFactory.newBytePacker(width);
        }
    };

    static BytePackerFactory beBytePackerFactory;
    static IntPackerFactory beIntPackerFactory;
    static BytePackerFactory leBytePackerFactory;
    static IntPackerFactory leIntPackerFactory;

    private static IntPackerFactory getIntPackerFactory(String name) {
        return (IntPackerFactory)Packer.getStaticField("org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerFactory getBytePackerFactory(String name) {
        return (BytePackerFactory)Packer.getStaticField("org.kitesdk.shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static Object getStaticField(String className, String fieldName) {
        try {
            return Class.forName(className).getField(fieldName).get(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract IntPacker newIntPacker(int var1);

    public abstract BytePacker newBytePacker(int var1);

    static {
        beBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingBE");
        beIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingBE");
        leBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingLE");
        leIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingLE");
    }
}

