/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.column.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kitesdk.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.kitesdk.shaded.org.apache.parquet.column.ColumnWriteStore;
import org.kitesdk.shaded.org.apache.parquet.column.ColumnWriter;
import org.kitesdk.shaded.org.apache.parquet.column.ParquetProperties;
import org.kitesdk.shaded.org.apache.parquet.column.impl.ColumnWriterV2;
import org.kitesdk.shaded.org.apache.parquet.column.page.PageWriteStore;
import org.kitesdk.shaded.org.apache.parquet.column.page.PageWriter;
import org.kitesdk.shaded.org.apache.parquet.schema.MessageType;

public class ColumnWriteStoreV2
implements ColumnWriteStore {
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    private static final int MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    private static final float THRESHOLD_TOLERANCE_RATIO = 0.1f;
    private final Map<ColumnDescriptor, ColumnWriterV2> columns;
    private final Collection<ColumnWriterV2> writers;
    private long rowCount;
    private long rowCountForNextSizeCheck = 100L;
    private final long thresholdTolerance;
    private int pageSizeThreshold;

    public ColumnWriteStoreV2(MessageType schema, PageWriteStore pageWriteStore, int pageSizeThreshold, ParquetProperties parquetProps) {
        this.pageSizeThreshold = pageSizeThreshold;
        this.thresholdTolerance = (long)((float)pageSizeThreshold * 0.1f);
        TreeMap<ColumnDescriptor, ColumnWriterV2> mcolumns = new TreeMap<ColumnDescriptor, ColumnWriterV2>();
        for (ColumnDescriptor path : schema.getColumns()) {
            PageWriter pageWriter = pageWriteStore.getPageWriter(path);
            mcolumns.put(path, new ColumnWriterV2(path, pageWriter, parquetProps, pageSizeThreshold));
        }
        this.columns = Collections.unmodifiableMap(mcolumns);
        this.writers = this.columns.values();
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        return this.columns.get(path);
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterV2> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getTotalBufferedSize()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        long total = 0L;
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    @Override
    public long getBufferedSize() {
        long total = 0L;
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            total += memColumn.getTotalBufferedSize();
        }
        return total;
    }

    @Override
    public void flush() {
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            long rows = this.rowCount - memColumn.getRowsWrittenSoFar();
            if (rows > 0L) {
                memColumn.writePage(this.rowCount);
            }
            memColumn.finalizeColumnChunk();
        }
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    @Override
    public void endRecord() {
        ++this.rowCount;
        if (this.rowCount >= this.rowCountForNextSizeCheck) {
            this.sizeCheck();
        }
    }

    private void sizeCheck() {
        long minRecordToWait = Long.MAX_VALUE;
        for (ColumnWriterV2 writer : this.writers) {
            long rowsToFillPage;
            long usedMem = writer.getCurrentPageBufferedSize();
            long rows = this.rowCount - writer.getRowsWrittenSoFar();
            long remainingMem = (long)this.pageSizeThreshold - usedMem;
            if (remainingMem <= this.thresholdTolerance) {
                writer.writePage(this.rowCount);
                remainingMem = this.pageSizeThreshold;
            }
            if ((rowsToFillPage = usedMem == 0L ? 10000L : (long)((float)rows) / usedMem * remainingMem) >= minRecordToWait) continue;
            minRecordToWait = rowsToFillPage;
        }
        if (minRecordToWait == Long.MAX_VALUE) {
            minRecordToWait = 100L;
        }
        this.rowCountForNextSizeCheck = this.rowCount + Math.min(Math.max(minRecordToWait / 2L, 100L), 10000L);
    }
}

