/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class PartialPathConversion
extends PathConversion {
    private final Path rootPath;

    public PartialPathConversion(Path rootDirectory, Schema schema) {
        super(schema);
        this.rootPath = rootDirectory;
    }

    @Override
    public StorageKey toKey(Path fromPath, StorageKey storage) {
        List<FieldPartitioner> partitioners = Accessor.getDefault().getFieldPartitioners(storage.getPartitionStrategy());
        String truncatedPath = fromPath.toString();
        if (truncatedPath.startsWith(this.rootPath.toString())) {
            truncatedPath = truncatedPath.substring(this.rootPath.toString().length());
        }
        LinkedList<String> pathParts = new LinkedList<String>();
        if (!truncatedPath.isEmpty()) {
            for (Path currentPath = new Path(truncatedPath); currentPath != null; currentPath = currentPath.getParent()) {
                String name = currentPath.getName();
                if (name.isEmpty()) continue;
                pathParts.add(currentPath.getName());
            }
            Collections.reverse(pathParts);
        }
        ArrayList<Object> values = Lists.newArrayList(new Object[pathParts.size()]);
        for (int i = 0; i < pathParts.size(); ++i) {
            values.set(i, this.valueForDirname(partitioners.get(i), (String)pathParts.get(i)));
        }
        storage.replaceValues(values);
        return storage;
    }
}

