/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.DatasetRecordException;
import org.kitesdk.data.Formats;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.io.Closeables;

class AvroAppender<E>
implements FileSystemWriter.FileAppender<E> {
    private final Schema schema;
    private final FileSystem fileSystem;
    private final Path path;
    private final boolean enableCompression;
    private final CompressionType compressionType;
    private FSDataOutputStream out = null;
    private DataFileWriter<E> dataFileWriter = null;
    private DatumWriter<E> writer = null;

    public AvroAppender(FileSystem fileSystem, Path path, Schema schema, CompressionType compressionType) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.schema = schema;
        this.enableCompression = compressionType != CompressionType.Uncompressed;
        this.compressionType = compressionType;
    }

    @Override
    public void open() throws IOException {
        this.writer = new ReflectDatumWriter<E>();
        this.dataFileWriter = new DataFileWriter<E>(this.writer);
        if (this.enableCompression) {
            this.dataFileWriter.setCodec(this.getCodecFactory());
        }
        this.out = this.fileSystem.create(this.path, true);
        this.dataFileWriter.create(this.schema, (OutputStream)this.out);
    }

    @Override
    public void append(E entity) throws IOException {
        try {
            this.dataFileWriter.append(entity);
        }
        catch (DataFileWriter.AppendWriteException e) {
            throw new DatasetRecordException("Failed to append record", e);
        }
    }

    @Override
    public long pos() throws IOException {
        return this.out.getPos();
    }

    @Override
    public void flush() throws IOException {
        this.dataFileWriter.flush();
        Hadoop.FSDataOutputStream.hflush.invoke(this.out, new Object[0]);
    }

    @Override
    public void sync() throws IOException {
        this.flush();
        Hadoop.FSDataOutputStream.hsync.invoke(this.out, new Object[0]);
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.dataFileWriter, false);
    }

    @Override
    public void cleanup() throws IOException {
    }

    public String toString() {
        return Objects.toStringHelper(this).add("path", this.path).add("schema", this.schema).add("fileSystem", this.fileSystem).add("enableCompression", this.enableCompression).add("dataFileWriter", this.dataFileWriter).add("writer", this.writer).toString();
    }

    private CodecFactory getCodecFactory() {
        switch (this.compressionType) {
            case Snappy: {
                return CodecFactory.snappyCodec();
            }
            case Deflate: {
                return CodecFactory.deflateCodec(9);
            }
            case Bzip2: {
                return CodecFactory.bzip2Codec();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported compression format %s. Supported formats: %s", this.compressionType.getName(), Arrays.toString(Formats.AVRO.getSupportedCompressionTypes().toArray())));
    }
}

