/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.JsonUtil;
import org.kitesdk.data.spi.partition.DateFormatPartitioner;
import org.kitesdk.data.spi.partition.DayOfMonthFieldPartitioner;
import org.kitesdk.data.spi.partition.HashFieldPartitioner;
import org.kitesdk.data.spi.partition.HourFieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.LongFixedSizeRangeFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.MonthFieldPartitioner;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;
import org.kitesdk.data.spi.partition.YearFieldPartitioner;

public class PartitionStrategyParser {
    private static final String PARTITIONS = "partitions";
    private static final String TYPE = "type";
    private static final String SOURCE = "source";
    private static final String NAME = "name";
    private static final String BUCKETS = "buckets";
    private static final String FORMAT = "format";
    private static final String VALUES = "values";
    private static final String SIZE = "size";

    public static PartitionStrategy parse(String json) {
        return PartitionStrategyParser.buildPartitionStrategy(JsonUtil.parse(json));
    }

    public static PartitionStrategy parse(File file) {
        return PartitionStrategyParser.buildPartitionStrategy(JsonUtil.parse(file));
    }

    public static PartitionStrategy parse(InputStream in) {
        return PartitionStrategyParser.buildPartitionStrategy(JsonUtil.parse(in));
    }

    public static boolean hasEmbeddedStrategy(Schema schema) {
        return schema.getJsonProp(PARTITIONS) != null;
    }

    public static PartitionStrategy parseFromSchema(Schema schema) {
        return PartitionStrategyParser.parse(schema.getJsonProp(PARTITIONS).toString());
    }

    public static Schema removeEmbeddedStrategy(Schema schema) {
        ObjectNode schemaJson = JsonUtil.parse(schema.toString(), ObjectNode.class);
        schemaJson.remove(PARTITIONS);
        return new Schema.Parser().parse(schemaJson.toString());
    }

    public static Schema embedPartitionStrategy(Schema schema, PartitionStrategy strategy) {
        ObjectNode schemaJson = JsonUtil.parse(schema.toString(), ObjectNode.class);
        schemaJson.set(PARTITIONS, PartitionStrategyParser.toJson(strategy));
        return new Schema.Parser().parse(schemaJson.toString());
    }

    private static PartitionStrategy buildPartitionStrategy(JsonNode node) {
        ValidationException.check(node.isArray(), "A partition strategy must be a JSON array of partitioners", new Object[0]);
        PartitionStrategy.Builder builder = new PartitionStrategy.Builder();
        Iterator<JsonNode> it = node.elements();
        while (it.hasNext()) {
            JsonNode fieldPartitioner = it.next();
            ValidationException.check(fieldPartitioner.isObject(), "A partitioner must be a JSON record", new Object[0]);
            ValidationException.check(fieldPartitioner.has(TYPE), "Partitioners must have a %s", TYPE);
            String type = fieldPartitioner.get(TYPE).asText();
            boolean isProvided = type.equals("provided");
            ValidationException.check(isProvided || fieldPartitioner.has(SOURCE), "Partitioners must have a %s", SOURCE);
            String source = null;
            if (!isProvided) {
                source = fieldPartitioner.get(SOURCE).asText();
            }
            String name = null;
            if (fieldPartitioner.has(NAME)) {
                name = fieldPartitioner.get(NAME).asText();
            }
            if (type.equals("identity")) {
                builder.identity(source, name);
                continue;
            }
            if (type.equals("hash")) {
                ValidationException.check(fieldPartitioner.has(BUCKETS), "Hash partitioner %s must have attribute %s", name == null ? source : name, BUCKETS);
                int buckets = fieldPartitioner.get(BUCKETS).asInt();
                ValidationException.check(buckets > 0, "Invalid number of buckets for hash partitioner %s: %s", name == null ? source : name, fieldPartitioner.get(BUCKETS).asText());
                builder.hash(source, name, buckets);
                continue;
            }
            if (type.equals("range")) {
                ValidationException.check(fieldPartitioner.has(SIZE), "Range partitioner %s must have attribute %s", name == null ? source : name, SIZE);
                long size = fieldPartitioner.get(SIZE).asLong();
                ValidationException.check(size > 0L, "Invalid size for range partitioner %s: %s", name == null ? source : name, fieldPartitioner.get(SIZE).asText());
                builder.fixedSizeRange(source, name, size);
                continue;
            }
            if (type.equals("year")) {
                builder.year(source, name);
                continue;
            }
            if (type.equals("month")) {
                builder.month(source, name);
                continue;
            }
            if (type.equals("day")) {
                builder.day(source, name);
                continue;
            }
            if (type.equals("hour")) {
                builder.hour(source, name);
                continue;
            }
            if (type.equals("minute")) {
                builder.minute(source, name);
                continue;
            }
            if (type.equals("dateFormat")) {
                ValidationException.check(name != null, "Date format partitioner %s must have a %s.", source, NAME);
                ValidationException.check(fieldPartitioner.has(FORMAT), "Date format partitioner %s must have a %s.", name, FORMAT);
                String format = fieldPartitioner.get(FORMAT).asText();
                builder.dateFormat(source, name, format);
                continue;
            }
            if (isProvided) {
                ValidationException.check(name != null, "Provided partitioners must have a %s.", NAME);
                String valuesType = null;
                if (fieldPartitioner.has(VALUES)) {
                    valuesType = fieldPartitioner.get(VALUES).asText();
                }
                builder.provided(name, valuesType);
                continue;
            }
            throw new ValidationException("Invalid FieldPartitioner: " + type);
        }
        return builder.build();
    }

    private static JsonNode toJson(PartitionStrategy strategy) {
        ArrayNode strategyJson = JsonNodeFactory.instance.arrayNode();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            ObjectNode partitioner = JsonNodeFactory.instance.objectNode();
            partitioner.set(NAME, TextNode.valueOf(fp.getName()));
            if (fp instanceof IdentityFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("identity"));
            } else if (fp instanceof HashFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("hash"));
                partitioner.set(BUCKETS, LongNode.valueOf(fp.getCardinality()));
            } else if (fp instanceof LongFixedSizeRangeFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("range"));
                partitioner.set(SIZE, LongNode.valueOf(((LongFixedSizeRangeFieldPartitioner)fp).getSize()));
            } else if (fp instanceof YearFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("year"));
            } else if (fp instanceof MonthFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("month"));
            } else if (fp instanceof DayOfMonthFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("day"));
            } else if (fp instanceof HourFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("hour"));
            } else if (fp instanceof MinuteFieldPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("minute"));
            } else if (fp instanceof DateFormatPartitioner) {
                partitioner.set(SOURCE, TextNode.valueOf(fp.getSourceName()));
                partitioner.set(TYPE, TextNode.valueOf("dateFormat"));
                partitioner.set(FORMAT, TextNode.valueOf(((DateFormatPartitioner)fp).getPattern()));
            } else if (fp instanceof ProvidedFieldPartitioner) {
                partitioner.set(TYPE, TextNode.valueOf("provided"));
                partitioner.set(VALUES, TextNode.valueOf(((ProvidedFieldPartitioner)fp).getTypeAsString()));
            } else {
                throw new ValidationException("Unknown partitioner class: " + fp.getClass());
            }
            strategyJson.add(partitioner);
        }
        return strategyJson;
    }

    public static String toString(PartitionStrategy strategy, boolean pretty) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator(writer);
            if (pretty) {
                gen.useDefaultPrettyPrinter();
            }
            gen.setCodec(new ObjectMapper());
            gen.writeTree(PartitionStrategyParser.toJson(strategy));
            gen.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot write to JSON generator", e);
        }
        return writer.toString();
    }
}

