/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.utility;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.api.RegistryOperationsFactory;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.zk.ZookeeperUtils;
import org.apache.slider.server.services.utility.LaunchedWorkflowCompositeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSliderLaunchedService
extends LaunchedWorkflowCompositeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractSliderLaunchedService.class);

    protected AbstractSliderLaunchedService(String name) {
        super(name);
        new YarnConfiguration();
        ConfigHelper.registerDeprecatedConfigItems();
    }

    public String lookupZKQuorum() throws BadConfigException {
        String registryQuorum = this.getConfig().get("hadoop.registry.zk.quorum");
        if (SliderUtils.isUnset(registryQuorum)) {
            throw new BadConfigException("No Zookeeper quorum provided in the configuration property hadoop.registry.zk.quorum");
        }
        ZookeeperUtils.splitToHostsAndPortsStrictly(registryQuorum);
        return registryQuorum;
    }

    public RegistryOperations startRegistryOperationsService() throws BadConfigException {
        this.lookupZKQuorum();
        RegistryOperations registryWriterService = this.createRegistryOperationsInstance();
        this.deployChildService((Service)registryWriterService);
        return registryWriterService;
    }

    protected RegistryOperations createRegistryOperationsInstance() {
        return RegistryOperationsFactory.createInstance((String)"YarnRegistry", (Configuration)this.getConfig());
    }

    protected static void requireArgumentSet(String argname, String value) throws BadCommandArgumentsException {
        AbstractSliderLaunchedService.require(AbstractSliderLaunchedService.isSet(value), "Required argument %s missing", argname);
    }

    protected static void require(boolean condition, String message, Object ... args) throws BadCommandArgumentsException {
        if (!condition) {
            throw new BadCommandArgumentsException(message, args);
        }
    }
}

