/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.SecurityStoreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityStoreGenerator
implements SecurityStoreGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSecurityStoreGenerator.class);
    protected CertificateManager certificateMgr;

    public AbstractSecurityStoreGenerator(CertificateManager certificateMgr) {
        this.certificateMgr = certificateMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStorePassword(Map<String, List<String>> credentials, MapOperations compOps, String role) throws SliderException, IOException {
        String password = this.getPassword(compOps);
        if (password == null) {
            String alias = this.getAlias(compOps);
            LOG.debug("Alias {} found for role {}", (Object)alias, (Object)role);
            if (alias == null) {
                throw new SliderException("No store password or credential provider alias found");
            }
            if (credentials.isEmpty()) {
                LOG.info("Credentials can not be retrieved for store generation since no CP paths are configured");
            }
            AbstractSecurityStoreGenerator abstractSecurityStoreGenerator = this;
            synchronized (abstractSecurityStoreGenerator) {
                for (Map.Entry<String, List<String>> cred : credentials.entrySet()) {
                    String provider = cred.getKey();
                    Configuration c = new Configuration();
                    c.set("hadoop.security.credential.provider.path", provider);
                    LOG.debug("Configured provider {}", (Object)provider);
                    CredentialProvider cp = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)c).get(0);
                    LOG.debug("Aliases: {}", (Object)cp.getAliases());
                    char[] credential = c.getPassword(alias);
                    if (credential == null) continue;
                    LOG.info("Credential found for role {}", (Object)role);
                    return String.valueOf(credential);
                }
            }
            if (password == null) {
                LOG.info("No store credential found for alias {}.  Generation of store for {} is not possible.", (Object)alias, (Object)role);
            }
        }
        return password;
    }

    @Override
    public boolean isStoreRequested(MapOperations compOps) {
        return compOps.getOptionBool("slider.component.security.stores.required", false);
    }

    abstract String getPassword(MapOperations var1);

    abstract String getAlias(MapOperations var1);
}

