/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.view;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.view.SliderHamletBlock;

public class ContainerStatsBlock
extends SliderHamletBlock {
    private static final String EVEN = "even";
    private static final String ODD = "odd";
    private static final String BOLD = "bold";
    private static final String SCHEME = "http://";
    private static final String PATH = "/node/container/";
    protected static final Function<Map.Entry<String, Integer>, Map.Entry<TableContent, Integer>> stringIntPairFunc = ContainerStatsBlock.toTableContentFunction();
    protected static final Function<Map.Entry<String, Long>, Map.Entry<TableContent, Long>> stringLongPairFunc = ContainerStatsBlock.toTableContentFunction();
    protected static final Function<Map.Entry<String, String>, Map.Entry<TableContent, String>> stringStringPairFunc = ContainerStatsBlock.toTableContentFunction();

    @Inject
    public ContainerStatsBlock(WebAppApi slider) {
        super(slider);
    }

    protected void render(HtmlBlock.Block html) {
        final Map<String, RoleInstance> containerInstances = this.getContainerInstances(this.appState.cloneOwnedContainerList());
        Map<String, Map<String, ClusterNode>> clusterNodeMap = this.appState.getRoleClusterNodeMapping();
        Map<String, ComponentInformation> componentInfoMap = this.appState.getComponentInfoSnapshot();
        for (Map.Entry<String, Map<String, ClusterNode>> entry : clusterNodeMap.entrySet()) {
            String name = entry.getKey();
            Map<String, ClusterNode> clusterNodesInRole = entry.getValue();
            Hamlet.DIV div = html.div("role-info ui-widget-content ui-corner-all");
            ArrayList<ClusterNode> nodesInRole = new ArrayList<ClusterNode>(clusterNodesInRole.values());
            div.h2(BOLD, StringUtils.capitalize(name));
            ComponentInformation componentInfo = componentInfoMap.get(name);
            if (componentInfo != null) {
                Set<Map.Entry<String, Integer>> stats = componentInfo.buildStatistics().entrySet();
                this.generateRoleDetails((Hamlet.DIV<Hamlet>)div, "role-stats-wrap", "Specifications", Iterables.transform(stats, stringIntPairFunc));
            }
            Collections.sort(nodesInRole, new ClusterNodeNameComparator());
            this.generateRoleDetails((Hamlet.DIV<Hamlet>)div, "role-stats-containers", "Containers", Iterables.transform(nodesInRole, new Function<ClusterNode, Map.Entry<TableContent, String>>(){

                @Override
                public Map.Entry<TableContent, String> apply(ClusterNode input) {
                    String containerId = input.name;
                    if (containerInstances.containsKey(containerId)) {
                        RoleInstance roleInst = (RoleInstance)containerInstances.get(containerId);
                        if (roleInst.container.getNodeHttpAddress() != null) {
                            return Maps.immutableEntry(new TableAnchorContent(containerId, ContainerStatsBlock.this.buildNodeUrlForContainer(roleInst.container.getNodeHttpAddress(), containerId)), null);
                        }
                    }
                    return Maps.immutableEntry(new TableContent(input.name), null);
                }
            }));
            ClusterDescription desc = this.appState.getClusterStatus();
            Map<String, String> options = desc.getRole(name);
            Iterable<Object> tableContent = options != null ? Iterables.transform(options.entrySet(), stringStringPairFunc) : Collections.emptySet();
            this.generateRoleDetails((Hamlet.DIV<Hamlet>)div, "role-options-wrap", "Role Options", tableContent);
            div._();
        }
    }

    protected static <T> Function<Map.Entry<String, T>, Map.Entry<TableContent, T>> toTableContentFunction() {
        return new Function<Map.Entry<String, T>, Map.Entry<TableContent, T>>(){

            @Override
            public Map.Entry<TableContent, T> apply(Map.Entry<String, T> input) {
                return Maps.immutableEntry(new TableContent(input.getKey()), input.getValue());
            }
        };
    }

    protected Map<String, RoleInstance> getContainerInstances(List<RoleInstance> roleInstances) {
        HashMap<String, RoleInstance> map = Maps.newHashMapWithExpectedSize(roleInstances.size());
        for (RoleInstance roleInstance : roleInstances) {
            map.put(roleInstance.id, roleInstance);
        }
        return map;
    }

    protected <T1 extends TableContent, T2> void generateRoleDetails(Hamlet.DIV<Hamlet> parent, String divSelector, String detailsName, Iterable<Map.Entry<T1, T2>> contents) {
        Hamlet.DIV div = parent.div(divSelector).h3(BOLD, detailsName);
        int offset = 0;
        Hamlet.TABLE table = null;
        Hamlet.TBODY tbody = null;
        for (Map.Entry<T1, T2> content : contents) {
            if (table == null) {
                table = div.table("ui-widget-content ui-corner-bottom");
                tbody = table.tbody();
            }
            Hamlet.TR row = tbody.tr(offset % 2 == 0 ? EVEN : ODD);
            ((TableContent)content.getKey()).printCell(row);
            if (content.getValue() != null) {
                row.td(content.getValue().toString());
            }
            row._();
            ++offset;
        }
        if (table != null) {
            ((Hamlet.TABLE)tbody._())._();
        } else {
            div.p("no-table-contents")._(new Object[]{"None"})._();
        }
        div._();
    }

    protected String buildNodeUrlForContainer(String nodeAddress, String containerId) {
        StringBuilder sb = new StringBuilder(SCHEME.length() + nodeAddress.length() + PATH.length() + containerId.length());
        sb.append(SCHEME).append(nodeAddress).append(PATH).append(containerId);
        return sb.toString();
    }

    protected static class ClusterNodeNameComparator
    implements Comparator<ClusterNode>,
    Serializable {
        protected ClusterNodeNameComparator() {
        }

        @Override
        public int compare(ClusterNode node1, ClusterNode node2) {
            if (node1 == null && node2 != null) {
                return -1;
            }
            if (node1 != null && node2 == null) {
                return 1;
            }
            if (node1 == null) {
                return 0;
            }
            String name1 = node1.name;
            String name2 = node2.name;
            if (name1 == null && name2 != null) {
                return -1;
            }
            if (name1 != null && name2 == null) {
                return 1;
            }
            if (name1 == null) {
                return 0;
            }
            return name1.compareTo(name2);
        }
    }

    protected static class TableAnchorContent
    extends TableContent {
        private String anchorUrl;

        public TableAnchorContent(String cell, String anchorUrl) {
            super(cell);
            this.anchorUrl = anchorUrl;
        }

        @Override
        public void printCell(Hamlet.TR<?> tableRow) {
            tableRow.td().a(this.anchorUrl, this.getCell())._();
        }
    }

    protected static class TableContent {
        private String cell;

        public TableContent(String cell) {
            this.cell = cell;
        }

        public String getCell() {
            return this.cell;
        }

        public void printCell(Hamlet.TR<?> tableRow) {
            tableRow.td(this.cell);
        }
    }
}

