/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application.resources;

import com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;
import org.apache.slider.server.appmaster.web.rest.application.resources.ResourceRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedContent<T> {
    private static final Logger log = LoggerFactory.getLogger(CachedContent.class);
    private T cachedValue;
    private long expires;
    private final long lifespan;
    private final ResourceRefresher<T> refresh;
    private int refreshCounter;

    public CachedContent(long lifespan, ResourceRefresher<T> refresh) {
        this.lifespan = lifespan;
        this.refresh = refresh;
    }

    public T get() throws Exception {
        this.maybeRefresh();
        return this.getCachedValue();
    }

    public synchronized T getCachedValue() {
        return this.cachedValue;
    }

    public synchronized int getRefreshCounter() {
        return this.refreshCounter;
    }

    public long getLifespan() {
        return this.lifespan;
    }

    public synchronized boolean maybeRefresh() throws Exception {
        long now = this.now();
        if (this.cachedValue == null || now >= this.expires) {
            log.debug("Refreshing at time {}", (Object)now);
            this.forceRefresh();
            log.debug("Refreshed value now {}", (Object)this.cachedValue);
            return true;
        }
        return false;
    }

    protected long now() {
        return Time.monotonicNow();
    }

    protected synchronized T forceRefresh() throws Exception {
        ++this.refreshCounter;
        T updated = this.refresh.refresh();
        Preconditions.checkNotNull(updated);
        this.cachedValue = updated;
        this.expires = this.now() + this.lifespan;
        return this.cachedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachedContent{");
        sb.append("  expires=").append(this.expires);
        sb.append(", lifespan=").append(this.lifespan);
        sb.append(", refresh=").append(this.refresh);
        sb.append(", refreshCounter=").append(this.refreshCounter);
        sb.append(", cached=").append(this.cachedValue);
        sb.append('}');
        return sb.toString();
    }
}

