/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.exceptions.AuthenticationFailedException;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSliderResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractSliderResource.class);
    protected final WebAppApi slider;
    protected final MetricsAndMonitoring metricsAndMonitoring;

    protected AbstractSliderResource(WebAppApi slider) {
        this.slider = slider;
        this.metricsAndMonitoring = slider.getMetricsAndMonitoring();
    }

    protected Response redirectToAppWadl(HttpServletRequest request) {
        try {
            URI location = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), "/application.wadl").toURI();
            return Response.temporaryRedirect(location).build();
        }
        catch (Exception e) {
            log.error("Error during redirect to WADL", e);
            throw new WebApplicationException(Response.serverError().build());
        }
    }

    public WebApplicationException buildException(String path, Exception ex) {
        try {
            throw ex;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new NotFoundException("Not found: " + path);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return new NotFoundException("Not found: " + path);
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            return new ForbiddenException(path);
        }
        catch (NoPathPermissionsException noPathPermissionsException) {
            return new ForbiddenException(path);
        }
        catch (Exception e) {
            log.error("Error during generation of response: {}", (Object)e, (Object)e);
            return new WebApplicationException(e);
        }
    }

    protected void mark(String verb, String path) {
        this.metricsAndMonitoring.markMeterAndCounter(String.valueOf(verb) + "-" + path);
    }

    protected void mark(String verb, String path, String subpath) {
        this.metricsAndMonitoring.markMeterAndCounter(String.valueOf(verb) + "-" + path + subpath);
    }

    protected void markGet(String path) {
        this.mark("GET", path);
    }

    protected void markGet(String path, String subpath) {
        this.mark("GET", path, subpath);
    }

    protected void markPost(String path, String subpath) {
        this.mark("POST", path, subpath);
    }

    protected void markPut(String path, String subpath) {
        this.mark("PUT", path, subpath);
    }

    protected void markDelete(String path, String subpath) {
        this.mark("DELETE", path, subpath);
    }
}

