/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterDescriptionOperations;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.ResourceKeys;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.RoleStatistics;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.exceptions.SliderInternalStateException;
import org.apache.slider.core.exceptions.TriggerClusterTeardownException;
import org.apache.slider.core.persist.AggregateConfSerDeser;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.server.appmaster.management.LongGauge;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.operations.ContainerReleaseOperation;
import org.apache.slider.server.appmaster.operations.ContainerRequestOperation;
import org.apache.slider.server.appmaster.state.AbstractClusterServices;
import org.apache.slider.server.appmaster.state.AppStateBindingInfo;
import org.apache.slider.server.appmaster.state.ContainerAllocationOutcome;
import org.apache.slider.server.appmaster.state.ContainerAllocationResults;
import org.apache.slider.server.appmaster.state.ContainerAssignment;
import org.apache.slider.server.appmaster.state.ContainerOutcome;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.ContainerReleaseSelector;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.apache.slider.server.appmaster.state.OutstandingRequest;
import org.apache.slider.server.appmaster.state.RoleHistory;
import org.apache.slider.server.appmaster.state.RoleHistoryUtils;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppState {
    protected static final Logger log = LoggerFactory.getLogger(AppState.class);
    private final AbstractClusterServices recordFactory;
    private final MetricsAndMonitoring metricsAndMonitoring;
    private boolean applicationLive = false;
    private AggregateConf instanceDefinition;
    private long snapshotTime;
    private AggregateConf instanceDefinitionSnapshot;
    private AggregateConf unresolvedInstanceDefinition;
    private ConfTreeOperations resourcesSnapshot;
    private ConfTreeOperations appConfSnapshot;
    private ConfTreeOperations internalsSnapshot;
    private ClusterDescription clusterStatus = new ClusterDescription();
    private Map<String, String> applicationInfo;
    private Map<String, String> clientProperties = new HashMap<String, String>();
    private ClusterDescription clusterStatusTemplate = new ClusterDescription();
    private final Map<Integer, RoleStatus> roleStatusMap = new ConcurrentHashMap<Integer, RoleStatus>();
    private final Map<String, ProviderRole> roles = new ConcurrentHashMap<String, ProviderRole>();
    private final Map<Integer, ProviderRole> rolePriorityMap = new ConcurrentHashMap<Integer, ProviderRole>();
    private RoleInstance appMasterNode;
    private final ConcurrentMap<ContainerId, RoleInstance> ownedContainers = new ConcurrentHashMap<ContainerId, RoleInstance>();
    private final ConcurrentMap<ContainerId, Container> containersBeingReleased = new ConcurrentHashMap<ContainerId, Container>();
    private final LongGauge completedContainerCount = new LongGauge();
    private final LongGauge failedContainerCount = new LongGauge();
    private final LongGauge startedContainers = new LongGauge();
    private final LongGauge startFailedContainerCount = new LongGauge();
    private final LongGauge surplusContainers = new LongGauge();
    private final LongGauge outstandingContainerRequests = new LongGauge();
    private final Map<ContainerId, RoleInstance> startingContainers = new ConcurrentHashMap<ContainerId, RoleInstance>();
    private final Map<ContainerId, RoleInstance> completedContainers = new ConcurrentHashMap<ContainerId, RoleInstance>();
    private final Map<ContainerId, RoleInstance> failedContainers = new ConcurrentHashMap<ContainerId, RoleInstance>();
    private final Set<ContainerId> surplusNodes = new HashSet<ContainerId>();
    private final Map<ContainerId, RoleInstance> liveNodes = new ConcurrentHashMap<ContainerId, RoleInstance>();
    private final AtomicInteger completionOfNodeNotInLiveListEvent = new AtomicInteger();
    private final AtomicInteger completionOfUnknownContainerEvent = new AtomicInteger();
    private int containerMaxCores;
    private int containerMinCores;
    private int containerMaxMemory;
    private int containerMinMemory;
    private RoleHistory roleHistory;
    private Configuration publishedProviderConf;
    private long startTimeThreshold;
    private int failureThreshold = 10;
    private int nodeFailureThreshold = 3;
    private String logServerURL = "";
    private ContainerReleaseSelector containerReleaseSelector;
    private Resource minResource;
    private Resource maxResource;

    public AppState(AbstractClusterServices recordFactory, MetricsAndMonitoring metricsAndMonitoring) {
        Preconditions.checkArgument(recordFactory != null, "null recordFactory");
        Preconditions.checkArgument(metricsAndMonitoring != null, "null metricsAndMonitoring");
        this.recordFactory = recordFactory;
        this.metricsAndMonitoring = metricsAndMonitoring;
        this.register("containers.outstanding-requests", this.outstandingContainerRequests);
        this.register("containers.surplus", this.surplusContainers);
        this.register("containers.started", this.startedContainers);
        this.register("containers.completed", this.completedContainerCount);
        this.register("containers.failed", this.failedContainerCount);
        this.register("containers.start-failed", this.startFailedContainerCount);
    }

    private void register(String name, Metric counter) {
        this.metricsAndMonitoring.getMetrics().register(MetricRegistry.name(AppState.class, name), counter);
    }

    public long getFailedCountainerCount() {
        return this.failedContainerCount.getCount();
    }

    public void incFailedCountainerCount() {
        this.failedContainerCount.inc();
    }

    public long getStartFailedCountainerCount() {
        return this.startFailedContainerCount.getCount();
    }

    public void incStartedCountainerCount() {
        this.startedContainers.inc();
    }

    public long getStartedCountainerCount() {
        return this.startedContainers.getCount();
    }

    public void incStartFailedCountainerCount() {
        this.startFailedContainerCount.inc();
    }

    public AtomicInteger getCompletionOfNodeNotInLiveListEvent() {
        return this.completionOfNodeNotInLiveListEvent;
    }

    public AtomicInteger getCompletionOfUnknownContainerEvent() {
        return this.completionOfUnknownContainerEvent;
    }

    public Map<Integer, RoleStatus> getRoleStatusMap() {
        return this.roleStatusMap;
    }

    protected Map<String, ProviderRole> getRoleMap() {
        return this.roles;
    }

    public Map<Integer, ProviderRole> getRolePriorityMap() {
        return this.rolePriorityMap;
    }

    private Map<ContainerId, RoleInstance> getStartingContainers() {
        return this.startingContainers;
    }

    private Map<ContainerId, RoleInstance> getCompletedContainers() {
        return this.completedContainers;
    }

    public Map<ContainerId, RoleInstance> getFailedContainers() {
        return this.failedContainers;
    }

    public Map<ContainerId, RoleInstance> getLiveContainers() {
        return this.liveNodes;
    }

    public synchronized ClusterDescription getClusterStatus() {
        return this.clusterStatus;
    }

    @VisibleForTesting
    protected synchronized void setClusterStatus(ClusterDescription clusterDesc) {
        this.clusterStatus = clusterDesc;
    }

    public synchronized void setInitialInstanceDefinition(AggregateConf definition) throws BadConfigException, IOException {
        log.debug("Setting initial instance definition");
        AggregateConfSerDeser serDeser = new AggregateConfSerDeser();
        this.unresolvedInstanceDefinition = serDeser.fromInstance(definition);
        this.instanceDefinition = serDeser.fromInstance(definition);
        this.onInstanceDefinitionUpdated();
    }

    public synchronized AggregateConf getInstanceDefinition() {
        return this.instanceDefinition;
    }

    @VisibleForTesting
    public RoleHistory getRoleHistory() {
        return this.roleHistory;
    }

    @VisibleForTesting
    public Path getHistoryPath() {
        return this.roleHistory.getHistoryPath();
    }

    public void setContainerLimits(int minMemory, int maxMemory, int minCores, int maxCores) {
        this.containerMinCores = minCores;
        this.containerMaxCores = maxCores;
        this.containerMinMemory = minMemory;
        this.containerMaxMemory = maxMemory;
        this.minResource = this.recordFactory.newResource(this.containerMinMemory, this.containerMinCores);
        this.maxResource = this.recordFactory.newResource(this.containerMaxMemory, this.containerMaxCores);
    }

    public ConfTreeOperations getResourcesSnapshot() {
        return this.resourcesSnapshot;
    }

    public ConfTreeOperations getAppConfSnapshot() {
        return this.appConfSnapshot;
    }

    public ConfTreeOperations getInternalsSnapshot() {
        return this.internalsSnapshot;
    }

    public boolean isApplicationLive() {
        return this.applicationLive;
    }

    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public AggregateConf getInstanceDefinitionSnapshot() {
        return this.instanceDefinitionSnapshot;
    }

    public AggregateConf getUnresolvedInstanceDefinition() {
        return this.unresolvedInstanceDefinition;
    }

    public synchronized void buildInstance(AppStateBindingInfo binding) throws BadClusterStateException, BadConfigException, IOException {
        binding.validate();
        log.debug("Building application state");
        this.publishedProviderConf = binding.publishedProviderConf;
        this.applicationInfo = binding.applicationInfo != null ? binding.applicationInfo : new HashMap<String, String>();
        this.clientProperties = new HashMap<String, String>();
        this.containerReleaseSelector = binding.releaseSelector;
        Set<String> confKeys = ConfigHelper.sortedConfigKeys((Iterable<Map.Entry<String, String>>)this.publishedProviderConf);
        for (String key : confKeys) {
            String val = this.publishedProviderConf.get(key);
            this.clientProperties.put(key, val);
        }
        this.setInitialInstanceDefinition(binding.instanceDefinition);
        ArrayList<ProviderRole> roleList = new ArrayList<ProviderRole>(binding.roles);
        for (ProviderRole providerRole : roleList) {
            this.buildRole(providerRole);
        }
        ConfTreeOperations resources = this.instanceDefinition.getResourceOperations();
        Set<String> roleNames = resources.getComponentNames();
        for (String name : roleNames) {
            if (this.roles.containsKey(name)) continue;
            log.info("Adding role {}", (Object)name);
            MapOperations resComponent = resources.getComponent(name);
            ProviderRole dynamicRole = this.createDynamicProviderRole(name, resComponent);
            this.buildRole(dynamicRole);
            roleList.add(dynamicRole);
        }
        this.buildRoleRequirementsFromResources();
        MapOperations globalResOpts = this.instanceDefinition.getResourceOperations().getGlobalOptions();
        this.startTimeThreshold = globalResOpts.getOptionInt("internal.container.failure.shortlife", 60);
        this.failureThreshold = globalResOpts.getOptionInt("yarn.container.failure.threshold", 5);
        this.nodeFailureThreshold = globalResOpts.getOptionInt("yarn.node.failure.threshold", 3);
        this.initClusterStatus();
        this.roleHistory = new RoleHistory(this.roleStatusMap.values(), this.recordFactory);
        this.roleHistory.register(this.metricsAndMonitoring);
        this.roleHistory.onStart(binding.fs, binding.historyPath);
        this.roleHistory.onNodesUpdated(binding.nodeReports);
        this.rebuildModelFromRestart(binding.liveContainers);
        this.logServerURL = binding.serviceConfig.get("yarn.log.server.url", "");
        this.applicationLive = true;
    }

    public void initClusterStatus() {
        ClusterDescription status = ClusterDescription.copy(this.clusterStatusTemplate);
        status.state = 2;
        MapOperations infoOps = new MapOperations("info", status.info);
        infoOps.mergeWithoutOverwrite(this.applicationInfo);
        SliderUtils.addBuildInfo(infoOps, "status");
        long now = this.now();
        status.setInfoTime("live.time", "live.time.millis", now);
        SliderUtils.setInfoTime(infoOps, "live.time", "live.time.millis", now);
        if (0L == status.createTime) {
            status.createTime = now;
            SliderUtils.setInfoTime(infoOps, "create.time", "create.time.millis", now);
        }
        status.state = 3;
        this.setClusterStatus(status);
    }

    public ProviderRole createDynamicProviderRole(String name, MapOperations component) throws BadConfigException {
        String priOpt = component.getMandatoryOption("yarn.role.priority");
        int priority = SliderUtils.parseAndValidate("value of " + name + " " + "yarn.role.priority", priOpt, 0, 1, -1);
        String placementOpt = component.getOption("yarn.component.placement.policy", Integer.toString(0));
        int placement = SliderUtils.parseAndValidate("value of " + name + " " + "yarn.component.placement.policy", placementOpt, 0, 0, -1);
        int placementTimeout = component.getOptionInt("yarn.placement.escalate.seconds", 30);
        ProviderRole newRole = new ProviderRole(name, priority, placement, this.getNodeFailureThresholdForRole(name), placementTimeout, component.getOption("yarn.label.expression", ResourceKeys.DEF_YARN_LABEL_EXPRESSION));
        log.info("New {} ", (Object)newRole);
        return newRole;
    }

    private synchronized void onInstanceDefinitionUpdated() throws BadConfigException, IOException {
        log.debug("Instance definition updated");
        this.snapshotTime = this.now();
        this.instanceDefinition.resolve();
        ConfTreeOperations resources = this.instanceDefinition.getResourceOperations();
        if (resources.getComponent("slider-appmaster") != null) {
            resources.setComponentOpt("slider-appmaster", "yarn.component.instances", "1");
        }
        this.resourcesSnapshot = ConfTreeOperations.fromInstance(this.instanceDefinition.getResources());
        this.appConfSnapshot = ConfTreeOperations.fromInstance(this.instanceDefinition.getAppConf());
        this.internalsSnapshot = ConfTreeOperations.fromInstance(this.instanceDefinition.getInternal());
        this.instanceDefinitionSnapshot = new AggregateConf(this.resourcesSnapshot.confTree, this.appConfSnapshot.confTree, this.internalsSnapshot.confTree);
        this.instanceDefinitionSnapshot.setName(this.instanceDefinition.getName());
        this.clusterStatusTemplate = ClusterDescriptionOperations.buildFromInstanceDefinition(this.instanceDefinition);
        for (Map.Entry<String, String> prop : this.clientProperties.entrySet()) {
            this.clusterStatusTemplate.clientProperties.put(prop.getKey(), prop.getValue());
        }
    }

    @VisibleForTesting
    public synchronized List<ProviderRole> updateResourceDefinitions(ConfTree resources) throws BadConfigException, IOException {
        log.debug("Updating resources to {}", (Object)resources);
        ConfTreeSerDeser serDeser = new ConfTreeSerDeser();
        this.unresolvedInstanceDefinition.setResources(serDeser.fromInstance(resources));
        this.instanceDefinition.setResources(serDeser.fromInstance(resources));
        this.onInstanceDefinitionUpdated();
        Map<String, Map<String, String>> updated = resources.components;
        this.getClusterStatus().roles = SliderUtils.deepClone(updated);
        this.getClusterStatus().updateTime = this.now();
        return this.buildRoleRequirementsFromResources();
    }

    private List<ProviderRole> buildRoleRequirementsFromResources() throws BadConfigException {
        ArrayList<ProviderRole> newRoles = new ArrayList<ProviderRole>(0);
        ConfTreeOperations resources = this.instanceDefinition.getResourceOperations();
        for (RoleStatus roleStatus : this.getRoleStatusMap().values()) {
            if (roleStatus.isExcludeFromFlexing()) continue;
            long currentDesired = roleStatus.getDesired();
            String role = roleStatus.getName();
            int desiredInstanceCount = this.getDesiredInstanceCount(resources, role);
            if (desiredInstanceCount == 0) {
                log.info("Role {} has 0 instances specified", (Object)role);
            }
            if (currentDesired == (long)desiredInstanceCount) continue;
            log.info("Role {} flexed from {} to {}", role, currentDesired, desiredInstanceCount);
            roleStatus.setDesired(desiredInstanceCount);
        }
        Set<String> roleNames = resources.getComponentNames();
        for (String name : roleNames) {
            if (this.roles.containsKey(name)) continue;
            log.info("Adding new role {}", (Object)name);
            MapOperations component = resources.getComponent(name);
            ProviderRole dynamicRole = this.createDynamicProviderRole(name, component);
            RoleStatus roleStatus = this.buildRole(dynamicRole);
            roleStatus.setDesired(this.getDesiredInstanceCount(resources, name));
            log.info("New role {}", (Object)roleStatus);
            this.roleHistory.addNewRole(roleStatus);
            newRoles.add(dynamicRole);
        }
        this.buildRoleResourceRequirements();
        return newRoles;
    }

    private int getDesiredInstanceCount(ConfTreeOperations resources, String role) throws BadConfigException {
        int desiredInstanceCount = resources.getComponentOptInt(role, "yarn.component.instances", 0);
        if (desiredInstanceCount < 0) {
            log.error("Role {} has negative desired instances : {}", (Object)role, (Object)desiredInstanceCount);
            throw new BadConfigException("Negative instance count (%) requested for component %s", desiredInstanceCount, role);
        }
        return desiredInstanceCount;
    }

    public RoleStatus buildRole(ProviderRole providerRole) throws BadConfigException {
        int priority = providerRole.id;
        if (this.roleStatusMap.containsKey(priority)) {
            throw new BadConfigException("Duplicate Provider Key: %s and %s", providerRole, this.roleStatusMap.get(priority));
        }
        RoleStatus roleStatus = new RoleStatus(providerRole);
        this.roleStatusMap.put(priority, roleStatus);
        String name = providerRole.name;
        this.roles.put(name, providerRole);
        this.rolePriorityMap.put(priority, providerRole);
        this.metricsAndMonitoring.addMetricSet("slider.roles." + name, roleStatus);
        return roleStatus;
    }

    private void buildRoleResourceRequirements() {
        this.roleStatusMap.values();
        for (RoleStatus role : this.roleStatusMap.values()) {
            role.setResourceRequirements(this.buildResourceRequirements(role, this.recordFactory.newResource()));
        }
    }

    public void buildAppMasterNode(ContainerId containerId, String host, int amPort, String nodeHttpAddress) {
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(containerId);
        NodeId nodeId = NodeId.newInstance((String)host, (int)amPort);
        container.setNodeId(nodeId);
        container.setNodeHttpAddress(nodeHttpAddress);
        RoleInstance am = new RoleInstance((Container)container);
        am.role = "slider-appmaster";
        am.roleId = 0;
        am.startTime = am.createTime = this.now();
        this.appMasterNode = am;
        this.getLiveContainers().put(containerId, am);
        this.putOwnedContainer(containerId, am);
        RoleStatus roleStatus = this.roleStatusMap.get(0);
        roleStatus.setDesired(1L);
        roleStatus.incActual();
        roleStatus.incStarted();
    }

    public void noteAMLaunched() {
        this.getLiveContainers().put(this.appMasterNode.getContainerId(), this.appMasterNode);
    }

    public void noteAMLive() {
        this.appMasterNode.state = 3;
    }

    public RoleStatus lookupRoleStatus(int key) {
        RoleStatus rs = this.getRoleStatusMap().get(key);
        if (rs == null) {
            throw new RuntimeException("Cannot find role for role ID " + key);
        }
        return rs;
    }

    public RoleStatus lookupRoleStatus(Container c) {
        return this.lookupRoleStatus(ContainerPriority.extractRole(c));
    }

    public List<RoleStatus> cloneRoleStatusList() {
        Collection<RoleStatus> statuses = this.roleStatusMap.values();
        ArrayList<RoleStatus> statusList = new ArrayList<RoleStatus>(statuses.size());
        try {
            for (RoleStatus status : statuses) {
                statusList.add((RoleStatus)status.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            log.warn("Unexpected cloning failure: {}", (Object)e, (Object)e);
        }
        return statusList;
    }

    public RoleStatus lookupRoleStatus(String name) throws YarnRuntimeException {
        ProviderRole providerRole = this.roles.get(name);
        if (providerRole == null) {
            throw new YarnRuntimeException("Unknown role " + name);
        }
        return this.lookupRoleStatus(providerRole.id);
    }

    public synchronized List<RoleInstance> cloneOwnedContainerList() {
        Collection values = this.ownedContainers.values();
        return new ArrayList<RoleInstance>(values);
    }

    public int getNumOwnedContainers() {
        return this.ownedContainers.size();
    }

    public RoleInstance getOwnedContainer(ContainerId id) {
        return (RoleInstance)this.ownedContainers.get(id);
    }

    private RoleInstance removeOwnedContainer(ContainerId id) {
        return (RoleInstance)this.ownedContainers.remove(id);
    }

    private RoleInstance putOwnedContainer(ContainerId id, RoleInstance instance) {
        return this.ownedContainers.put(id, instance);
    }

    public synchronized List<RoleInstance> cloneLiveContainerInfoList() {
        Collection<RoleInstance> values = this.getLiveContainers().values();
        ArrayList<RoleInstance> allRoleInstances = new ArrayList<RoleInstance>(values);
        return allRoleInstances;
    }

    public synchronized RoleInstance getLiveInstanceByContainerID(String containerId) throws NoSuchNodeException {
        Collection<RoleInstance> nodes = this.getLiveContainers().values();
        return this.findNodeInCollection(containerId, nodes);
    }

    public synchronized RoleInstance getOwnedInstanceByContainerID(String containerId) throws NoSuchNodeException {
        Collection<RoleInstance> nodes = this.ownedContainers.values();
        return this.findNodeInCollection(containerId, nodes);
    }

    private RoleInstance findNodeInCollection(String containerId, Collection<RoleInstance> nodes) throws NoSuchNodeException {
        RoleInstance found = null;
        for (RoleInstance node : nodes) {
            if (!containerId.equals(node.id)) continue;
            found = node;
            break;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchNodeException("Unknown node: " + containerId);
    }

    public synchronized List<RoleInstance> getLiveInstancesByContainerIDs(Collection<String> containerIDs) {
        HashSet<String> uuidSet = new HashSet<String>(containerIDs);
        ArrayList<RoleInstance> nodes = new ArrayList<RoleInstance>(uuidSet.size());
        Collection<RoleInstance> clusterNodes = this.getLiveContainers().values();
        for (RoleInstance node : clusterNodes) {
            if (!uuidSet.contains(node.id)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public synchronized List<RoleInstance> enumLiveNodesInRole(String role) {
        ArrayList<RoleInstance> nodes = new ArrayList<RoleInstance>();
        Collection<RoleInstance> allRoleInstances = this.getLiveContainers().values();
        for (RoleInstance node : allRoleInstances) {
            if (!role.isEmpty() && !role.equals(node.role)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public synchronized List<RoleInstance> enumNodesWithRoleId(int roleId, boolean owned) {
        ArrayList<RoleInstance> nodes = new ArrayList<RoleInstance>();
        Collection<Object> allRoleInstances = owned ? this.ownedContainers.values() : this.liveNodes.values();
        for (RoleInstance roleInstance : allRoleInstances) {
            if (roleInstance.roleId != roleId) continue;
            nodes.add(roleInstance);
        }
        return nodes;
    }

    private synchronized Map<String, List<String>> createRoleToInstanceMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RoleInstance node : this.getLiveContainers().values()) {
            ArrayList<String> containers = (ArrayList<String>)map.get(node.role);
            if (containers == null) {
                containers = new ArrayList<String>();
                map.put(node.role, containers);
            }
            containers.add(node.id);
        }
        return map;
    }

    public synchronized Map<String, Map<String, ClusterNode>> createRoleToClusterNodeMap() {
        HashMap<String, Map<String, ClusterNode>> map = new HashMap<String, Map<String, ClusterNode>>();
        for (RoleInstance node : this.getLiveContainers().values()) {
            HashMap<String, ClusterNode> containers = (HashMap<String, ClusterNode>)map.get(node.role);
            if (containers == null) {
                containers = new HashMap<String, ClusterNode>();
                map.put(node.role, containers);
            }
            ClusterNode clusterNode = node.toClusterNode();
            containers.put(clusterNode.name, clusterNode);
        }
        return map;
    }

    public void containerStartSubmitted(Container container, RoleInstance instance) {
        instance.state = 1;
        instance.container = container;
        instance.createTime = this.now();
        this.getStartingContainers().put(container.getId(), instance);
        this.putOwnedContainer(container.getId(), instance);
        this.roleHistory.onContainerStartSubmitted(container, instance);
    }

    public synchronized void containerReleaseSubmitted(Container container) throws SliderInternalStateException {
        ContainerId id = container.getId();
        RoleInstance instance = this.getOwnedContainer(id);
        if (instance == null) {
            throw new SliderInternalStateException("No active container with ID " + id);
        }
        if (this.containersBeingReleased.containsKey(id)) {
            throw new SliderInternalStateException("Container %s already queued for release", id);
        }
        instance.released = true;
        this.containersBeingReleased.put(id, instance.container);
        RoleStatus role = this.lookupRoleStatus(instance.roleId);
        role.incReleasing();
        this.roleHistory.onContainerReleaseSubmitted(container);
    }

    private AMRMClient.ContainerRequest createContainerRequest(RoleStatus role) {
        if (role.isAntiAffinePlacement()) {
            return this.createAAContainerRequest(role);
        }
        this.incrementRequestCount(role);
        return this.roleHistory.requestContainerForRole(role).getIssuedRequest();
    }

    private AMRMClient.ContainerRequest createAAContainerRequest(RoleStatus role) {
        OutstandingRequest request = this.roleHistory.requestContainerForAARole(role);
        if (request == null) {
            return null;
        }
        this.incrementRequestCount(role);
        role.setOutstandingAArequest(request);
        return request.getIssuedRequest();
    }

    protected void incrementRequestCount(RoleStatus role) {
        role.incRequested();
        this.incOutstandingContainerRequests();
    }

    private void incOutstandingContainerRequests() {
        this.outstandingContainerRequests.inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decOutstandingContainerRequests() {
        LongGauge longGauge = this.outstandingContainerRequests;
        synchronized (longGauge) {
            if (this.outstandingContainerRequests.getCount() > 0L) {
                this.outstandingContainerRequests.dec();
            }
        }
    }

    private int getResourceRequirement(ConfTreeOperations resources, String name, String option, int defVal, int maxVal) {
        String val = resources.getComponentOpt(name, option, Integer.toString(defVal));
        Integer intVal = "max".equals(val) ? Integer.valueOf(maxVal) : Integer.decode(val);
        return intVal;
    }

    public Resource buildResourceRequirements(RoleStatus role, Resource capability) {
        String name = role.getName();
        ConfTreeOperations resources = this.getResourcesSnapshot();
        int cores = this.getResourceRequirement(resources, name, "yarn.vcores", 1, this.containerMaxCores);
        capability.setVirtualCores(cores);
        int ram = this.getResourceRequirement(resources, name, "yarn.memory", 256, this.containerMaxMemory);
        capability.setMemory(ram);
        log.debug("Component {} has RAM={}, vCores ={}", name, ram, cores);
        Resource normalized = this.recordFactory.normalize(capability, this.minResource, this.maxResource);
        if (!Resources.equals((Resource)normalized, (Resource)capability)) {
            log.warn("Resource requirements of {} normalized from {} to {}", name, capability, normalized);
        }
        return normalized;
    }

    private void addLaunchedContainer(Container container, RoleInstance node) {
        node.container = container;
        if (node.role == null) {
            throw new RuntimeException("Unknown role for node " + node);
        }
        this.getLiveContainers().put(node.getContainerId(), node);
        this.roleHistory.onContainerStarted(container);
    }

    public synchronized RoleInstance onNodeManagerContainerStarted(ContainerId containerId) {
        try {
            return this.innerOnNodeManagerContainerStarted(containerId);
        }
        catch (YarnRuntimeException e) {
            log.error("NodeManager callback on started container {} failed", (Object)containerId, (Object)e);
            return null;
        }
    }

    @VisibleForTesting
    public RoleInstance innerOnNodeManagerContainerStarted(ContainerId containerId) {
        this.incStartedCountainerCount();
        RoleInstance instance = this.getOwnedContainer(containerId);
        if (instance == null) {
            throw new YarnRuntimeException("Container not in active containers start " + containerId);
        }
        if (instance.role == null) {
            throw new YarnRuntimeException("Component instance has no instance name " + instance);
        }
        instance.startTime = this.now();
        RoleInstance starting = this.getStartingContainers().remove(containerId);
        if (starting == null) {
            throw new YarnRuntimeException("Container " + containerId + " is already started");
        }
        instance.state = 3;
        RoleStatus roleStatus = this.lookupRoleStatus(instance.roleId);
        roleStatus.incStarted();
        Container container = instance.container;
        this.addLaunchedContainer(container, instance);
        return instance;
    }

    public synchronized void onNodeManagerContainerStartFailed(ContainerId containerId, Throwable thrown) {
        this.removeOwnedContainer(containerId);
        this.incFailedCountainerCount();
        this.incStartFailedCountainerCount();
        RoleInstance instance = this.getStartingContainers().remove(containerId);
        if (instance != null) {
            RoleStatus roleStatus = this.lookupRoleStatus(instance.roleId);
            String text = thrown != null ? SliderUtils.stringify(thrown) : "container start failure";
            instance.diagnostics = text;
            roleStatus.noteFailed(true, text, ContainerOutcome.Failed);
            this.getFailedContainers().put(containerId, instance);
            this.roleHistory.onNodeManagerContainerStartFailed(instance.container);
        }
    }

    public synchronized NodeUpdatedOutcome onNodesUpdated(List<NodeReport> updatedNodes) {
        boolean changed = this.roleHistory.onNodesUpdated(updatedNodes);
        if (changed) {
            log.info("YARN cluster changed \u2014cancelling current AA requests");
            List<AbstractRMOperation> operations = this.cancelOutstandingAARequests();
            log.debug("Created {} cancel requests", (Object)operations.size());
            return new NodeUpdatedOutcome(true, operations);
        }
        return new NodeUpdatedOutcome(false, new ArrayList<AbstractRMOperation>(0));
    }

    @VisibleForTesting
    public boolean isShortLived(RoleInstance instance) {
        boolean shortlived;
        long time = this.now();
        long started = instance.startTime;
        if (started > 0L) {
            long duration = time - started;
            shortlived = duration < this.startTimeThreshold * 1000L;
            log.info("Duration {} and startTimeThreshold {}", (Object)duration, (Object)this.startTimeThreshold);
        } else {
            shortlived = true;
        }
        return shortlived;
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public synchronized NodeCompletionResult onCompletedNode(ContainerStatus status) {
        int exitStatus;
        ContainerId containerId = status.getContainerId();
        NodeCompletionResult result = new NodeCompletionResult();
        result.exitStatus = exitStatus = status.getExitStatus();
        if (this.containersBeingReleased.containsKey(containerId)) {
            log.info("Container was queued for release : {}", (Object)containerId);
            Container container = (Container)this.containersBeingReleased.remove(containerId);
            RoleStatus roleStatus = this.lookupRoleStatus(container);
            long releasing = roleStatus.decReleasing();
            long actual = roleStatus.decActual();
            long completedCount = roleStatus.incCompleted();
            log.info("decrementing role count for role {} to {}; releasing={}, completed={}", roleStatus.getName(), actual, releasing, completedCount);
            result.outcome = ContainerOutcome.Completed;
            this.roleHistory.onReleaseCompleted(container);
        } else if (this.surplusNodes.remove(containerId)) {
            result.surplusNode = true;
        } else {
            result.containerFailed = true;
            result.outcome = ContainerOutcome.fromExitStatus(exitStatus);
            RoleInstance roleInstance = this.removeOwnedContainer(containerId);
            if (roleInstance != null) {
                this.incFailedCountainerCount();
                this.failedContainers.put(containerId, roleInstance);
            } else {
                roleInstance = this.failedContainers.get(containerId);
            }
            if (roleInstance != null) {
                int roleId = roleInstance.roleId;
                String rolename = roleInstance.role;
                log.info("Failed container in role[{}] : {}", (Object)roleId, (Object)rolename);
                try {
                    String message;
                    RoleStatus roleStatus = this.lookupRoleStatus(roleId);
                    roleStatus.decActual();
                    boolean shortLived = this.isShortLived(roleInstance);
                    Container failedContainer = roleInstance.container;
                    if (failedContainer != null) {
                        String completedLogsUrl = this.getLogsURLForContainer(failedContainer);
                        message = String.format("Failure %s on host %s (%d): %s", roleInstance.getContainerId(), failedContainer.getNodeId().getHost(), exitStatus, completedLogsUrl);
                    } else {
                        message = String.format("Failure %s (%d)", containerId, exitStatus);
                    }
                    roleStatus.noteFailed(shortLived, message, result.outcome);
                    long failed = roleStatus.getFailed();
                    log.info("Current count of failed role[{}] {} =  {}", roleId, rolename, failed);
                    if (failedContainer != null) {
                        this.roleHistory.onFailedContainer(failedContainer, shortLived, result.outcome);
                    }
                }
                catch (YarnRuntimeException yarnRuntimeException) {
                    log.error("Failed container of unknown role {}", (Object)roleId);
                }
            } else {
                log.error("Notified of completed container {} that is not in the list of active or failed containers", (Object)containerId);
                this.completionOfUnknownContainerEvent.incrementAndGet();
                result.unknownNode = true;
            }
        }
        if (result.surplusNode) {
            return result;
        }
        ContainerId id = status.getContainerId();
        log.info("Removing node ID {}", (Object)id);
        RoleInstance node = this.getLiveContainers().remove(id);
        if (node != null) {
            node.state = 5;
            node.exitCode = exitStatus;
            node.diagnostics = status.getDiagnostics();
            this.getCompletedContainers().put(id, node);
            result.roleInstance = node;
        } else {
            log.warn("Received notification of completion of unknown node {}", (Object)id);
            this.completionOfNodeNotInLiveListEvent.incrementAndGet();
        }
        this.removeOwnedContainer(containerId);
        assert (!this.containersBeingReleased.containsKey(containerId)) : "container still in release queue";
        assert (!this.getLiveContainers().containsKey(containerId)) : " container still in live nodes";
        assert (this.getOwnedContainer(containerId) == null) : "Container still in active container list";
        return result;
    }

    protected String getLogsURLForContainer(Container c) {
        if (c == null) {
            return null;
        }
        String user = null;
        try {
            user = SliderUtils.getCurrentUser().getShortUserName();
        }
        catch (IOException iOException) {}
        String completedLogsUrl = "";
        String url = this.logServerURL;
        if (user != null && SliderUtils.isSet(url)) {
            completedLogsUrl = String.valueOf(url) + "/" + c.getNodeId() + "/" + c.getId() + "/ctx/" + user;
        }
        return completedLogsUrl;
    }

    public synchronized float getApplicationProgressPercentage() {
        long desired = 0L;
        float actual = 0.0f;
        for (RoleStatus role : this.getRoleStatusMap().values()) {
            desired += role.getDesired();
            actual += (float)role.getActual();
        }
        float percentage = desired == 0L ? 100.0f : actual / (float)desired;
        return percentage;
    }

    public ClusterDescription refreshClusterStatus() {
        return this.refreshClusterStatus(null);
    }

    public synchronized ClusterDescription refreshClusterStatus(Map<String, String> providerStatus) {
        ClusterDescription cd = this.getClusterStatus();
        long now = this.now();
        cd.setInfoTime("status.time", "status.time.millis", now);
        if (providerStatus != null) {
            for (Map.Entry<String, String> entry : providerStatus.entrySet()) {
                cd.setInfo(entry.getKey(), entry.getValue());
            }
        }
        MapOperations infoOps = new MapOperations("info", cd.info);
        infoOps.mergeWithoutOverwrite(this.applicationInfo);
        SliderUtils.addBuildInfo(infoOps, "status");
        cd.statistics = new HashMap<String, Map<String, Integer>>();
        Map<String, List<String>> instanceMap = this.createRoleToInstanceMap();
        cd.instances = instanceMap;
        Map<String, Map<String, ClusterNode>> clusterNodes = this.createRoleToClusterNodeMap();
        cd.status = new HashMap<String, Object>();
        cd.status.put("live", clusterNodes);
        for (RoleStatus role : this.getRoleStatusMap().values()) {
            String rolename = role.getName();
            List<String> instances = instanceMap.get(rolename);
            int nodeCount = instances != null ? instances.size() : 0;
            cd.setRoleOpt(rolename, "yarn.component.instances", role.getDesired());
            cd.setRoleOpt(rolename, "role.actual.instances", nodeCount);
            cd.setRoleOpt(rolename, "role.requested.instances", role.getRequested());
            cd.setRoleOpt(rolename, "role.releasing.instances", role.getReleasing());
            cd.setRoleOpt(rolename, "role.failed.instances", role.getFailed());
            cd.setRoleOpt(rolename, "role.failed.starting.instances", role.getStartFailed());
            cd.setRoleOpt(rolename, "role.failed.recently.instances", role.getFailedRecently());
            cd.setRoleOpt(rolename, "role.failed.node.instances", role.getNodeFailed());
            cd.setRoleOpt(rolename, "role.failed.preempted.instances", role.getPreempted());
            if (role.isAntiAffinePlacement()) {
                cd.setRoleOpt(rolename, "role.pending.aa.instances", role.getPendingAntiAffineRequests());
            }
            Map<String, Integer> stats = role.buildStatistics();
            cd.statistics.put(rolename, stats);
        }
        Map<String, Integer> sliderstats = this.getLiveStatistics();
        cd.statistics.put("slider-appmaster", sliderstats);
        cd.liveness = this.getApplicationLivenessInformation();
        return cd;
    }

    public ApplicationLivenessInformation getApplicationLivenessInformation() {
        int outstanding;
        ApplicationLivenessInformation li = new ApplicationLivenessInformation();
        RoleStatistics stats = this.getRoleStatistics();
        li.requestsOutstanding = outstanding = (int)(stats.desired - stats.actual);
        li.allRequestsSatisfied = outstanding <= 0;
        li.activeRequests = (int)stats.requested;
        return li;
    }

    protected Map<String, Integer> getLiveStatistics() {
        HashMap<String, Integer> sliderstats = new HashMap<String, Integer>();
        sliderstats.put("containers.live", this.liveNodes.size());
        sliderstats.put("containers.completed", this.completedContainerCount.intValue());
        sliderstats.put("containers.failed", this.failedContainerCount.intValue());
        sliderstats.put("containers.start.started", this.startedContainers.intValue());
        sliderstats.put("containers.start.failed", this.startFailedContainerCount.intValue());
        sliderstats.put("containers.surplus", this.surplusContainers.intValue());
        sliderstats.put("containers.unknown.completed", this.completionOfUnknownContainerEvent.get());
        return sliderstats;
    }

    public RoleStatistics getRoleStatistics() {
        RoleStatistics stats = new RoleStatistics();
        for (RoleStatus role : this.getRoleStatusMap().values()) {
            stats.add(role.getStatistics());
        }
        return stats;
    }

    public Map<String, ComponentInformation> getComponentInfoSnapshot() {
        Map<Integer, RoleStatus> statusMap = this.getRoleStatusMap();
        HashMap<String, ComponentInformation> results = new HashMap<String, ComponentInformation>(statusMap.size());
        for (RoleStatus status : statusMap.values()) {
            String name = status.getName();
            ComponentInformation info = status.serialize();
            results.put(name, info);
        }
        return results;
    }

    public synchronized List<AbstractRMOperation> reviewRequestAndReleaseNodes() throws SliderInternalStateException, TriggerClusterTeardownException {
        log.debug("in reviewRequestAndReleaseNodes()");
        ArrayList<AbstractRMOperation> allOperations = new ArrayList<AbstractRMOperation>();
        for (RoleStatus roleStatus : this.getRoleStatusMap().values()) {
            if (roleStatus.isExcludeFromFlexing()) continue;
            List<AbstractRMOperation> operations = this.reviewOneRole(roleStatus);
            allOperations.addAll(operations);
        }
        return allOperations;
    }

    private void checkFailureThreshold(RoleStatus role) throws TriggerClusterTeardownException {
        long failures = role.getFailedRecently();
        int threshold = this.getFailureThresholdForRole(role);
        if (log.isDebugEnabled() && failures > 0L) {
            log.debug("Failure count of component: {}: {}, threshold={}", role.getName(), failures, threshold);
        }
        if (failures > (long)threshold) {
            throw new TriggerClusterTeardownException(72, FinalApplicationStatus.FAILED, "Unstable Application Instance : - failed with component %s failed 'recently' %d times (%d in startup); threshold is %d - last failure: %s", role.getName(), role.getFailed(), role.getStartFailed(), threshold, role.getFailureMessage());
        }
    }

    private int getFailureThresholdForRole(RoleStatus roleStatus) {
        ConfTreeOperations resources = this.instanceDefinition.getResourceOperations();
        return resources.getComponentOptInt(roleStatus.getName(), "yarn.container.failure.threshold", this.failureThreshold);
    }

    private int getNodeFailureThresholdForRole(String roleName) {
        ConfTreeOperations resources = this.instanceDefinition.getResourceOperations();
        return resources.getComponentOptInt(roleName, "yarn.node.failure.threshold", this.nodeFailureThreshold);
    }

    public void resetFailureCounts() {
        for (RoleStatus roleStatus : this.getRoleStatusMap().values()) {
            long failed = roleStatus.resetFailedRecently();
            log.info("Resetting failure count of {}; was {}", (Object)roleStatus.getName(), (Object)failed);
        }
        this.roleHistory.resetFailedRecently();
    }

    public List<AbstractRMOperation> escalateOutstandingRequests() {
        return this.roleHistory.escalateOutstandingRequests();
    }

    public synchronized List<AbstractRMOperation> cancelOutstandingAARequests() {
        List<AbstractRMOperation> operations = this.roleHistory.cancelOutstandingAARequests();
        for (RoleStatus roleStatus : this.roleStatusMap.values()) {
            if (!roleStatus.isAARequestOutstanding()) continue;
            log.info("Cancelling outstanding AA request for {}", (Object)roleStatus);
            roleStatus.cancelOutstandingAARequest();
        }
        return operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractRMOperation> reviewOneRole(RoleStatus role) throws SliderInternalStateException, TriggerClusterTeardownException {
        long expected;
        long delta;
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>();
        String name = role.getName();
        RoleStatus roleStatus = role;
        synchronized (roleStatus) {
            delta = role.getDelta();
            expected = role.getDesired();
        }
        log.info("Reviewing {} : ", (Object)role);
        log.debug("Expected {}, Delta: {}", (Object)expected, (Object)delta);
        this.checkFailureThreshold(role);
        if (expected < 0L) {
            throw new TriggerClusterTeardownException(72, FinalApplicationStatus.FAILED, "Negative component count of %d desired for component %s", expected, role);
        }
        if (delta > 0L) {
            log.info("{}: Asking for {} more nodes(s) for a total of {} ", name, delta, expected);
            if (role.isAntiAffinePlacement()) {
                long pending = delta;
                if (this.roleHistory.canPlaceAANodes()) {
                    if (!role.isAARequestOutstanding()) {
                        AMRMClient.ContainerRequest request = this.createAAContainerRequest(role);
                        if (request != null) {
                            log.info("Starting an anti-affine request sequence for {} nodes; pending={}", (Object)delta, (Object)(--pending));
                            this.addContainerRequest(operations, request);
                        } else {
                            log.info("No location for anti-affine request");
                        }
                    }
                } else {
                    log.warn("Awaiting node map before generating anti-affinity requests");
                }
                log.info("Setting pending to {}", (Object)pending);
                role.setPendingAntiAffineRequests(pending);
            } else {
                int i = 0;
                while ((long)i < delta) {
                    this.addContainerRequest(operations, this.createContainerRequest(role));
                    ++i;
                }
            }
        } else if (delta < 0L) {
            log.info("{}: Asking for {} fewer node(s) for a total of {}", name, -delta, expected);
            long excess = -delta;
            long outstandingRequests = role.getRequested() + role.getPendingAntiAffineRequests();
            if (outstandingRequests > 0L) {
                int toCancel = (int)Math.min(outstandingRequests, excess);
                List<AbstractRMOperation> cancellations = this.roleHistory.cancelRequestsForRole(role, toCancel);
                log.info("Found {} outstanding requests to cancel", (Object)cancellations.size());
                operations.addAll(cancellations);
                if (toCancel != cancellations.size()) {
                    log.error("Tracking of outstanding requests is not in sync with the summary statistics: expected to be able to cancel {} requests, but got {}", (Object)toCancel, (Object)cancellations.size());
                }
                role.cancel(toCancel);
                assert ((excess -= (long)toCancel) >= 0L) : "Attempted to cancel too many requests";
                log.info("Submitted {} cancellations, leaving {} to release", (Object)toCancel, (Object)excess);
                if (excess == 0L) {
                    log.info("After cancelling requests, application is now at desired size");
                }
            }
            if (excess > 0L) {
                int roleId = role.getKey();
                List<RoleInstance> containersToRelease = this.enumNodesWithRoleId(roleId, true);
                if (containersToRelease.isEmpty()) {
                    log.info("No containers for component {}", (Object)roleId);
                }
                ListIterator<RoleInstance> li = containersToRelease.listIterator();
                while (li.hasNext()) {
                    RoleInstance next = li.next();
                    if (!next.released) continue;
                    li.remove();
                }
                int numberAvailableForRelease = containersToRelease.size();
                if ((long)numberAvailableForRelease < excess) {
                    log.warn("Not enough containers to release, have {} and need {} more", (Object)numberAvailableForRelease, (Object)(excess - (long)numberAvailableForRelease));
                }
                containersToRelease = this.containerReleaseSelector.sortCandidates(roleId, containersToRelease);
                List<RoleInstance> finalCandidates = excess < (long)numberAvailableForRelease ? containersToRelease.subList(0, (int)excess) : containersToRelease;
                for (RoleInstance possible : finalCandidates) {
                    log.info("Targeting for release: {}", (Object)possible);
                    this.containerReleaseSubmitted(possible.container);
                    operations.add(new ContainerReleaseOperation(possible.getId()));
                }
            }
        } else if (role.getPendingAntiAffineRequests() > 0L) {
            log.debug("Clearing outstanding pending AA requests");
            role.setPendingAntiAffineRequests(0L);
        }
        log.debug("operations scheduled: {}; updated role: {}", (Object)operations.size(), (Object)role);
        return operations;
    }

    private boolean addContainerRequest(List<AbstractRMOperation> operations, AMRMClient.ContainerRequest containerAsk) {
        if (containerAsk != null) {
            log.info("Container ask is {} and label = {}", (Object)containerAsk, (Object)containerAsk.getNodeLabelExpression());
            int askMemory = containerAsk.getCapability().getMemory();
            if (askMemory > this.containerMaxMemory) {
                log.warn("Memory requested: {} > max of {}", (Object)askMemory, (Object)this.containerMaxMemory);
            }
            operations.add(new ContainerRequestOperation(containerAsk));
            return true;
        }
        return false;
    }

    public List<AbstractRMOperation> releaseContainer(ContainerId containerId) throws SliderInternalStateException {
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>();
        List<RoleInstance> activeRoleInstances = this.cloneOwnedContainerList();
        for (RoleInstance role : activeRoleInstances) {
            if (!role.container.getId().equals((Object)containerId)) continue;
            this.containerReleaseSubmitted(role.container);
            operations.add(new ContainerReleaseOperation(role.getId()));
        }
        return operations;
    }

    private RoleInstance findRoleInstanceOnHost(NodeInstance node, int roleId) {
        List<RoleInstance> targets = this.cloneOwnedContainerList();
        String hostname = node.hostname;
        for (RoleInstance ri : targets) {
            if (!hostname.equals(RoleHistoryUtils.hostnameOf(ri.container)) || ri.roleId != roleId || this.containersBeingReleased.get(ri.getContainerId()) != null) continue;
            return ri;
        }
        return null;
    }

    public synchronized List<AbstractRMOperation> releaseAllContainers() {
        List<RoleInstance> targets = this.cloneOwnedContainerList();
        log.info("Releasing {} containers", (Object)targets.size());
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>(targets.size());
        for (RoleInstance instance : targets) {
            if (instance.roleId == 0) continue;
            Container possible = instance.container;
            ContainerId id = possible.getId();
            if (instance.released) continue;
            String url = this.getLogsURLForContainer(possible);
            log.info("Releasing container. Log: " + url);
            try {
                this.containerReleaseSubmitted(possible);
            }
            catch (SliderInternalStateException e) {
                log.warn("when releasing container {} :", (Object)possible, (Object)e);
            }
            operations.add(new ContainerReleaseOperation(id));
        }
        return operations;
    }

    public synchronized void onContainersAllocated(List<Container> allocatedContainers, List<ContainerAssignment> assignments, List<AbstractRMOperation> operations) {
        assignments.clear();
        operations.clear();
        List<Container> ordered = this.roleHistory.prepareAllocationList(allocatedContainers);
        log.debug("onContainersAllocated(): Total containers allocated = {}", (Object)ordered.size());
        for (Container container : ordered) {
            NodeId nodeId = container.getNodeId();
            String containerHostInfo = String.valueOf(nodeId.getHost()) + ":" + nodeId.getPort();
            ContainerId cid = container.getId();
            RoleStatus role = this.lookupRoleStatus(container);
            role.decRequested();
            long allocated = role.incActual();
            long desired = role.getDesired();
            String roleName = role.getName();
            ContainerAllocationResults allocation = this.roleHistory.onContainerAllocated(container, desired, allocated);
            ContainerAllocationOutcome outcome = allocation.outcome;
            operations.addAll(allocation.operations);
            if (allocated > desired) {
                log.info("Discarding surplus {} container {} on {}", roleName, cid, containerHostInfo);
                operations.add(new ContainerReleaseOperation(cid));
                this.surplusNodes.add(cid);
                this.surplusContainers.inc();
                role.decActual();
                continue;
            }
            this.decOutstandingContainerRequests();
            log.info("Assigning role {} to container {}, on {}:{},", roleName, cid, nodeId.getHost(), nodeId.getPort());
            assignments.add(new ContainerAssignment(container, role, outcome));
            this.roleHistory.onContainerAssigned(container);
            if (!role.isAntiAffinePlacement()) continue;
            role.completeOutstandingAARequest();
            NodeInstance node = this.roleHistory.getOrCreateNodeInstance(container);
            if (node.canHost(role.getKey(), role.getLabelExpression())) {
                log.error("Assigned node still declares as available {}", (Object)node.toFullString());
            }
            if (role.getPendingAntiAffineRequests() > 0L) {
                log.info("Asking for next container for AA role {}", (Object)roleName);
                if (!this.addContainerRequest(operations, this.createAAContainerRequest(role))) {
                    log.info("No capacity in cluster for new requests");
                } else {
                    role.decPendingAntiAffineRequests();
                }
                log.debug("Current AA role status {}", (Object)role);
                continue;
            }
            log.info("AA request sequence completed for role {}", (Object)role);
        }
    }

    public String getContainerDiagnosticInfo() {
        StringBuilder builder = new StringBuilder();
        for (RoleStatus roleStatus : this.getRoleStatusMap().values()) {
            builder.append(roleStatus).append('\n');
        }
        return builder.toString();
    }

    private boolean rebuildModelFromRestart(List<Container> liveContainers) throws BadClusterStateException {
        if (liveContainers == null) {
            return false;
        }
        for (Container container : liveContainers) {
            this.addRestartedContainer(container);
        }
        this.clusterStatus.setInfo("containers.at.am-restart", Integer.toString(liveContainers.size()));
        return true;
    }

    private void addRestartedContainer(Container container) throws BadClusterStateException {
        String containerHostInfo = String.valueOf(container.getNodeId().getHost()) + ":" + container.getNodeId().getPort();
        ContainerId cid = container.getId();
        int roleId = ContainerPriority.extractRole(container);
        RoleStatus role = this.lookupRoleStatus(roleId);
        role.incActual();
        String roleName = role.getName();
        log.info("Rebuilding container {} in role {} on {},", cid, roleName, containerHostInfo);
        RoleInstance instance = new RoleInstance(container);
        instance.command = roleName;
        instance.role = roleName;
        instance.roleId = roleId;
        instance.environment = new String[0];
        instance.container = container;
        instance.createTime = this.now();
        instance.state = 3;
        instance.appVersion = "awaiting heartbeat...";
        this.putOwnedContainer(cid, instance);
        this.roleHistory.onContainerAssigned(container);
        this.containerStartSubmitted(container, instance);
        this.innerOnNodeManagerContainerStarted(cid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AppState{");
        sb.append("applicationLive=").append(this.applicationLive);
        sb.append(", live nodes=").append(this.liveNodes.size());
        sb.append(", startedContainers=").append(this.startedContainers);
        sb.append(", startFailedContainerCount=").append(this.startFailedContainerCount);
        sb.append(", surplusContainers=").append(this.surplusContainers);
        sb.append(", failedContainerCount=").append(this.failedContainerCount);
        sb.append(", outstanding non-AA Container Requests=").append(this.outstandingContainerRequests);
        sb.append('}');
        return sb.toString();
    }

    public Map<Integer, String> buildNamingMap() {
        Map<Integer, RoleStatus> statusMap = this.getRoleStatusMap();
        HashMap<Integer, String> naming = new HashMap<Integer, String>(statusMap.size());
        for (Map.Entry<Integer, RoleStatus> entry : statusMap.entrySet()) {
            naming.put(entry.getKey(), entry.getValue().getName());
        }
        return naming;
    }

    public static class NodeCompletionResult {
        public boolean surplusNode = false;
        public RoleInstance roleInstance;
        public boolean containerFailed = false;
        public ContainerOutcome outcome = ContainerOutcome.Completed;
        public int exitStatus = 0;
        public boolean unknownNode = false;

        public String toString() {
            StringBuilder sb = new StringBuilder("NodeCompletionResult{");
            sb.append("surplusNode=").append(this.surplusNode);
            sb.append(", roleInstance=").append(this.roleInstance);
            sb.append(", exitStatus=").append(this.exitStatus);
            sb.append(", containerFailed=").append(this.containerFailed);
            sb.append(", outcome=").append((Object)this.outcome);
            sb.append(", unknownNode=").append(this.unknownNode);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class NodeUpdatedOutcome {
        public final boolean clusterChanged;
        public final List<AbstractRMOperation> operations;

        public NodeUpdatedOutcome(boolean clusterChanged, List<AbstractRMOperation> operations) {
            this.clusterChanged = clusterChanged;
            this.operations = operations;
        }
    }
}

