/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.monkey;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.slider.server.appmaster.monkey.ChaosTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosEntry {
    protected static final Logger log = LoggerFactory.getLogger(ChaosEntry.class);
    public final String name;
    public final ChaosTarget target;
    public final long probability;
    private final Counter invocationCounter;

    public ChaosEntry(String name, ChaosTarget target, long probability, MetricRegistry metrics) {
        Preconditions.checkArgument(!StringUtils.isEmpty(name), "missing name");
        Preconditions.checkArgument(target != null, "null target");
        Preconditions.checkArgument(probability > 0L, "negative probability");
        Preconditions.checkArgument(probability <= 10000L, "probability over 100%: " + probability);
        this.name = name;
        this.target = target;
        this.probability = probability;
        this.invocationCounter = metrics.counter(MetricRegistry.name(ChaosEntry.class, name));
    }

    public void invokeChaos() {
        log.info("Invoking {}", (Object)this.name);
        this.invocationCounter.inc();
        this.target.chaosAction();
    }

    public boolean maybeInvokeChaos(long value) {
        log.debug("Probability {} trigger={}", (Object)this.probability, (Object)value);
        if (value < this.probability) {
            this.invokeChaos();
            return true;
        }
        return false;
    }
}

