/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.slider.providers.agent.Command;
import org.apache.slider.providers.agent.CommandResult;
import org.apache.slider.providers.agent.ContainerState;
import org.apache.slider.providers.agent.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInstanceState {
    public static final Logger log = LoggerFactory.getLogger(ComponentInstanceState.class);
    private static int MAX_FAILURE_TOLERATED = 3;
    private static String INVALID_TRANSITION_ERROR = "Result %s for command %s is not expected for component %s in state %s.";
    private final String componentName;
    private final ContainerId containerId;
    private final String containerIdAsString;
    private final String applicationId;
    private State state = State.INIT;
    private State targetState = State.STARTED;
    private int failuresSeen = 0;
    private Boolean configReported = false;
    private long lastHeartbeat = 0L;
    private ContainerState containerState;
    private Map<String, State> pkgStatuses;
    private String nextPkgToInstall;
    private boolean stopInitiated;

    public ComponentInstanceState(String componentName, ContainerId containerId, String applicationId) {
        this(componentName, containerId, applicationId, new TreeMap<String, State>());
    }

    public ComponentInstanceState(String componentName, ContainerId containerId, String applicationId, Map<String, State> pkgStatuses) {
        this.componentName = componentName;
        this.containerId = containerId;
        this.containerIdAsString = containerId.toString();
        this.applicationId = applicationId;
        this.containerState = ContainerState.INIT;
        this.lastHeartbeat = System.currentTimeMillis();
        this.pkgStatuses = pkgStatuses;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Boolean getConfigReported() {
        return this.configReported;
    }

    public void setConfigReported(Boolean configReported) {
        this.configReported = configReported;
    }

    public ContainerState getContainerState() {
        return this.containerState;
    }

    public void setContainerState(ContainerState containerState) {
        this.containerState = containerState;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public ContainerState heartbeat(long heartbeatTime) {
        this.lastHeartbeat = heartbeatTime;
        if (this.containerState == ContainerState.UNHEALTHY || this.containerState == ContainerState.INIT) {
            this.containerState = ContainerState.HEALTHY;
        }
        return this.containerState;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public void commandIssued(Command command) {
        this.commandIssued(command, false);
    }

    public void commandIssued(Command command, boolean isInUpgradeMode) {
        Command expected = this.getNextCommand(isInUpgradeMode);
        if (expected != command) {
            throw new IllegalArgumentException("Command " + (Object)((Object)command) + " is not allowed in state " + (Object)((Object)this.state));
        }
        if (expected == Command.INSTALL_ADDON) {
            State currentState = this.pkgStatuses.get(this.nextPkgToInstall);
            log.debug("Command issued: component: {} is in {}", (Object)this.componentName, (Object)currentState);
            State nextState = currentState.getNextState(command);
            this.pkgStatuses.put(this.nextPkgToInstall, nextState);
            log.debug("Command issued: component: {} is now in {}", (Object)this.componentName, (Object)nextState);
        } else {
            this.state = this.state.getNextState(command);
        }
    }

    public void applyCommandResult(CommandResult result, Command command, String pkg) {
        if (StringUtils.isNotEmpty(pkg) && !"MASTER".equals(pkg)) {
            log.debug("This result is for component: {} pkg: {}", (Object)this.componentName, (Object)pkg);
            State previousPkgState = this.pkgStatuses.get(pkg);
            log.debug("Currently component: {} pkg: {} is in state: {}", this.componentName, pkg, previousPkgState.toString());
            State nextPkgState = previousPkgState.getNextState(result);
            this.pkgStatuses.put(pkg, nextPkgState);
            log.debug("Component: {} pkg: {} next state: {}", new Object[]{this.componentName, pkg, nextPkgState});
        } else {
            log.debug("This result is for component: {} master package", (Object)this.componentName);
            this.applyCommandResult(result, command);
        }
    }

    public void applyCommandResult(CommandResult result, Command command) {
        if (!this.state.couldHaveIssued(command)) {
            throw new IllegalStateException("Invalid command " + (Object)((Object)command) + " for state " + (Object)((Object)this.state));
        }
        try {
            if (result == CommandResult.FAILED) {
                ++this.failuresSeen;
            } else if (result == CommandResult.COMPLETED) {
                this.failuresSeen = 0;
            }
            this.state = this.state.getNextState(result);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String message = String.format(INVALID_TRANSITION_ERROR, result.toString(), command.toString(), this.componentName, this.state.toString());
            log.warn(message);
            throw new IllegalStateException(message);
        }
    }

    public boolean hasPendingCommand() {
        return this.state.canIssueCommands() && this.state != this.targetState && this.failuresSeen < MAX_FAILURE_TOLERATED;
    }

    public Command getNextCommand() {
        return this.getNextCommand(false);
    }

    public Command getNextCommand(boolean isInUpgradeMode) {
        if (!this.hasPendingCommand()) {
            this.nextPkgToInstall = null;
            return Command.NOP;
        }
        log.debug("In getNextCommand, checking for component: {} ", (Object)this.componentName);
        this.nextPkgToInstall = null;
        if (this.state == State.INSTALLED) {
            for (Map.Entry<String, State> pkgStatus : this.pkgStatuses.entrySet()) {
                String pkg = pkgStatus.getKey();
                State pkgState = pkgStatus.getValue();
                log.debug("In getNextCommand, pkg: {} is in {}", (Object)pkg, (Object)pkgState);
                if (pkgState == State.INSTALLING) {
                    log.debug("In getNextCommand, pkg: {} we are issuing NOP", (Object)pkg);
                    this.nextPkgToInstall = pkg;
                    return Command.NOP;
                }
                if (pkgState != State.INIT) continue;
                this.nextPkgToInstall = pkg;
            }
            if (this.nextPkgToInstall != null) {
                log.debug("In getNextCommand, pkg: {} we are issuing install addon", (Object)this.nextPkgToInstall);
                return Command.INSTALL_ADDON;
            }
        }
        return this.state.getSupportedCommand(isInUpgradeMode, this.stopInitiated);
    }

    public State getState() {
        return this.state;
    }

    @VisibleForTesting
    protected void setState(State state) {
        this.state = state;
    }

    public State getTargetState() {
        return this.targetState;
    }

    public void setTargetState(State targetState) {
        this.targetState = targetState;
    }

    public String getNextPkgToInstall() {
        return this.nextPkgToInstall;
    }

    public boolean isStopInitiated() {
        return this.stopInitiated;
    }

    public void setStopInitiated(boolean stopInitiated) {
        this.stopInitiated = stopInitiated;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode ^= this.componentName != null ? this.componentName.hashCode() : 0;
        hashCode ^= this.containerIdAsString != null ? this.containerIdAsString.hashCode() : 0;
        return hashCode ^= this.applicationId != null ? this.applicationId.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInstanceState that = (ComponentInstanceState)o;
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : this.componentName != null) {
            return false;
        }
        if (this.containerIdAsString != null ? !this.containerIdAsString.equals(that.containerIdAsString) : this.containerIdAsString != null) {
            return false;
        }
        return !(this.applicationId != null ? !this.applicationId.equals(that.applicationId) : this.applicationId != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ComponentInstanceState{");
        sb.append("containerIdAsString='").append(this.containerIdAsString).append('\'');
        sb.append(", state=").append((Object)this.state);
        sb.append(", failuresSeen=").append(this.failuresSeen);
        sb.append(", lastHeartbeat=").append(this.lastHeartbeat);
        sb.append(", containerState=").append((Object)this.containerState);
        sb.append(", componentName='").append(this.componentName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

