/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import java.io.IOException;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.common.tools.Duration;

public class LaunchedApplication {
    protected final ApplicationId applicationId;
    protected final SliderYarnClientImpl yarnClient;

    public LaunchedApplication(ApplicationId applicationId, SliderYarnClientImpl yarnClient) {
        assert (applicationId != null);
        assert (yarnClient != null);
        this.applicationId = applicationId;
        this.yarnClient = yarnClient;
    }

    public LaunchedApplication(SliderYarnClientImpl yarnClient, ApplicationReport report) {
        this.yarnClient = yarnClient;
        this.applicationId = report.getApplicationId();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationReport monitorAppToState(YarnApplicationState desiredState, Duration duration) throws YarnException, IOException {
        return this.yarnClient.monitorAppToState(this.applicationId, desiredState, duration);
    }

    public boolean forceKill(String reason) throws YarnException, IOException {
        if (this.applicationId != null) {
            this.yarnClient.killRunningApplication(this.applicationId, reason);
            return true;
        }
        return false;
    }

    public KillApplicationResponse kill(String reason) throws YarnException, IOException {
        return this.yarnClient.killRunningApplication(this.applicationId, reason);
    }

    public ApplicationReport getApplicationReport() throws YarnException, IOException {
        return this.yarnClient.getApplicationReport(this.applicationId);
    }
}

