/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.slider.common.tools.SliderUtils;

public class CommandLineBuilder {
    protected final List<String> argumentList = new ArrayList<String>(20);

    public void add(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            this.argumentList.add(arg.toString());
            ++n2;
        }
    }

    public String elt(int offset) {
        return this.argumentList.get(offset);
    }

    public int size() {
        return this.argumentList.size();
    }

    public void addOutAndErrFiles(String stdout, String stderr) {
        Preconditions.checkNotNull(stdout, "Null output file");
        Preconditions.checkState(!stdout.isEmpty(), "output filename invalid");
        this.argumentList.add("1><LOG_DIR>/" + stdout);
        if (stderr != null) {
            this.argumentList.add("2><LOG_DIR>/" + stderr);
        } else {
            this.argumentList.add("2>&1");
        }
    }

    public String toString() {
        return this.build();
    }

    public String build() {
        return SliderUtils.join(this.argumentList, " ");
    }

    public List<String> getArgumentList() {
        return this.argumentList;
    }
}

