/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.QueueManagementChangeEvent;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueManagementDynamicEditPolicy
implements SchedulingEditPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QueueManagementDynamicEditPolicy.class);
    private Clock clock;
    private RMContext rmContext;
    private ResourceCalculator rc;
    private CapacityScheduler scheduler;
    private RMNodeLabelsManager nlm;
    private long monitoringInterval;
    private Set<String> managedParentQueues = new HashSet<String>();

    public QueueManagementDynamicEditPolicy() {
        this.clock = SystemClock.getInstance();
    }

    @VisibleForTesting
    public QueueManagementDynamicEditPolicy(RMContext context, CapacityScheduler scheduler) {
        this.init(context.getYarnConfiguration(), context, scheduler);
    }

    @VisibleForTesting
    public QueueManagementDynamicEditPolicy(RMContext context, CapacityScheduler scheduler, Clock clock) {
        this.init(context.getYarnConfiguration(), context, scheduler);
        this.clock = clock;
    }

    @Override
    public void init(Configuration config, RMContext context, ResourceScheduler sched) {
        LOG.info("Queue Management Policy monitor: {}" + this.getClass().getCanonicalName());
        assert (null == this.scheduler) : "Unexpected duplicate call to init";
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + sched.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.rmContext = context;
        this.scheduler = (CapacityScheduler)sched;
        this.clock = this.scheduler.getClock();
        this.rc = this.scheduler.getResourceCalculator();
        this.nlm = this.scheduler.getRMContext().getNodeLabelManager();
        CapacitySchedulerConfiguration csConfig = this.scheduler.getConfiguration();
        this.monitoringInterval = csConfig.getLong("yarn.resourcemanager.monitor.capacity.queue-management.monitoring-interval", 1500L);
        this.initQueues();
    }

    public void reinitialize(Configuration config, RMContext context, ResourceScheduler sched) {
        this.initQueues();
    }

    private void initQueues() {
        this.managedParentQueues.clear();
        for (Map.Entry<String, CSQueue> queues : this.scheduler.getCapacitySchedulerQueueManager().getQueues().entrySet()) {
            String queueName = queues.getKey();
            CSQueue queue = queues.getValue();
            if (!(queue instanceof ManagedParentQueue)) continue;
            this.managedParentQueues.add(queueName);
        }
    }

    @Override
    public void editSchedule() {
        long startTs = this.clock.getTime();
        this.initQueues();
        this.manageAutoCreatedLeafQueues();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total time used=" + (this.clock.getTime() - startTs) + " ms.");
        }
    }

    @VisibleForTesting
    List<QueueManagementChange> manageAutoCreatedLeafQueues() {
        ArrayList<QueueManagementChange> queueManagementChanges = new ArrayList<QueueManagementChange>();
        if (this.managedParentQueues.size() > 0) {
            for (String parentQueueName : this.managedParentQueues) {
                ManagedParentQueue parentQueue = (ManagedParentQueue)this.scheduler.getCapacitySchedulerQueueManager().getQueue(parentQueueName);
                queueManagementChanges.addAll(this.computeQueueManagementChanges(parentQueue));
            }
        }
        return queueManagementChanges;
    }

    @VisibleForTesting
    List<QueueManagementChange> computeQueueManagementChanges(ManagedParentQueue parentQueue) {
        List<QueueManagementChange> queueManagementChanges;
        block7: {
            queueManagementChanges = Collections.emptyList();
            if (!parentQueue.shouldFailAutoCreationWhenGuaranteedCapacityExceeded()) {
                AutoCreatedQueueManagementPolicy policyClazz = parentQueue.getAutoCreatedQueueManagementPolicy();
                long startTime = 0L;
                try {
                    startTime = this.clock.getTime();
                    queueManagementChanges = policyClazz.computeQueueManagementChanges();
                    if (queueManagementChanges.size() > 0) {
                        QueueManagementChangeEvent queueManagementChangeEvent = new QueueManagementChangeEvent(parentQueue, queueManagementChanges);
                        this.scheduler.getRMContext().getDispatcher().getEventHandler().handle((Event)queueManagementChangeEvent);
                    }
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("{} uses {} millisecond to run", (Object)policyClazz.getClass().getName(), (Object)(this.clock.getTime() - startTime));
                    if (queueManagementChanges.size() > 0) {
                        LOG.debug(" Updated queue management changes for parent queue {}: [{}]", (Object)parentQueue.getQueueName(), queueManagementChanges.size() < 25 ? queueManagementChanges.toString() : Integer.valueOf(queueManagementChanges.size()));
                    }
                }
                catch (YarnException e) {
                    LOG.error("Could not compute child queue management updates for parent queue " + parentQueue.getQueueName(), (Throwable)e);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping queue management updates for parent queue " + parentQueue.getQueuePath() + " since configuration for auto creating queues beyond parent's guaranteed capacity is disabled");
            }
        }
        return queueManagementChanges;
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return "QueueManagementDynamicEditPolicy";
    }

    public ResourceCalculator getResourceCalculator() {
        return this.rc;
    }

    public RMContext getRmContext() {
        return this.rmContext;
    }

    public ResourceCalculator getRC() {
        return this.rc;
    }

    public CapacityScheduler getScheduler() {
        return this.scheduler;
    }

    public Set<String> getManagedParentQueues() {
        return this.managedParentQueues;
    }
}

