/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;

public class RMSecretManagerService
extends AbstractService {
    AMRMTokenSecretManager amRmTokenSecretManager;
    NMTokenSecretManagerInRM nmTokenSecretManager;
    ClientToAMTokenSecretManagerInRM clientToAMSecretManager;
    RMContainerTokenSecretManager containerTokenSecretManager;
    RMDelegationTokenSecretManager rmDTSecretManager;
    RMContextImpl rmContext;

    public RMSecretManagerService(Configuration conf, RMContextImpl rmContext) {
        super(RMSecretManagerService.class.getName());
        this.rmContext = rmContext;
        this.nmTokenSecretManager = this.createNMTokenSecretManager(conf);
        rmContext.setNMTokenSecretManager(this.nmTokenSecretManager);
        this.containerTokenSecretManager = this.createContainerTokenSecretManager(conf);
        rmContext.setContainerTokenSecretManager(this.containerTokenSecretManager);
        this.clientToAMSecretManager = this.createClientToAMTokenSecretManager();
        rmContext.setClientToAMTokenSecretManager(this.clientToAMSecretManager);
        this.amRmTokenSecretManager = this.createAMRMTokenSecretManager(conf, this.rmContext);
        rmContext.setAMRMTokenSecretManager(this.amRmTokenSecretManager);
        this.rmDTSecretManager = this.createRMDelegationTokenSecretManager(conf, rmContext);
        rmContext.setRMDelegationTokenSecretManager(this.rmDTSecretManager);
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        this.amRmTokenSecretManager.start();
        this.containerTokenSecretManager.start();
        this.nmTokenSecretManager.start();
        try {
            this.rmDTSecretManager.startThreads();
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to start secret manager threads", (Throwable)ie);
        }
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        if (this.rmDTSecretManager != null) {
            this.rmDTSecretManager.stopThreads();
        }
        if (this.amRmTokenSecretManager != null) {
            this.amRmTokenSecretManager.stop();
        }
        if (this.containerTokenSecretManager != null) {
            this.containerTokenSecretManager.stop();
        }
        if (this.nmTokenSecretManager != null) {
            this.nmTokenSecretManager.stop();
        }
        super.serviceStop();
    }

    protected RMContainerTokenSecretManager createContainerTokenSecretManager(Configuration conf) {
        return new RMContainerTokenSecretManager(conf);
    }

    protected NMTokenSecretManagerInRM createNMTokenSecretManager(Configuration conf) {
        return new NMTokenSecretManagerInRM(conf);
    }

    protected AMRMTokenSecretManager createAMRMTokenSecretManager(Configuration conf, RMContext rmContext) {
        return new AMRMTokenSecretManager(conf, rmContext);
    }

    protected ClientToAMTokenSecretManagerInRM createClientToAMTokenSecretManager() {
        return new ClientToAMTokenSecretManagerInRM();
    }

    @VisibleForTesting
    protected RMDelegationTokenSecretManager createRMDelegationTokenSecretManager(Configuration conf, RMContext rmContext) {
        long secretKeyInterval = conf.getLong("yarn.resourcemanager.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.resourcemanager.delegation.token.renew-interval", 86400000L);
        return new RMDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L, rmContext);
    }
}

