/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;

final class AuxiliaryServiceWithCustomClassLoader
extends AuxiliaryService {
    private final AuxiliaryService wrapped;
    private final ClassLoader customClassLoader;

    private AuxiliaryServiceWithCustomClassLoader(String name, AuxiliaryService wrapped, ClassLoader customClassLoader) {
        super(name);
        this.wrapped = wrapped;
        this.customClassLoader = customClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceInit(Configuration conf) throws Exception {
        Configuration config = new Configuration(conf);
        this.setConfig(config);
        config.setClassLoader(this.customClassLoader);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.init(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void serviceStart() throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void serviceStop() throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.stop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void initializeApplication(ApplicationInitializationContext initAppContext) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.initializeApplication(initAppContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void stopApplication(ApplicationTerminationContext stopAppContext) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.stopApplication(stopAppContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ByteBuffer getMetaData() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            ByteBuffer byteBuffer = this.wrapped.getMetaData();
            return byteBuffer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void initializeContainer(ContainerInitializationContext initContainerContext) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.initializeContainer(initContainerContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void stopContainer(ContainerTerminationContext stopContainerContext) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.stopContainer(stopContainerContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void setRecoveryPath(Path recoveryPath) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            this.wrapped.setRecoveryPath(recoveryPath);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static AuxiliaryServiceWithCustomClassLoader getInstance(Configuration conf, String className, String appClassPath) throws IOException, ClassNotFoundException {
        String[] systemClasses = conf.getTrimmedStrings(String.format("yarn.nodemanager.aux-services.%s.system-classes", className));
        ClassLoader customClassLoader = AuxiliaryServiceWithCustomClassLoader.createAuxServiceClassLoader(appClassPath, systemClasses);
        Class<?> clazz = Class.forName(className, true, customClassLoader);
        Class<AuxiliaryService> sClass = clazz.asSubclass(AuxiliaryService.class);
        AuxiliaryService wrapped = (AuxiliaryService)ReflectionUtils.newInstance(sClass, (Configuration)conf);
        return new AuxiliaryServiceWithCustomClassLoader(className + " with custom class loader", wrapped, customClassLoader);
    }

    private static ClassLoader createAuxServiceClassLoader(final String appClasspath, final String[] systemClasses) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws MalformedURLException {
                    return new ApplicationClassLoader(appClasspath, AuxServices.class.getClassLoader(), Arrays.asList(systemClasses));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof MalformedURLException) {
                throw (MalformedURLException)t;
            }
            throw new IOException(e);
        }
    }
}

